"use strict";

(function(window, undefined) {   

  if(window.iw === undefined) window.iw = {};
   
  iw.aboutApp = Vue.createApp({
      
    el: '#about-app',
    
    data : function() {
      return {     
        license        : {
          product             : "IwTest",
          version             : "1.*",
          licensee            : "",
          type                : "",
          "valid-until"       : "",
          "valid-until-ts"    : -1,
          valid               : true,
          expired             : false,
          "version-ok"        : true,
          "days-left"         : -1,
          features            : []
        },
        
        product :  {
          name                    : "",
          version                 : "",
          "latest-version"        : "",
          "latest-version-newer"  : "",
          "latest-check-date"     : "",
          "installation-date"     : "",
          "installation-ts"       : 0
        },        
        
        showTextArea : false,
        
        showreleasenotesdiv : false,
        
        releasenotes : "",
        
        installationPollerInterval_ms : 1000,
        
        installationPollerTimeout_s   : 30,
        
        licenseText : "",
        
        success: true,
        
        message: "",
        
        config : {}
      }
    },
    
    computed : {
      features : function() {
        return this.license.features.join("; ");
      },
      
      installationDate : function() {
         let d = new Date(this.product['installation-ts']);
         return "" + d.getFullYear() + "-" + String(d.getMonth() + 1 ).padStart(2, "0") + "-" + String(d.getDate()).padStart(2, "0") ;
      },
      updateAvailable : function() {
          return this.product["latest-version"] > this.product.version;
      }
    },
    
    methods : {
      //Use this function for showing the result of actions, not for data retrieval
      response :function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(JSON.stringify(data), 4);
         iw.about.showMessage(data["$message"], data["$success"] === "true" , 2500);        

      },
    
      error : function(msg) { 
        iw.log(msg, 0);
        iw.about.showMessage(msg, false , 3000);       
      },
    
      showMessage : function(msg, success, timeout) {  
         iw.about.message = msg;
         iw.about.success = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.about.message=""}, timeout);

         }
      }, 
              
      hideMessage : function() {
        this.message = "";
      },
    
      getInfo : function() {        
        iw.invoke("iw.test.admin:info",{}, function(data){
          iw.about.license = data.license;
          iw.about.product = data.product;
          
        }, this.error);        
      },
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.about.config = data;          
        });        
      },
      
      checkForUpdate : function() {
        iw.log("Checking for update...", 3);
        iw.invoke("iw.test.admin:checkForUpdate",{}, function(data){
         if(data.$success === "true") {
            if(data["update-available"] === "true") {
              iw.about.showMessage("Version " + data["available-version"] + " is now available for download", true, 5000);
              iw.about.getInfo();
            } else {
              iw.about.showMessage("You're already at the latest version", true, 5000);
            }
         } else {
            iw.about.showMessage(data.$message, false, 5000); 
         }
        }, this.error);     
      },
      
      downloadAndInstall : function() {
        iw.invoke("iw.test.admin:downloadAndInstall",{}, function(data){
             //The installation happens really asynchronously: installing IwTest itself
             //is done via a scheduled service.
         }, this.error);     
         
         //start by showing a progress message
         this.success = true;
         this.message = "Downloading and installing ...";
         
         //Set up a poller to regularly check compare the current version with the latest version
         iw.about.installationPollerId = window.setInterval(iw.about.installationPoller, iw.about.installationPollerInterval_ms);
         
         //Setup a cancel method, so the polling doesn't go on forever.
         window.setTimeout(iw.about.cancelInstallationPoller, 30000);
      },
      
      installationPoller : function() {
                
          //Note that this may fail during the time that IwTest is reloaded
          iw.invoke("iw.test.admin:info",{}, function(data){
            iw.about.license = data.license;
            iw.about.product = data.product;            
          });
              
          if(iw.about.product.version >= iw.about.product["latest-version"]) {
            //Remove the poller.
            window.clearInterval(iw.about.installationPollerId);
            //Clear the id
            iw.about.installationPollerId = undefined;
            iw.about.showMessage("Successfully downloaded and installed version " + iw.about.product.version + "!", true, 3000);            
          }
            
      },   
      
      cancelInstallationPoller : function() {

         iw.log("Cancel installation poller called. Poller id: " + iw.about.installationPollerId, 3);
         window.clearInterval(iw.about.installationPollerId);    
         if(iw.about.installationPollerId && iw.about.product.version !== iw.about.product["latest-version"]) {
             iw.about.installationPollerId = undefined;
             iw.about.showMessage("Installation failed or didn't complete within " + iw.about.installationPollerTimeout_s + " seconds. Please check the logs" , false, 4000);             
         }

      },
      
      //This method should be scheduled
      showInstallationSuccess : function() {
        if(this.product.version === this.product["latest-version"]) {
          this.showMessage("Successfully downloaded and installed version " + this.product.version + "!", true, 3000);
        } else {
          this.showMessage("Something went during downloading and installation. Please check the log files", false, 5000);  
        }
      },
      
      showReleaseNotesData : function () {
        iw.invoke("iw.test.util.file:getContent", {"file-name": this.product["latest-rn-file"]}, function(data) {
        iw.log("get file content called", 3);
        if(typeof(data) === 'string') {        

            iw.about.releasenotes = data;
            iw.about.showreleasenotesdiv = true;
            //Scroll the release notes to the bottom
            setTimeout(function(){document.getElementById("rn").scrollBy(0, 4000)}, 200);
          
          } else {
            iw.log("Get release notes content didn't return a string", 3)
            iw.log(data);
          }
        
        })
      },
      
      uploadLicense : function() {
        iw.invoke("iw.test.admin:saveLicense",{license : this.licenseText}, function(data){
        
          iw.about.response(data);
          iw.about.getInfo();
          
        }, this.error);   
        this.licenseText = "";
      },
      
      dropHandler: function (ev) {

        // Prevent default behavior (Prevent file from being opened)
        ev.preventDefault();

        if (ev.dataTransfer.items) {
          // Use DataTransferItemList interface to access the file(s)
          for (var i = 0; i < ev.dataTransfer.items.length; i++) {
            // If dropped items aren't json files, reject them
            if (ev.dataTransfer.items[i].kind === 'file' && ev.dataTransfer.items[i].type === 'application/json') {
              var file = ev.dataTransfer.items[i].getAsFile();
              iw.log('File dropped: ' + file.name, 3);

              //define file reader
              let reader = new FileReader();
              //set up 'onload' event handler, which is called when the file has loaded                
              reader.onload = function(event) {
                iw.about.licenseText = reader.result;
              }

              reader.readAsText(file)
            }
          }
        } else {
          // Use DataTransfer interface to access the file(s)
          for (var i = 0; i < ev.dataTransfer.files.length; i++) {
            iw.log('... file[' + i + '].name = ' + ev.dataTransfer.files[i].name + " not anticipated", 2);
          }
        }
      },        
      dragOverHandler : function (ev) {
        // Prevent default behavior (Prevent file from being opened)
        ev.preventDefault();
        
      }
    }
  });

  //register the global directives
  iw.aboutApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.aboutApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);

  iw.about = iw.aboutApp.mount("#about-app");
  
  iw.about.getInfo();
  iw.about.getConfig();
})(this, undefined);
