"use strict";

(function(window, undefined) {

  if(window.iw === undefined) window.iw = {};
  
  iw.defaultLogFile = "logs/iwtest.log"
  
  iw.logsApp = Vue.createApp({

    data : function() {
      return {
        logFile            : iw.defaultLogFile,
        logData            : "",
        logFiles           : [],
        autorefresh        : false,
        refreshInterval    : 2500,
        scheduledServiceId : -1,
        product            : {},
        config             : {},    
        
        success            : true,
        message            : "",
        
        availableAliases   : [],
        alias              : iw.localAlias,
        files              : [],             
        startPosition      : 0,
        nextPosition       : 0,
        fileSize           : 0,
        endPosition        : null,
        nrOfLinesRequested : 1000,
        nrOfLinesDisplayed : 0,
        descending         : true,
        previousBackwards  : false,
        previousDirection  : null,
        previousPossible   : false,
        nextPossible       : false,
        fullyRead          : true,
        
        direction          : null,
        percentage         : 0
      }
    },
    computed : {
      
      showAutorefresh : function() {
        return this.logFile.endsWith("iwtest.log");
      },
      
      marginPre : function() {
        
        let margin = 235;
          
        if(!this.showAutorefresh) {
          margin -= 30;
          iw.log("[margin] autorefresh hidden: -30", 3);
        }
        
        if( this.config["ui.distributed.enabled"] !== "true" || this.availableAliases.length <= 1 ) {
          margin -= 30;
          iw.log("[margin] distributed disabled: -30", 3);
        }
        
        if(this.autorefresh) {
          margin -= 60;
          iw.log("[margin] autorefresh active: -60", 3);
        } else {
          if(!this.previousPossible && !this.nextPossible) {
            //margin -= 30;
            //iw.log("[margin] previous and next not possible: -30", 3);
          } 
        }
        iw.log("[margin] calculated: " + margin, 3)
        return margin;
      },
      
      showPercentage : function() {
        
          let ratio = this.fileSize / (this.nrOfLinesRequested * 100);
          
          iw.log("[show percentage] ratio: " + ratio);
          return ratio > 5;
      }
 
    },
    
    watch: {
      logFile : function() {
        //Log file changed, so reset the positions
        iw.logs.reset();
        //disable autorefresh only if enabled
        if(iw.logs.autorefresh) {
          iw.logs.autorefresh = false;          
        }
        iw.logs.getNextLines();
      },
      
      nrOfLinesRequested : function() {
        //Re-read from the same position
        iw.logs.direction = "refresh";
        iw.logs.getLines();
      },
      
      alias : function() {
        if(this.autorefresh) {
          //This will stop the refresh, but also call 'getNextLines()' on the new agent
          //Also, we're already dealing with the default log file
          this.autorefresh = false;
        } else {
          iw.logs.logFile = iw.defaultLogFile;
          iw.logs.reset();
          iw.logs.getNextLines();
        }
        iw.logs.listAgentLogFiles();
      },
      
      descending : function() {
        if(iw.logs.autorefresh) {
            iw.logs.logData = Object.freeze(iw.logs.logData.split('\n').reverse().join('\n'));
        } else {
          iw.logs.direction = "refresh";
          if(iw.logs.descending) {
            iw.logs.getNextLines();
          } else {
            iw.logs.getPreviousLines();
          }
        }
      },
      
      autorefresh : function() {
        if(this.autorefresh) {
          iw.logs.startAutoRefresh();
        } else {
          iw.logs.stopAutoRefresh();
        }
      }
    },
    
    methods: {
      
      error : function(msg) {         
        iw.log(msg, 0);
        iw.logs.showMessage(msg, false , 2500);       
      },      
            
      showMessage : function(msg, success, timeout) {  
         iw.logs.message     = msg;
         iw.logs.success     = success;
         if(timeout == undefined)  timeout = 2500;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.logs.message=""}, timeout);
         }
      },
      
      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.logs.product = data.product;   
        });
      },
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.logs.config = data;          
        });        
      },
      
      reset : function() {
        iw.logs.startPosition     = 0;
        iw.logs.nextPosition      = 0;        
      },
      
      getLogData : function () {
        iw.invoke("iw.test.logging:getLogContent", {"log-file": iw.logs.logFile}, function(data) {
          iw.log("get log content called", 3);
          if(typeof(data) === 'string') {
          

            let lines = data.split("\n");
            iw.log("Nr of log lines: " + lines.length, 3);
            lines.reverse();
            //We're getting a new line at the beginning of joined array, so remove
            iw.logs.logData = lines.join("\n").substring(1);
            
          } else {
            iw.log("Get log content didn't return a string", 3)
            iw.log(data);
          }
        })
      },      

      startAutoRefresh : function() {
          //Adjust start and end 
          if(iw.logs.descending) {                
                iw.logs.endPosition   = iw.logs.startPosition;
                iw.logs.startPosition = 0;
          }
                   
          iw.log("[autorefresh] startPosition: " + iw.logs.startPosition 
                  + " endPosition: " + iw.logs.endPosition, 3);
          
          iw.logs.scheduledServiceId = window.setInterval(function(){iw.logs.getLines()}, iw.logs.refreshInterval, iw.logs.refreshInterval);
          iw.log("Started autorefresh. Id: " +iw.logs.scheduledServiceId, 3);
      },
      
      stopAutoRefresh : function(doRetrieveLines) {
        iw.logs.endPosition = null;

        window.clearInterval(iw.logs.scheduledServiceId);
        iw.log("Canceled autorefresh", 3);
        //In order to set nextPosition correct, retrieve the
        //most recent lines, but only if the log file is the
        //active log file
        if(iw.logs.logFile === iw.defaultLogFile) {
          if(iw.logs.descending) {
            iw.logs.getFirstLines();
          } else {
            iw.logs.getLastLines();
          }
        }
      },
      
      listAgentLogFiles : function() {
        let params = {$alias: iw.logs.alias}
        iw.invoke("iw.test.ui.logging:list", params, function(data){
                    
          //Add a formatted size to the structure
          let factor = 10;
          let files = data.files.map(function(f){            
            if(f.size < 1024 / factor) {
              f.formattedSize = (f.size) + " B";
            } else if (f.size < (1024 * 1024) / factor) {
              f.formattedSize = (f.size / (1024)).toFixed(1) + " kB"; 
            } else if (f.size < (1024 * 1024 * 1024) / factor) {
              f.formattedSize = (f.size / (1024 * 1024)).toFixed(1) + " MB";
            } else {
              f.formattedSize = (f.size / (1024* 1024 * 1024) / factor).toFixed(1) + " GB";
            }
            return f;
          });
          
          iw.logs.files = Object.freeze(files);          
          
        });
      },
      
      ///////////////////////////  START  NEW IMPLEMENTATION ////////////////////////////////////////////
      
      getLines : function() {
        /*
         * There are three cases:
         *
         * 1. Get the next set of lines
         * 2. Get the previous set of lines
         * 3. Get the same set of lines.
         
         * Indicated by the 'direction': previous, next, refresh
        
        */
        
        //These are common parameters:
        let params = {
          "file-name"        : iw.logs.logFile,
          $alias             : iw.logs.alias,
          "nr-of-lines"      : iw.logs.nrOfLinesRequested
        }
        
        //Set the line order
        if(iw.logs.descending) {  
          params["line-order"]     = "descending";
        } else {            
          params["line-order"]     = "ascending";
        }
        
        if(iw.logs.autorefresh) {
            params["start-position"] = 0;
            params["read-backwards"] = true;
            params["end-position"]   = iw.logs.fileSize;
        } else {
          if(iw.logs.direction === "refresh") {
            params["start-position"] = iw.logs.startPosition;
            params["read-backwards"] = iw.logs.previousBackwards;
            iw.log("[refresh] start-position: " + iw.logs.startPosition +  "; read-backwards: " + iw.logs.previousBackwards + " (from previousBackwards)",2);
          } else { 
            if(iw.logs.direction !== "refresh" && iw.logs.previousDirection !== iw.logs.direction) {
              iw.log("Change of direction: " + iw.logs.previousDirection + " -> " + iw.logs.direction, 3);
              params["start-position"]  = iw.logs.startPosition;
            } else {
              params["start-position"]  = iw.logs.nextPosition;
            }
            
            if(iw.logs.direction === "next") {
              
              params["read-backwards"] = iw.logs.descending;                    
              
            } else if(iw.logs.direction === "previous") {
              
              params["read-backwards"] = !iw.logs.descending;                   
            }          
          } 
        }
        /*
        else  {
          iw.log("direction has an unexpected value: " + iw.logs.direction, 2);
          return;
        }
        */
        iw.log("=== [start] getting agent log file content; file: " + iw.logs.logFile
                                         + "; direction: " + iw.logs.direction 
                                         + "; $alias: " + iw.logs.alias 
                                         + "; start position: " + params["start-position"]
                                         + "; end position: " + params["end-position"]
                                         + "; nr-of-lines: " + iw.logs.nrOfLinesRequested
                                         + "; read-backwards: " + params["read-backwards"]
                                         + "; line-order: " + params["line-order"]
                                         + "; autorefresh: " + iw.logs.autorefresh , 3);
        
        //Detect whether we would read past the limits of the file.

        iw.invoke("iw.test.ui.logging:lines", params, function(data){
          
          if(data.lines === undefined) {
              iw.logs.showMessage("Please upgrade the Remote Agent on " + iw.logs.alias +  " to the latest version", false, 3000);
              return;
          }
          
          let nrOfLinesReceived = data.lines.length;
          iw.log("Received " + nrOfLinesReceived + " lines from the server", 3);
          
          if(iw.logs.autorefresh) {
            if(data.lines.length > 0) {              
              
              //Logic to append or prepend the received lines.
              //Also make sure that the total of lines stays within the requested limit.
              if(iw.logs.descending) {
                //Prepend the new lines
                if(nrOfLinesReceived + iw.logs.nrOfLinesDisplayed <= iw.logs.nrOfLinesRequested) {
                  //No need for trimming
                  iw.logs.logData            = Object.freeze(data.lines.join('\n')) + ('\n') + iw.logs.logData;
                  iw.logs.nrOfLinesDisplayed = nrOfLinesReceived + iw.logs.nrOfLinesDisplayed;
                } else {
                  if(nrOfLinesReceived > iw.logs.nrOfLinesRequested) {
                    //Only use the received lines, but use the first section
                    iw.logs.logData          = Object.freeze(data.lines.slice(0, iw.logs.nrOfLinesRequested).join('\n'));
                  } else {
                    //Use all the received lines, filling the rest up with a selection of the current lines
                    iw.logs.logData = data.lines.concat(iw.logs.logData.split('\n').slice(0, iw.logs.nrOfLinesRequested - nrOfLinesReceived).join('\n')).join('\n');
                  }
                  iw.logs.nrOfLinesDisplayed = iw.logs.nrOfLinesRequested;
                }
              } else {
                //Append the new lines
                if(nrOfLinesReceived + iw.logs.nrOfLinesDisplayed <= iw.logs.nrOfLinesRequested) {
                  //No need for trimming
                  iw.logs.logData += Object.freeze(data.lines.join('\n'))
                  iw.logs.nrOfLinesDisplayed = nrOfLinesReceived + iw.logs.nrOfLinesDisplayed;
                } else {
                  if(nrOfLinesReceived > iw.logs.nrOfLinesRequested) {
                    //Only use the received lines, but use the last section
                    iw.logs.logData = Object.freeze(data.lines.slice(-iw.logs.nrOfLinesRequested).join('\n'));
                  } else {
                    //Use all the received lines, prepending the rest up with a selection of the current lines
                    iw.logs.logData = (iw.logs.logData.split('\n').slice(-(iw.logs.nrOfLinesRequested - nrOfLinesReceived)).concat(data.lines)).join('\n');
                  }
                  iw.logs.nrOfLinesDisplayed = iw.logs.nrOfLinesRequested;
                }
              }              
              
              iw.log("Nr of lines displayed, calculated by counting: " + iw.logs.logData.split('\n').length, 3);
              
            }
          } else {
              iw.logs.logData   = Object.freeze(data.lines.join('\n'));          
              iw.logs.nrOfLinesDisplayed = nrOfLinesReceived;
          }
                     
          //Always adjust the nextPosition and the startPosition
          iw.logs.startPosition     = data["start-position"];
          
          iw.logs.fileSize          = data["file-size"];
          iw.logs.fullyRead         = data["fully-read"];
          iw.logs.nextPosition      = data["next-position"];  
          iw.logs.previousBackwards = data["read-backwards"];
          if(iw.logs.direction !== "refresh") {
            iw.logs.previousDirection = iw.logs.direction;
          }
          if(iw.logs.descending) {
              iw.logs.percentage = (100 * ((iw.logs.fileSize - iw.logs.startPosition + 1) / iw.logs.fileSize)).toFixed();
          } else {
              iw.logs.percentage = (100 * (iw.logs.startPosition) / iw.logs.fileSize).toFixed();
          }
          iw.log("=== [end] iw.logs.startPosition: " + iw.logs.startPosition + "; iw.logs.nextPosition: " +iw.logs.nextPosition + "; iw.logs.fileSize: " + iw.logs.fileSize, 3);
          
          
          //Logic for determining whether 'next' or 'previous' is possible
          if(iw.logs.descending) {
             if(iw.logs.startPosition >= iw.logs.fileSize - 1 || iw.logs.nextPosition >= iw.logs.fileSize - 1 ) {
                iw.log("[desc] 'Previous' is not possible", 2);
                iw.logs.previousPossible = false;
             } else {
                iw.logs.previousPossible = true;
             }
             if(iw.logs.nextPosition <= 0 || iw.logs.startPosition <= 0) {
               iw.log("[desc] 'Next' is not possible", 2);
               iw.logs.nextPossible = false;
             } else {
               iw.logs.nextPossible = true;
             }
          } else {
            if(iw.logs.startPosition <= 0 || iw.logs.nextPosition  <= 0) {
                iw.log("[asc] 'Previous' is not possible", 2);
                iw.logs.previousPossible = false;
             } else {
               iw.logs.previousPossible = true;
             }
                            
             if(iw.logs.nextPosition >= iw.logs.fileSize -1 || iw.logs.startPosition >= iw.logs.fileSize - 1) {
               iw.log("[asc] 'Next' is not possible", 2);
               iw.logs.nextPossible = false;
             } else {
               iw.logs.nextPossible = true;
             }
          }
          
        },function(data){
          console.error(data)
        });      
        
      },
      
      getNextLines : function() {
        
        iw.logs.direction = "next";
        iw.logs.getLines();
      },
      
      getPreviousLines : function() {
        iw.logs.direction = "previous";
        iw.logs.getLines();
      },
      
      getFirstLines : function() {
        iw.logs.previousDirection = null;
        iw.logs.direction         = "next"
        iw.logs.startPosition     = 0;             
        iw.logs.getLines();
      },
      
      getLastLines : function() {
        iw.logs.previousDirection = null;
        iw.logs.direction         = "previous"        
        iw.logs.startPosition     = 0;               
        iw.logs.getLines();
      },
      
      getPercentageLines : function() {
       
        if(iw.logs.percentage < 0)   iw.logs.percentage = 0;
        if(iw.logs.percentage > 100) iw.logs.percentage = 100;
       
        iw.logs.previousDirection = null;
        
        iw.logs.startPosition     = ((iw.logs.percentage/100) * iw.logs.fileSize).toFixed();
        if(iw.logs.descending) {
          iw.logs.startPosition =  ((1 - iw.logs.percentage/100) * iw.logs.fileSize).toFixed();
        }
        
        if(iw.logs.percentage > 50 ) {
          iw.logs.direction         = "previous";  
        } else {
          iw.logs.direction         = "next";  
        }
        
        iw.logs.getLines();
      },
      
      
      init : function () {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.logs.config = data;          
          
          if(data["ui.distributed.enabled"] === "true") {
            iw.invoke("iw.test.ui.config:get", {}, function(data){
              iw.logs.availableAliases = data.agents.filter(function(a){ return a.$success === "true" && a.$status === "version-ok"}).map(function(a){return a.$alias});              
              //prepend the local alias
              iw.logs.availableAliases.unshift(iw.localAlias);
            });
          }
            
          
        }); 
                
        iw.logs.getInfo();
        
        iw.logs.listAgentLogFiles();
        
        iw.logs.getNextLines();
        
      }
    }
  })
  
  //register the global directives
  iw.logsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.logsApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.logsApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  
  iw.logs = iw.logsApp.mount('#logs-app');
  
  iw.logs.init();
  
})(this, undefined);