"use strict";

(function(window, undefined) {

  if(window.iw === undefined) window.iw = {};
   
  iw.staticStubsApp = Vue.createApp({

    data : function() {
      return {
        info                    : {},
        config                  : {},
        aliases                 : [],
        selectedAlias           : null,
        showactivatestubdiv     : false,
        message                 : "",
        success                 : true,
        running                 : false,
        externalLocations       : [],
        externalLocationAlias   : null,
        externalLocationPath    : null,
        staticStubsList         : [],
        stub                    : 
        {
          'base-dir'            : "",
          'auto-load'           : "false",
          active                : false,
          stub                  : 
          {
            'service-to-stub'     : "",
            id                    : ""
          }
        },
        numberOfRuns               : 0,
        generateFromRuns           : false,
        showacceptduplicate        : false,
        stubEditKey                : 0,
        showeditstubdiv            : false,
        showexternallocationsdiv   : false,
        showaddexternallocationdiv : false,
        localPackages              : [],
        showpipelinediv            : false,
        confirm                    : {
          question                 : null,
          showconfirmationdialog   : false,
          confirmAction            : function(){}
        },  
        
        showchoosestubdiv          : false,
        stubsToEnhance             : [],
        serviceToEnhance           : null,
        stubid                     : null,
        
        selectedStubId             : null,
        
        
        pipeline: {
          data                          : {},
          isproblematic                 : false,
          ignoreWarning                 : false,
          readonly                      : false,
          path                          : "",
          raw                           : "",
          service                       : null,
          schema                        : null,
          output                        : false,
          error                         : false,
          generateMinimal               : false,
          generateOnlyStructure         : false,
          generateNumberOfArrayElements : 1, 
          sampleData                    : null,
          sampleDataXML                 : null
        },
        isdirtypipeline     : false,
        
        isdirtyxmlpipeline  : false,
        
        isdirtyjsonpipeline : false,
        
        showraweditor       : false
      }
    },
    
    methods: {
      
      response : function(data) {         
         iw.staticstubs.showMessage(data["$message"], data["$success"] === "true" , 2500);  
      },
      
      showMessage : function(msg, success, timeout) {  
         iw.staticstubs.message = msg;
         iw.staticstubs.success = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.staticstubs.message= ""; iw.staticstubs.success = true}, timeout);
         }
      },
      
      hideMessage : function() {
           iw.staticstubs.message = "";
      },
      
      error : function(msg) { 
        iw.log(msg, 0);
        iw.staticstubs.showMessage(msg, false , 3000);       
      },
           
      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.staticstubs.info = data;          
        });
      },
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.staticstubs.config = data;
          if(data["ui.staticstub.external.enabled"] == "true") {
            iw.staticstubs.listExternalLocations();
          }

          iw.staticstubs.listStaticStubs(true);
        
        });        
        
      },
      
      listExternalLocations : function() {
        iw.invoke("iw.test.ui.stubdef:externalPathList", {}, function(data) {
          iw.staticstubs.externalLocations = data.locations;          
        });
      },
      
      showAddExternalLocationDialog : function() {
        iw.staticstubs.showaddexternallocationdiv = true;
      },
      
      hideAddExternalLocationDialog : function() {
        iw.staticstubs.showaddexternallocationdiv = false;
      },
      
      addExternalLocation : function() {
        let params = {
          location : {
            alias      : iw.staticstubs.externalLocationAlias,
            "base-dir" : iw.staticstubs.externalLocationPath
          }
        }
        
        iw.invoke("iw.test.ui.stubdef:externalPathAdd", params, function(response) {
          if(response["$success"] === "true") {
            iw.staticstubs.externalLocations.push(response.location);
            iw.staticstubs.showaddexternallocationdiv = false;
            iw.staticstubs.listStaticStubs();
          }
          iw.staticstubs.externalLocationPath = response.location["base-dir"];
          iw.staticstubs.response(response);
        });
      },
      
      removeExternalLocation : function(alias) {
        iw.staticstubs.confirm.question = "Are you sure you want to remove the external location " + alias + " (no files will be deleted)?";
        iw.staticstubs.confirm.confirmAction = function () {                             
        
          let params = {
            location : {
              alias      : alias
            }
          }
          
          iw.invoke("iw.test.ui.stubdef:externalPathRemove", params, function(response) {
            if(response["$success"] === "true") {
              iw.staticstubs.externalLocations = iw.staticstubs.externalLocations.filter(function(location){if(location.alias !== alias){return location}});
              iw.staticstubs.listStaticStubs();
            }            
            iw.staticstubs.response(response);
            
          });
        };
        iw.staticstubs.confirm.showconfirmationdialog = true;       
      },
      
      lookupExistingDynamicStubs : function(serviceName, locations) {
         
         iw.log("Incoming service via query parameter 'serviceName': " + serviceName, 3);

         let existingDynamicStubs = [];
         for(let i = 0 ; i < locations.length ; i++) {
           iw.log("Location: " + locations[i].name, 3);
           for(let j = 0 ; j < locations[i].stubs.length ; j++) {
             iw.log("Base-dir: " + locations[i].stubs[j]["base-dir"], 3);
             let stub = locations[i].stubs[j].stub;
             if(serviceName === stub["service-to-stub"] && typeof(stub.dynamic) !== "undefined") {
               let qualifyingStub = {
                 locationName    : locations[i].name,
                 locationType    : locations[i].type,
                 stubContainer   : locations[i].stubs[j]
               }
               existingDynamicStubs.push(qualifyingStub);
             }
           }
         }
         return existingDynamicStubs;
      },
      
      listStaticStubs : function(isInitial) {
        iw.invoke("iw.test.ui.stubdef:list", {}, function(data) {
          iw.staticstubs.staticStubsList = data.locations;          

          //Handle query parameters. If there is parameter named 'service', then open up the New Stub dalog
          if(typeof(isInitial) !== "undefined" && isInitial === true && iw.queryParams.service) {
            iw.staticstubs.serviceToEnhance = iw.queryParams.service;
            if(iw.queryParams.alias && iw.staticstubs.config["ui.distributed.enabled"] === "true") iw.staticstubs.selectedAlias = iw.queryParams.alias;
            iw.log("Incoming service via query parameter 'service': " + iw.staticstubs.serviceToEnhance + "; alias: " + iw.staticstubs.selectedAlias, 3);
            let existingDynamicStubs = iw.staticstubs.lookupExistingDynamicStubs(iw.staticstubs.serviceToEnhance, data.locations);
            
            if(existingDynamicStubs.length === 0 ) {
              //Immediately op the 'Create new stub dialog'
              iw.staticstubs.stub  = iw.staticstubs.composeNewDynamicStub(iw.staticstubs.serviceToEnhance);
              
              iw.staticstubs.listLocalPackages();
              iw.staticstubs.lookupRecordedServiceRuns(iw.staticstubs.serviceToEnhance);
              iw.staticstubs.generateFromRuns = true;
              iw.staticstubs.showeditstubdiv  = true;
                    
            } else {
               //Show dialog to let the user choose an existing stub
               iw.staticstubs.stubsToEnhance = existingDynamicStubs;
               
               iw.staticstubs.showchoosestubdiv = true;
            }
          }
          
          if(isInitial === true && iw.staticstubs.config["ui.distributed.enabled"] === "true") {
            /* Call to iw.test.ui.config:get instead of to iw.test.alias:list in order to get the availability */
            iw.invoke("iw.test.ui.config:get", {}, function(data) {
              iw.log("Aliases retrieved from server", 3);
              iw.staticstubs.aliases.push(iw.localAlias);
              let availableAgents = data.agents.filter(function(agent){return agent.$success === "true"}).map(function(agent){return agent.$alias});
              for(let i = 0 ; i < availableAgents.length ; i++) {
                iw.staticstubs.aliases.push(availableAgents[i]);
              }
            });
          }
        
        });
      },
      
      composeNewDynamicStub : function(serviceToStub) {
        let dynamicStub = {
          'base-dir'    : "",
          'auto-load'   : false,
          active        : false,
          locationType  : iw.staticstubs.externalLocations.length === 0 ? "package" : "",
          locationName  : "",
          stub          : {
            'service-to-stub' : serviceToStub,
            id                : "",
            scope             : "server",
            dynamic      : {
              "stub-base-dir" : "dynamic"
            }
          }
        };
        return dynamicStub;
      },
      
      activate : function(id, onLocal) {
        iw.staticstubs.selectedStubId = id;
        if(iw.staticstubs.config["ui.distributed.enabled"] === "true" && onLocal === false) {
          iw.staticstubs.showactivatestubdiv = true;
        } else {          
          iw.staticstubs.activateStub(onLocal);
        }
      },
      
      activateStub : function(onLocal) {
        iw.log("Activate stub with id " + iw.staticstubs.selectedStubId, 3);
        let params = {id: iw.staticstubs.selectedStubId};
        if(iw.staticstubs.config["ui.distributed.enabled"] === "true" && onLocal === false && iw.staticstubs.selectedAlias !== null) {
          params.$alias = iw.staticstubs.selectedAlias;
        }
        iw.invoke("iw.test.ui.stubdef:activate", params, function(data){
          if(data["$success"] === "true") {
            //Only show as 'active' the stub was activated on local.
            if(iw.staticstubs.aliases.filter(function(a){if(iw.staticstubs.selectedAlias === a) return a}).length === 0) {
              iw.staticstubs.setActiveState(data.id, true);              
            }
          }
          iw.staticstubs.response(data);
        });           
      },
      
      //This method only works the local IS.
      deactivate : function(id) {
        iw.log("Deactivate stub with id " + id, 3);
        let params = {id: id};
        iw.invoke("iw.test.ui.stubdef:deactivate", params, function(data){
          if(data["$success"] === "true") {
            //Only show as 'active' the stub was activated on local.
            if(iw.staticstubs.aliases.filter(function(a){if(iw.staticstubs.selectedAlias === a) return a}).length === 0) {
              iw.staticstubs.setActiveState(data.id, false);              
            }
          }
          iw.staticstubs.response(data);
        });        
      },
      
      setActiveState : function(id, active) {
        for(let i = 0 ; i < iw.staticstubs.staticStubsList.length ; i++ ) {         
          for(let j = 0 ; j < iw.staticstubs.staticStubsList[i].stubs.length ; j++ ) {            
            if(iw.staticstubs.staticStubsList[i].stubs[j].stub.id === id) {
               iw.staticstubs.staticStubsList[i].stubs[j].active = active;
            }
          }
        }
      },
             
      showNewStubDialog  : function() {        
        
        iw.staticstubs.stub  = {
          'base-dir'    : "",
          'auto-load'   : false,
          active        : false,
          locationType  : iw.staticstubs.externalLocations.length === 0 ? "package" : "",
          locationName  : "",
          stub          : {
            'service-to-stub' : "",
            id                : ""
          }
        };

        iw.staticstubs.numberOfRuns = 0;
        iw.staticstubs.listLocalPackages();
        iw.staticstubs.showeditstubdiv = true;
      },
      
      lookupRecordedServiceRuns : function(serviceName) {
        let initialNumberOfRuns = iw.staticstubs.numberOfRuns;
        let params = {"service-name" : serviceName};
        if(iw.staticstubs.selectedAlias !== null) {
            params.$alias = iw.staticstubs.selectedAlias;
        }
        
        iw.invoke("iw.test.ui.testrun:list", params, function(data){
          if(data.services.length > 0) {
            iw.staticstubs.numberOfRuns = data.services[0].runs.length;            
          } else {
            iw.staticstubs.numberOfRuns = 0;
          }
          if(initialNumberOfRuns !== iw.staticstubs.numberOfRuns) {
            iw.staticstubs.stubEditKey++;
          }
        });
      },

      saveStub : function(extendedStub) {
        
        let fs = JSON.parse(JSON.stringify(extendedStub));
        iw.log("[first] Saving extended stub with id " + fs.stub.id + "; auto-load: " + fs['auto-load'], 3);
        
        //Accept duplicates when called from the table of stubs
        fs.force = true;
       
        iw.invoke("iw.test.ui.stubdef:save", fs, function(data){
          //if(data["$success"] === "false" || data["$message"].indexOf("auto-load reverted") > 0) {
          if(data["$success"] === "false" || data["$message"].indexOf('reverted') > 0) {
            iw.staticstubs.listStaticStubs();
          }
          iw.staticstubs.response(data);
        });
       
      },
      
      removeStub : function(id, service) {        
        iw.staticstubs.confirm.question = "Are you sure you want to delete the static stub for service " + service + "?";
        iw.staticstubs.confirm.confirmAction = function () {                    
            let params = {"id" : id};          
            iw.invoke("iw.test.ui.stubdef:remove", params, function(data){
              if(data["$success"] === "true") {
                iw.staticstubs.listStaticStubs();
              }
              iw.staticstubs.response(data);
            });
        };
        iw.staticstubs.confirm.showconfirmationdialog = true;        
      },
      
      saveStubFromComponent : function(event) {
        iw.log("saveStubFromComponent called. Stub: ", 3);
        //console.log(event);
        
        iw.invoke("iw.test.ui.stubdef:generate", event, function(data) {
          if(data["$success"] === "true") {
            iw.log("New stub created; updating stub definition with base-dir and stub details", 3);
            iw.staticstubs.listStaticStubs();
            iw.staticstubs.stub.stub         = data.stub;
            iw.staticstubs.stub["base-dir"]  = data["base-dir"];
            iw.staticstubs.stub["auto-load"] = data["auto-load"];
            //iw.staticstubs.packageName       = data["package"];
            if(typeof(data.package) !== "undefined") {
              iw.staticstubs.stub.locationName = data.package;
              iw.staticstubs.stub.locationType = "package";
            }
            if(typeof(data["location-alias"]) !== "undefined") {
              iw.staticstubs.stub.locationName = data["location-alias"];
              iw.staticstubs.stub.locationType = "external";
            }
            iw.staticstubs.stubEditKey++;
            iw.staticstubs.lookupRecordedServiceRuns(iw.staticstubs.stub.stub["service-to-stub"]);
          } else {
            if(data["$message"].indexOf("already exists") > 0 ) {
              iw.staticstubs.showacceptduplicate = true;
            }
          }          
          iw.staticstubs.response(data);          
        });
      },
      
      lookupStub : function(id) {
        let stub = null;
        a: for(let i = 0 ; i < iw.staticstubs.staticStubsList.length ; i++ ) {         
          b: for(let j = 0 ; j < iw.staticstubs.staticStubsList[i].stubs.length ; j++ ) {            
            if(iw.staticstubs.staticStubsList[i].stubs[j].stub.id === id) {
               stub = iw.staticstubs.staticStubsList[i].stubs[j];
               stub.locationType = iw.staticstubs.staticStubsList[i].type;
               stub.locationName = iw.staticstubs.staticStubsList[i].name;
               break a;
            }
          }
        }
        return stub;       
      },
      
      setStubInlist : function(stub) {
        a: for(let i = 0 ; i < iw.staticstubs.staticStubsList.length ; i++ ) {         
          b: for(let j = 0 ; j < iw.staticstubs.staticStubsList[i].stubs.length ; j++ ) {            
            if(iw.staticstubs.staticStubsList[i].stubs[j].stub.id === stub.id) {
               iw.staticstubs.staticStubsList[i].stubs[j].stub = stub;               
               break a;
            }
          }
        }
      },
      
      showEditStubDialog : function(id, serviceToEnhance) {     
        iw.log("showEditStubDialog called. id: " + id, 3);
 
        if(id === 'new') {
          iw.staticstubs.stub  = iw.staticstubs.composeNewDynamicStub(iw.staticstubs.serviceToEnhance);
                
          iw.staticstubs.listLocalPackages();
          iw.staticstubs.lookupRecordedServiceRuns(iw.staticstubs.serviceToEnhance);
          iw.staticstubs.generateFromRuns = true;
          iw.staticstubs.showeditstubdiv  = true;  
        } else {
          iw.staticstubs.listLocalPackages();
          let stubContainer   = iw.staticstubs.lookupStub(id);
          //Lookup the stub if it's a dynamic stub. Files on the file system may have changed
          iw.log("(stubContainer.stub['dynamic']) === 'object': " + typeof(stubContainer.stub["dynamic"]), 3);
          if(typeof(stubContainer.stub["dynamic"]) === "object") {
            let params = { id: id};
            iw.invoke("iw.test.ui.stubdef:get", params, function(data){
              iw.staticstubs.stub = data;
              iw.staticstubs.showeditstubdiv = true;
            });
          } else {
            iw.staticstubs.stub = stubContainer;    
            iw.staticstubs.showeditstubdiv = true;
          }
          iw.staticstubs.lookupRecordedServiceRuns(stubContainer.stub["service-to-stub"]);
          
        }
      },
       
      hideEditStubDialog : function(stub) {
        iw.log("hideEditStubDialog called. Stub:");
        //console.log(stub);
        iw.staticstubs.setStubInlist(stub);
        iw.staticstubs.generateFromRuns    = false;
        iw.staticstubs.showeditstubdiv     = false;
        iw.staticstubs.showacceptduplicate = false;
      },
      
      listLocalPackages : function() {
		    let params = {};
		    iw.invoke("iw.test.ui.ns:listPackages", params, function(data) {
		      iw.log("Retrieved local packages", 3);

            iw.staticstubs.localPackages = data.packages.filter(function(a){                 
              return a.enabled === "true";
            });
                
         }, iw.staticstubs.error);
		  },
      
      hidePipelineDialog : function() {
        iw.staticstubs.showpipelinediv = false;
        if(iw.xmleditor) iw.xmleditor.getSession().setValue("" , 1);
        if(iw.peditor)   iw.peditor.set({})
      },
    
      showPipelineDialog : function(baseDir, path, service, output = false, error = false, readonly = false) {
        iw.staticstubs.pipeline.path     = path;
        iw.staticstubs.pipeline.service  = service;
        iw.staticstubs.pipeline.output   = output;
        iw.staticstubs.pipeline.error    = error;
        iw.staticstubs.pipeline.readonly = readonly;
        
        iw.log("[getPipeline] baseDir: " +  baseDir + "; path: " +  path + "; service: " +  service + "; output: " +  output + "; error: " +  error, 3);
        
        var params = {"$path"       : path, 
                      "$baseDir"    : baseDir, 
                      "$package"    : "",
                      "$include-raw": "true"}

        iw.invoke("iw.test.util.pub:restorePipelineFromFile", params, function(data) {
          //iw.staticstubs.pipeline.data = JSON.stringify(data['$document'])
          iw.staticstubs.pipeline.isproblematic = ("true" === data['$problematic']);
          
          if(iw.peditor === undefined) {
            var container = document.getElementById("pipelineeditor");
            var options = { modes:["tree","code","text"],
                            enableTransform: false,
                            onChange: function() {iw.log("JSON changed",3); iw.staticstubs.isdirtypipeline = true; iw.staticstubs.isdirtyjsonpipeline = true},
                            onClassName: function(c) {
                              //iw.log("on-class-name: " + c.path + " " + c.field + " " + c.value, 3)
                            }
                          }
                          
             if(readonly) options.onEditable = function(){return false}
             iw.peditor = new JSONEditor(container, options);
          }
          if(iw.xmleditor === undefined) {
             iw.xmleditor = JSONEditor.ace.edit("xmleditor");
             iw.xmleditor.getSession().setMode("ace/mode/xml");
             iw.xmleditor.on("change", function() {iw.log("XML changed",3); iw.staticstubs.isdirtypipeline = true; iw.staticstubs.isdirtyxmlpipeline = true});
             if(readonly) iw.xmleditor.setReadOnly(true);
          }

          //Raw data 
          //iw.staticstubs.pipeline.raw = data['$raw'];
          iw.xmleditor.getSession().setValue( data['$raw'] , 1);

          //JSON
          iw.peditor.set(data['$document'])
          iw.peditor.setName("pipeline");
         
          iw.staticstubs.getPipelineSchema(false)
          //This seems to be problematic. Sometimes 'expandAll() does not exist
          //iw.peditor.expandAll();
          
          //Reset isdirtypipeline, so the save button becomes disabled
          iw.staticstubs.isdirtypipeline     = false;
          iw.staticstubs.isdirtyjsonpipeline = false;
          iw.staticstubs.isdirtyxmlpipeline  = false;

          //Explicitly show the XML editor if there are data types present that are not
          //supported by JSON
          if( iw.staticstubs.pipeline.isproblematic) {
            iw.staticstubs.showXMLEditor();
          }

          //iw.staticstubs.showraweditor = iw.staticstubs.pipeline.isproblematic;
          iw.staticstubs.showpipelinediv = true;

        }, function(msg){
            iw.staticstubs.hidePipelineDialog();
            iw.staticstubs.error(msg)
          })
      },
      
      togglePipelineValidation : function() {
        if(this.pipeline.validate) {
          iw.peditor.setSchema(this.pipeline.schema);
        } else {
          iw.peditor.setSchema(null);
        }
      },
      
      getPipelineSchema : function(generateData) {
        if(this.pipeline.path && this.pipeline.path.indexOf("test-error.xml") >= 0) {
          
        }
        let self = this;
        if(this.pipeline.service !== null) {
           let params = { 'nodeName'                     : this.pipeline.service,
                          'no-sample-data'               : !generateData,
                          'generate-minimal'             : this.pipeline.generateMinimal, 
                          'generate-only-structure'      : this.pipeline.generateOnlyStructure,
                          'generate-nr-of-array-elements': this.pipeline.generateNumberOfArrayElements} 

            if(iw.staticstubs.pipeline.error) {
                params.nodeName               = "iw.test.doc:exception";
                iw.staticstubs.pipeline.output = false;
            }
            iw.invoke("iw.test.ui.schema:get", params, function(data){
              if(data["$success"] === "true") {
                if(iw.staticstubs.pipeline.output) { 
                  self.pipeline.schema        = data['output-schema']
                  self.pipeline.sampleData    = data['sample-output-data']
                  self.pipeline.sampleDataXML = data['sample-output-xml']
                } else { 
                  self.pipeline.schema        = data['input-schema']
                  self.pipeline.sampleData    = data['sample-input-data']
                  self.pipeline.sampleDataXML = data['sample-input-xml']
                }
                if(iw.staticstubs.pipeline.validate === true) {
                  iw.peditor.setSchema(self.pipeline.schema);
                }
                
                if(generateData) {
                  //Only update the data of the active editor.
                  if(iw.staticstubs.showraweditor) {
                    iw.xmleditor.getSession().setValue(self.pipeline.sampleDataXML, 1);
                  } else {
                    iw.peditor.update(self.pipeline.sampleData);
                    iw.log("JSON panel updated with sample data",3); 
                    //For some reason, this does not trigger the 'onChange' event, so the flags are updated here.
                    iw.staticstubs.isdirtypipeline = true; 
                    iw.staticstubs.isdirtyjsonpipeline = true
                  }
                }
              } else {
                iw.staticstubs.response(data);
              }

            }, iw.staticstubs.error)
        }
      },
      
      showJSONEditor : function() {
        iw.log("showJSONEditor called", 3);
        iw.staticstubs.showraweditor = false;
      },
      
      showXMLEditor : function() {
        iw.log("showXMLEditor called", 3);
        iw.staticstubs.showraweditor = true;
      },
      
      savePipeline : function(closeDialog) {
        var params = {"$path"    : iw.staticstubs.pipeline.path, 
                      "$baseDir" : iw.staticstubs.stub['base-dir'],
                     }
                      
        if(iw.staticstubs.showraweditor) {
          params["$raw"] = iw.xmleditor.getValue();
        } else {
          params["$document"] = iw.peditor.get();
        }
        
        iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
          iw.staticstubs.showMessage(data["$message"], data["$success"] === "true" , 2500);          
          if(closeDialog) {
            iw.staticstubs.hidePipelineDialog();        
          } else {
            iw.staticstubs.showPipelineDialog(iw.staticstubs.stub['base-dir'], iw.staticstubs.pipeline.path,  iw.staticstubs.pipeline.service);       
          }
          
        }, iw.staticstubs.error)
        
      }


    }
  });
  
  iw.staticStubsApp.component('edit-stub',{
  
    template : "#edit-stub-template",
      
    props : ['initialStubContainer', 'localPackages', 'externalLocations', 'distributedEnabled', 'initialNumberOfRuns', 'initialRemoteAlias', 'availableAliases', 'initialGenerateFromRuns', 'showAcceptDuplicate', 'active'],
      
    data : function() {
      //make an independent copy of initialStubContainer, so we can easily revert
      iw.log("Initializing 'edit-stub' component; initialStubContainer:" , 3);
      //console.log(this.initialStubContainer);
      let stubContainer = JSON.parse(JSON.stringify(this.initialStubContainer));
      let stub          = stubContainer.stub;
      let baseDir       = stubContainer["base-dir"];
      let autoLoad      = stubContainer["auto-load"];
      iw.log("Initializing 'edit-stub'-component. baseDir: " + baseDir + "id: " + stub.id, 3);
      iw.log("Initial number of runs: " + this.initialNumberOfRuns, 3);
      iw.log("stub.id: "+ stub.id, 3);
      let uuid = iw.uuidv4();
      let path = this.baseDir;      

      if(typeof(stub.id) === "undefined" || stub.id === null || stub.id === "" ) {
        stub.id = uuid;
      }
        return {
         
          stub                    : stub,
          stubTypes               : ['pipeline','service', 'exception','dynamic'],
          scopeTypes              : ['server','user','session'],
          initialStubType         : stub.pipeline ? 'pipeline' : (stub.service ? 'service' : (stub.exception ? 'exception' : (stub.dynamic ? 'dynamic' : null))),
          stubType                : stub.pipeline ? 'pipeline' : (stub.service ? 'service' : (stub.exception ? 'exception' : (stub.dynamic ? 'dynamic' : null))),
          baseDir                 : baseDir,
          isDirty                 : false,
          counter                 : 0,
          numberOfRuns            : this.initialNumberOfRuns,
          remoteAlias             : this.initialRemoteAlias,          
          locationType            : stubContainer.locationType,
          locationName            : stubContainer.locationName,
          path                    : path,
          autoLoad                : autoLoad,
          locationCanBeChanged    : stubContainer.locationName === "" ? true : false,          
          force                   : false,
          generateFromRuns        : this.initialGenerateFromRuns,
          deleteRunsAfterDownload : true,
          uuid                    : uuid,
          packageName             : "Foo"   //To prevent the error message 'Property "packageName" was accessed during render but is not defined on instance'
      }
    },
    
    computed : {
      suggestedPath : function() {
        let p    = "";
        let name = this.locationName;
        if(this.locationType === "package") {
          iw.log("[suggested-path] Evaluating for 'package'", 3);
          let filterResult = this.localPackages.filter(function(a){if(a.name === name){return a}});
          iw.log(filterResult, 3);
          if(filterResult.length === 1) p = "packages/" + name + "/" + iw.staticstubs.config["generate.staticstub.package.folder"] + "/" + this.uuid;
        } else if(this.locationType === "external") {
          iw.log("[suggested-path] Evaluating for 'external'", 3);
          let filterResult = this.externalLocations.filter(function(a){if(a.alias === name) return a});
          iw.log(filterResult, 3);
          if(filterResult.length === 1) p = filterResult[0]['base-dir'] + "/" + this.uuid;
          
        }
        this.path = p;
        iw.log("Suggested path: " + p, 3);        
        return p;
      }      
    },
    
    methods: {

      handleLocationTypeChange : function(locationType) {
         iw.log("Location Type changed. New value: " + this.locationType + "; old value: " + locationType + "; location name: " + this.locationName, 3);
         if(this.locationName !== null) {
           this.isDirty = true;
         }
      },
      
      handleServiceSelectedEvent : function($event) {
        if(this.stub['service-to-stub'] !== $event) {
          this.stub['service-to-stub'] = $event;
          
          //Find out whether there are any recorded runs for this service.
          this.lookupRecordedServiceRuns($event);
          this.isDirty = true;
        }
      },
      
      lookupRecordedServiceRuns : function(serviceName) {
        let params = {"service-name" : serviceName};
        if(this.remoteAlias !== null) {
          params.$alias = this.remoteAlias;
        }
        let self = this;
        iw.invoke("iw.test.ui.testrun:list", params, function(data){
          if(data.services.length > 0) {
            self.numberOfRuns = data.services[0].runs.length;
          } else {
            self.numberOfRuns = 0;
          }
        });
      },
      
      handleGenerateFromRuns : function($event) {  
        iw.log("handleGenerateFromRuns called. $event.target._modelValue: " + $event.target._modelValue, 3);
        if($event.target._modelValue === true) {
          iw.log("'Use recorded runs' is true: creating 'dynamic' structure");
          if(typeof(this.stub.dynamic) === "undefined"  || this.stub.dynamic === null) {
            this.stub.dynamic = {"stub-base-dir" : "dynamic"};
          }
          this.stubType     = "dynamic";
          this.isDirty      = true;         
        }

      },
      
      handleRemoteAliasChange : function(alias) {
        iw.log("[remote-alias-changed] new value: " + alias , 3);
        this.lookupRecordedServiceRuns(this.stub['service-to-stub']);
        this.isDirty = true;
      },
      
      handleStubTypeChange : function(stubType) {
        iw.log("Stub type change detected. old type: " + this.stubType + "; new type: " + stubType);
        if(stubType === 'pipeline') {
          
          if(!this.stub.pipeline) { //Create new pipeline config
            this.createPipelineFile();            
          }
        }
        if(stubType === 'service') {
          //empty service, no input-file
          if(!this.stub.service) { 
            this.stub.service = {name:"",'input-file':""};               
          }
        }
        if(stubType === 'exception') {
          if(!this.stub.exception) this.stub.exception = {"class" : "", message : ""};
        }
        
        if(stubType === 'dynamic') {
          if(!this.stub.dynamic && !this.generateFromRuns) {
            this.createDynamicStubFiles();
          }
        }
        
        this.stubType = stubType;
        this.isDirty  = true;

      },
      
      handleSubstitutionServiceChange : function(newServiceName) {
        
        let oldServiceName     = this.stub.service.name;        
				this.stub.service.name = newServiceName;
        iw.log("handleServiceToStubChange called. Old service: " + oldServiceName + "; new service: " + newServiceName, 3);
				if((oldServiceName === "" || oldServiceName === null) && typeof(newServiceName) === "string" && newServiceName !== "") {
					iw.log("Old service name was empty, setting input file",3);					
          this.createServiceInputFile();
				} 
        this.isDirty = true;
      },
      
      handleServiceInputFileChange : function(newFileName) {
        if(newFileName === "") {
          this.removeServiceStubInput();
        }
        this.stub.service['input-file'] = newFileName;
        this.isDirty = true;

      },
         
      handleScopeChange : function(scope) {
        iw.log("HandleScopeChange called; new scope: " + scope, 3);
        if(scope === "session") {
          iw.staticstubs.confirm.question               = "If the scope is 'session' then the stub has a limited lifetime; auto-load is not possible";                    
          iw.staticstubs.confirmAction                  = function(){}; 
          //this.emitWarning("If the scope is 'session' then the stub has a limited lifetime; auto-load is not possible");
          iw.staticstubs.confirm.showconfirmationdialog = true;
        } 
        this.stub.scope = scope; 
        this.isDirty    = true;

      },
      
      createPipelineFile : function () {
        if(this.stub['service-to-stub'] !== "") {
                      
          this.stub.pipeline = {"file-name" :  "pipeline.xml"};

          iw.log("Creating pipeline file " + this.baseDir + "/" + this.stub.pipeline["file-name"]);

          let params = {"$document": {}, "$path" : this.stub.pipeline["file-name"], "$baseDir": this.baseDir, "overwrite": false}

          iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
                 iw.log("Pipeline file created? " + data["$success"], 3);
              }, iw.staticstubs.error);
        } else {
          iw.log("Could not create pipeline file: 'service-to-stub' is empty");
        }
      },
         
      createServiceInputFile : function() {
        if(this.stub['service-to-stub'] !== "") {
          
          let substituteInputFile = "substitute-input.xml";
          
          this.stub.service["input-file"] = substituteInputFile;
          
          iw.log("Creating service input file " + this.baseDir + "/" + substituteInputFile, 3);

          let params = {"$document": {}, "$path" :  this.stub.service["input-file"], "$baseDir": this.baseDir, "overwrite": false}

          iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Service input file created? " + data["$success"], 3);
          }, iw.staticstubs.error   );
        } else {
          iw.log("Could not create service input-file: 'service-to-stub' is empty");
        }         
      },
         
      createDynamicStubFiles : function() {
        if(this.stub['service-to-stub'] !== "") {
                    
            this.stub.dynamic = {"stub-base-dir" : "dynamic"};

            let firstDynamicInputFile  = this.stub.dynamic['stub-base-dir'] + "/00001/test-input.xml"
            let firstDynamicOutputFile = this.stub.dynamic['stub-base-dir'] + "/00001/test-output.xml"
            this.stub.dynamic["00001"] = {"input" : firstDynamicInputFile, "output": firstDynamicOutputFile};

            iw.log("Creating dynamic file " + this.baseDir + "/" + firstDynamicInputFile);

            let params = {"$document": {}, "$path" : firstDynamicInputFile, "$baseDir": this.baseDir };

            iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Dynamic stub input file created? " + data["$success"]);
            }, iw.staticstubs.error   );

            iw.log("Creating dynamic file " + this.baseDir + "/" + firstDynamicOutputFile);
            
            params = {"$document": {}, "$path" : firstDynamicOutputFile, "$baseDir": this.baseDir};
            
            iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Dynamic stub output file created? " + data["$success"]);
            }, iw.staticstubs.error   );
        } else {
          iw.log("Could not create dynamic stub file: 'service-to-stub' is empty");
        }         
      },

      changeDynamicStubEntryFolder : function(baseDir, oldFolderName, newFolderName, stub ) {
        iw.log("Changing file name; baseDir: " + baseDir + "; old file name: " + oldFolderName + "; new file name: " + newFolderName, 3);
        let params = {"base-dir": baseDir, "existing-file-name": oldFolderName, "new-file-name": newFolderName}
        let self = this;
        //console.log(stub);
        let dynamicStubEntry = stub.dynamic[oldFolderName];
        iw.invoke("iw.test.util.file:rename", params, function(data){
            iw.log("Dynamic stub folder name changed? " +data["$success"], 3);
            //console.log(stub);
            if(data["$success"] === "true") {
              if(dynamicStubEntry.input) {
                dynamicStubEntry.input = self.changeStubEntryPath(dynamicStubEntry.input, newFolderName);
              }
              if(dynamicStubEntry.output) {
                dynamicStubEntry.output = self.changeStubEntryPath(dynamicStubEntry.output, newFolderName);
              }
              if(dynamicStubEntry.error) {
                dynamicStubEntry.error = self.changeStubEntryPath(dynamicStubEntry.error, newFolderName);
              }
              delete(stub.dynamic[oldFolderName]);
              //Vue.set(stub.dynamic, newFolderName, dynamicStubEntry);
              stub.dynamic[newFolderName] = dynamicStubEntry;
              stub.dynamic = self.sortObject(stub.dynamic);
              self.counter++
              self.saveStub();
            } else {
              //rerender stub
              self.counter++
              self.saveStub();
              iw.staticstubs.error("Could not change stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
            }
          }, iw.staticstubs.error);
        return newFolderName;
      },

      //This method changes the second folder in a three-folder path. Path names of stub entries look like this:
      //
      // dynamic/00001/test-input.xml ->  dynamic/00002/test-input.xml  
      changeStubEntryPath : function(path, newFolderName) {
        let a = path.split('/');
        a[1] = newFolderName;
        return a.join('/');
      },

      sortObject : function(unordered) {
        const ordered = {};
        Object.keys(unordered).sort().forEach(function(key){ordered[key] = unordered[key]});
        return ordered;
      },

      duplicateStubEntryFolder : function(baseDir, oldFolderName, stub) {
        let newFolderName = oldFolderName + "-duplicate";
        //Calculate the next folder name, if this folder name is numeric
        if(oldFolderName.match("^\\d+$")) {
           let b = Number(oldFolderName);
           let i = 0;
           while(true) {
             b++;
             newFolderName = String(b).padStart(oldFolderName.length, "0");
             iw.log("[duplicate] new folder name ("+i+"): " + newFolderName, 3);
             if(!stub.dynamic[newFolderName]) {
               break;
             }
             i++;
           }
        } 
        
        iw.log("Duplication stub entry;  baseDir: " + baseDir + "; old file name: " + oldFolderName + "; new file name: " + newFolderName, 3);
        let params = {"base-dir": baseDir, "source-file-name": oldFolderName, "target-file-name": newFolderName}
        let self = this;
        
        iw.invoke("iw.test.util.file:copy", params, function(data){
          iw.log("Copy successful? " +data["$success"], 3);
          if(data["$success"] === "true") {
            let dynamicStubEntry = stub.dynamic[oldFolderName];
            let newDynamicStubEntry = {};
            if(dynamicStubEntry.input) {
              newDynamicStubEntry.input = self.changeStubEntryPath(dynamicStubEntry.input, newFolderName); 
            }
            if(dynamicStubEntry.output) {
              newDynamicStubEntry.output = self.changeStubEntryPath(dynamicStubEntry.output, newFolderName);
            }
            if(dynamicStubEntry.error) {
              newDynamicStubEntry.error = self.changeStubEntryPath(dynamicStubEntry.error, newFolderName);
            }
            //Vue.set(stub.dynamic, newFolderName, newDynamicStubEntry);
            stub.dynamic[newFolderName] = newDynamicStubEntry;
            stub.dynamic = self.sortObject(stub.dynamic);           
            //self.counter++
            //Not necessary
            //self.saveStub();
          } else {
              iw.staticstubs.error("Could duplicate stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
          }
 
        }, iw.staticstubs.error);

      },

      deleteStubEntryFolder : function(baseDir, folderName, stub) {
        let self = this;
        iw.staticstubs.confirm.question = "Are you sure you want to delete dynamic stub entry " + folderName + "?";
        iw.staticstubs.confirm.confirmAction = function () {                    

          iw.log("Deleting stub entry;  baseDir: " + baseDir + "; folder name: " + folderName);
          let params = {"base-dir": baseDir, "file-name": folderName, "recursive": "true"};
          
          iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Delete successful? " +data["$success"], 3);
           
            if(data["$success"] === "true") {
              delete(self.stub.dynamic[folderName]);
              iw.log("Delete of folder " + folderName + " successful, removing from 'dynamic' structure", 3);
              
            } else {
                iw.staticstubs.error("Could delete stub entry '" + folderName );
            }

          }, iw.staticstubs.error);
            
        };
        iw.staticstubs.confirm.showconfirmationdialog = true;      
        


      },

      changeStubEntryResult : function(baseDir, name, path, stub) {
        iw.log("Changing stub entry result. baseDir: " + baseDir + "; name: " + name + "; path: " + path + "; stub: " + JSON.stringify(stub));

        let dynamicStubEntry = stub.dynamic[name];
        let oldFileName = path;
        let newFileName = "";
        if(dynamicStubEntry.output) {
          newFileName = oldFileName.replace('test-output.xml', 'test-error.xml'); 
        } else if (dynamicStubEntry.error) {
          newFileName = oldFileName.replace('test-error.xml', 'test-output.xml'); 
        } else {
          iw.warn("Cannot change stub entry result, because file is not 'test-output.xml' nor 'test-error.xml'", 2);
        }
        iw.log("Changing stub entry; baseDir: " + baseDir + "; old file name: " + oldFileName + "; new file name: " + newFileName, 3);
        let params = {"base-dir": baseDir, "existing-file-name": oldFileName, "new-file-name": newFileName}
        let self = this;

        iw.invoke("iw.test.util.file:rename", params, function(data){
            iw.log("Dynamic stub folder name changed? " +data["$success"], 3);
            //console.log(stub);
            if(data["$success"] === "true") {
              if(dynamicStubEntry.output) {
                
                stub.dynamic[name].error = newFileName;
                delete(stub.dynamic[name].output);
              } else {
                
                stub.dynamic[name].output = newFileName;
                delete(stub.dynamic[name].error);
              }
              //Not necessary. The definition does not change when changing a stub entry result
              //self.saveStub();
            } else {
              //rerender stub is not necessary
              //self.saveStub();
              iw.staticstubs.error("Could not change stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
            }
          }, iw.staticstubs.error);

      },

      changePathName : function(oldServiceName, newServiceName) {
        //pipeline['file-name']
        //service['input-file]
        //dynamic['stub-base-dir']
        if(this.stub.pipeline) {
          this.stub.pipeline['file-name'] = this.stub.pipeline['file-name'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Updated stub pipeline file name. New file name: " + this.stub.pipeline['file-name'], 3 );
        }
        if(this.stub.service && this.stub.service['input-file']) {
          this.service['input-file'] = this.service['input-file'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Updated stub service input file name. New file name: " +  this.service['input-file'], 3 );
        }
        if(this.stub.dynamic && this.stub.dynamic['stub-base-dir']) {
          this.stub.dynamic['stub-base-dir'] = this.stub.dynamic['stub-base-dir'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Update stub dynamic stub directory: new directory: " + this.stub.dynamic['stub-base-dir'] , 3);
        }
      },
         
      showPipelineDialog : function (baseDir, fileName, service, output, error) {
        iw.log("[stub] show pipeline dialog; output: " + output + "; error: " + error + "; read-only: " + this.active, 3);
        this.$emit('show-pipeline-editor', {"baseDir": baseDir, "fileName": fileName, "service" : service, "output": output, "error": error, "readonly": this.active});
      },  
                
      removePipelineFile : function () {
        let params = {"file-name": this.stub.pipeline['file-name'], "base-dir" : this.baseDir};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub pipeline file removed? " + data["$success"]);
        }, iw.staticstubs.error);
      },       
      removeServiceStubInput : function() {
        let params = {"file-name": this.stub.service['input-file'], "base-dir" : this.baseDir};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub service input file removed? " + data["$success"]);
        }, iw.staticstubs.error);         
      },
       
      removeDynamicStubInputFiles : function () {
        let params = {"file-name": this.stub.dynamic['stub-base-dir'], "base-dir" : this.baseDir, recursive: true, "only-subdirs": true};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub dynamic files removed? " + data["$success"]);
        }, iw.staticstubs.error);  
      },
       
      removeAllStubFiles : function () {
        let params = {"file-name": this.stubBaseDir, "base-dir" : ".", recursive: true};
        iw.log("Remove all stub files; params: " + JSON.stringify(params), 3);
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub dynamic files removed? " + data["$success"]);
        }, iw.staticstubs.error);  
      },
       
      resetStub : function() {
        iw.log("Reset stub called. current stub: " + JSON.stringify(this.stub)); 
        iw.log("initial stub: " + JSON.stringify(this.initialStub));
        this.cleanupStubFiles(true);
        
        this.isDirty = false;
        this.$emit('reset-stub');   
      },
       
      cleanupStubFiles : function(isReset) {
        iw.log("Clean up stub called. Reset: " + isReset,3);
        iw.log("this.stubType: " + this.stubType + "; this.initialStubType: " + this.initialStubType, 3);
        // clean up 
        if((!isReset && this.stubType  === 'pipeline') || (isReset && this.initialStubType === 'pipeline')) {
          iw.log("Cleaning up all but pipeline input", 3);
          if(this.stub.service  !== undefined) this.removeServiceStubInput();
          if(this.stub.dynamic  !== undefined) this.removeDynamicStubInputFiles();
         
          delete(this.stub.service);
          delete(this.stub.exception);
          delete(this.stub.dynamic);
          
        } else if((!isReset && this.stubType === 'service') || (isReset && this.initialStubType === 'service')) {
          iw.log("Cleaning up all but service input", 3);
          if(this.stub.pipeline !== undefined) this.removePipelineFile();
          if(this.stub.dynamic  !== undefined) this.removeDynamicStubInputFiles();
          if(this.stub.service  !== undefined && this.stub.service['input-file'] === "") this.removeServiceStubInput();
        
          delete(this.stub.pipeline);
          delete(this.stub.exception);
          delete(this.stub.dynamic);
        } else if((!isReset && this.stubType === 'exception') || (isReset && this.initialStubType === 'exception')) {
          iw.log("Cleaning up all stub files", 3);
          this.removeAllStubFiles();
          
          delete(this.stub.pipeline);
          delete(this.stub.service);
          delete(this.stub.dynamic);
          
        } else if((!isReset && this.stubType === 'dynamic') || (isReset && this.initialStubType === 'dynamic')) {
          iw.log("Cleaning up all but dynamic stub data", 3);
          if(this.stub.pipeline !== undefined) this.removePipelineFile();
          if(this.stub.service  !== undefined) this.removeServiceStubInput();            
          
          delete(this.stub.pipeline);
          delete(this.stub.service);
          delete(this.stub.exception);
          
        } else {
          iw.log("Not cleaning stub files: no condition applied", 3);
        }
      },
            
      emitHideEditStubDialog : function() {
        iw.log("Before emitting 'hide-dialog'. Stub:");
        //console.log(this.stub);
        this.$emit('hide-dialog', this.stub);
      },
      
      saveStub : function() {
        this.isDirty = false;        
        this.cleanupStubFiles();
        iw.log("Saving stub in component. Stub:", 3);

        let stubEvent = {"base-dir": this.path, "auto-load": String(this.autoLoad), "stub": this.stub};
        if(this.locationType === "package") {
          stubEvent["package"] = this.locationName;
        }
        if(this.locationType === "external") {
          stubEvent["location-alias"] = this.locationName;
        }
        
        if(this.force === true) {
          stubEvent.force = "true"
          this.force = false;                   
        }
        if(this.generateFromRuns === true) {
          stubEvent.download = "true";
          if(this.deleteRunsAfterDownload === false) {
            stubEvent["do-not-delete"] = "true"
          }
          if(this.remoteAlias !== null) {
            stubEvent.$alias = this.remoteAlias;
          }
        }
        this.$emit('save-stub', stubEvent );
     }
    }    
  });
  
  //register the global directives
  iw.staticStubsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.staticStubsApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.staticStubsApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.staticStubsApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  iw.staticStubsApp.component(iw.app.components.selectService.name,      iw.app.components.selectService.impl);
  iw.staticStubsApp.component(iw.app.components.selectServiceModal.name, iw.app.components.selectServiceModal.impl);
  iw.staticStubsApp.component(iw.app.components.selectFile.name,         iw.app.components.selectFile.impl);
  iw.staticStubsApp.component(iw.app.components.selectUser.name,         iw.app.components.selectUser.impl);
  iw.staticStubsApp.component(iw.app.components.selectSession.name,      iw.app.components.selectSession.impl);
  
  iw.staticstubs = iw.staticStubsApp.mount('#staticstubs-app');
  iw.staticstubs.getInfo();
  iw.staticstubs.getConfig();

})(this, undefined);
