"use strict";
(function(window, undefined) {
         
  if(window.iw === undefined) window.iw = {};  
   
  iw.stubsApp = Vue.createApp({
    created() {
      //This piece of logic serves to decode the url:
      //split the query string into parameters and values
      let uri = window.location.href.split('?');
      if (uri.length == 2) {
        let vars = uri[1].split('&');
        let getVars = {};
        let tmp = '';
        vars.forEach(function(v){
          tmp = v.split('=');
          if(tmp.length == 2)
          getVars[tmp[0]] = decodeURIComponent((tmp[1] + '').replace(/\+/g, '%20'));
        });
        this.queryParams = getVars;
      }
    },
    computed: {
      messageLink: function() {
        if(this.lastCreatedTestSuite == null) {
          return null;
        } else {
          return 'testsuites.html?testSuiteServiceName=' + this.lastCreatedTestSuite;
        }
      },
      inputOutputEditorVerticalOffset: function() {
          let offset = 150;
          
          if(iw.stubs.config["ui.distributed.enabled"] === 'true') {
              offset += 25;
          }
          return offset;
      }
    },

    data : function() {
      return {
        defaultRefreshInterval    : 2000,  //in milliseconds
        message                   : "",        
        success                   : true,
        lastCreatedTestSuite      : null,
        config                    : {},
        info                      : {},
        license                   : {
           product                : "IwTest",
           version                : "1.*",
           licensee               : "",
           type                   : "",
           "valid-until"          : "",
           "valid-until-ts"       : -1,
           valid                  : true,
           expired                : false,
           "version-ok"           : true,
           "days-left"            : -1
        },
        product :  {
          name                    : "",
          version                 : "",
          "latest-version"        : "",
          "latest-check-date"     : "",
          "installation-date"     : "",
          "installation-ts"       : 0
        },
        confirm                   : {
          question                : null,
          showconfirmationdialog  : false,
          confirmAction           : function(){}
        },         
        showstubdetailsdiv        : false,
        selecteddynamickey        : null,
        showpipelineviewer        : false,
        pipelineviewertopposition : 180,
        
        singleviewer              : true,
        
        servers           : {}, // 
         /*
           {"alias1" : {"is-enabled" : true,
                        "recording-config" :
                          [
                            { "service" : "service1",
                              "stubs"   : ["stub1", "stub2"]
                             },
                          
                          ]
                        }
           }
         */
    
      }
    },
    
    methods : {      

      //Use this function for showing the result of actions, not for data retrieval
      response :function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(data, 4);
         iw.stubs.showMessage(data["$message"], data["$success"] === "true" , 2500);
      },
     
      error : function(msg) { 
        iw.log(msg, 0);
        iw.stubs.showMessage(msg, false , 2500);       
      },      
            
      showMessage : function(msg, success, timeout) {  
         iw.stubs.message     = msg;
         iw.stubs.success     = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.stubs.message=""}, timeout);
         }
      },
      
      hideMessage : function() {
         iw.stubs.message     = "";
         iw.stubs.messageLink = "";
      },
     
      getConfig : function() {
         iw.invoke("iw.test.config:get", {}, function(data) {
            iw.stubs.config = data;    
            iw.stubs.listAliases();
            iw.stubs.listPackages();
         }, iw.stubs.error);
      },
      
      getInfo : function() {
         iw.invoke("iw.test.admin:info", {}, function(data) {
            iw.stubs.info    = data.license;
            iw.stubs.product = data.product;
         }, iw.stubs.error);
      },

      getSession : function() {
         iw.invoke("pub.flow:getSession", {}, function(data) {
            iw.stubs.lastCreatedTestSuite  = data.$session["last-created-test-suite-service-name"];            
         }, iw.stubs.error);
      },        
      
      listAliases: function() {
        if(iw.stubs.config["ui.distributed.enabled"] === "false") {
     
            iw.stubs.availableAliases = [iw.localAlias];         
            iw.stubs.servers[iw.localAlias] = {};
            iw.stubs.servers[iw.localAlias].expanded = true;
            iw.stubs.listStubbedServices(iw.localAlias); 
        } else {
          iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.stubs.availableAliases = data.aliases.map(function(a){return a.split(":")[0]});
            iw.stubs.availableAliases.unshift(iw.localAlias );
            //iw.stubs.getConfig();
            for(var i = 0; i < iw.stubs.availableAliases.length ; i++ ) {              
              iw.stubs.servers[iw.stubs.availableAliases[i]] = {};
              if(iw.stubs.availableAliases[i] === iw.localAlias) {
                iw.stubs.servers[iw.localAlias].expanded = true;
              }  
              iw.stubs.listStubbedServices(iw.stubs.availableAliases[i]);                            
            }
            
         }, iw.stubs.error);         
        }
      },
    
      listPackages : function(alias, showRecordPanel) {
        let params = {"$alias": alias};
        iw.invoke("iw.test.ui.ns:listPackages", params, function(data) {
          iw.log("Retrieved packages for " + alias, 3);
        
          iw.stubs.packages = data.packages.filter(function(a){                 
               return a.enabled === "true" && a["system-package"] !== "true";
          }).sort(function(a,b){ if(a.name >= b.name) return 1; else return -1});
          
          if(alias === undefined || alias === '' || alias === 'local' || alias === '(local)') {
              iw.stubs.localPackages = data.packages.sort(function(a,b){if(a.name >= b.name) return 1; else return -1});              
              iw.stubs.enabledLocalPackages = data.packages.filter(a => a.enabled === "true" && a["system-package"] !== "true").
                 sort(function(a,b){if(a.name >= b.name) return 1; else return -1});              
            }    
          
          if(showRecordPanel) iw.stubs.showrecorddialog = true
        }, iw.stubs.error);
      },
    
      listStubbedServices : function(alias) {
        let params = {"$alias": alias};
        
        iw.invoke("iw.test.ui.stub:list", params, function(data) {
          console.log(data);
          if(data["$success"] === "true") {       
        
            //Deal with older IS's
            
            if(data.stubbedServices) {
              //The signature has changed in v1.11 'stubbedServices' is older
              iw.stubs.servers[alias].available = false
              iw.stubs.servers[alias]["error-message"] = "Please upgrade IwTest on '" + alias + "' to the latest version";
            } else {
              iw.stubs.servers[alias] = data;
              iw.stubs.servers[alias].available = true;
              iw.stubs.servers[alias].server.expanded  = true;
              for(let i = 0 ; i < iw.stubs.servers[alias].user.length ; i++) {
                iw.stubs.servers[alias].user[i].expanded = true;
              }
              for(let i = 0 ; i < iw.stubs.servers[alias].session.length ; i++) {
                iw.stubs.servers[alias].session[i].expanded = true;
              }
            }
          } else {
            iw.stubs.servers[alias].available = false;
            iw.stubs.servers[alias]["error-message"] = data.$message.substring(data.$message.lastIndexOf(":") + 1);
          }
        });
      },
    
      off : function(alias, id, service) {
        iw.log("Remove stub called. alias: " + alias +  "; id: " + id + "; service: " + service, 3);
        iw.stubs.confirm.question = "Are you sure you want to remove the stub for service " + service;
        
        iw.stubs.confirm.confirmAction = function() {
        
          let params = {"$alias": alias, "id": id};
          iw.invoke("iw.test.ui.stub:off", params, function(data){
             iw.stubs.response(data);
             if(data.$success == "true") {
               iw.stubs.listStubbedServices(alias);
             }
          });
        }
        iw.stubs.confirm.showconfirmationdialog = true;
      },

     createJSONEditor: function(elementName, onChangeFunction, editable) {
        let container = document.getElementById(elementName);
        let options = { modes:["tree","code","text"],
                             enableTransform: false,
                             onChange: onChangeFunction,
                             onEditable: function(){return editable},
                             onClassName: function(c) {
                               //iw.log("on-class-name: " + c.path + " " + c.field + " " + c.value, 3)
                             }
                           }
        let jeditor = new JSONEditor(container, options);
        jeditor.setName("pipeline");
        jeditor.set({});
        return jeditor
      },

      isEmpty : function(object) {
        return iw.isEmpty(object);
      },

      showDynamicStubEntry : function(key, entry) {
                                  iw.stubs.dynstubName = key;
                                  iw.stubs.dynstubMatch  = entry.input;
                                  iw.stubs.dynstubResult = entry.output;
        if(entry.output === null) iw.stubs.dynstubResult = entry.error;
        
        iw.stubs.showsdynamicstubpipelinediv = true;
        
        Vue.nextTick(function() {
        let inputviewer = iw.stubs.createJSONEditor("pipelineinputviewer", function(){}, false);
        inputviewer.set(entry.input);
        
        let outputviewer = iw.stubs.createJSONEditor("pipelineoutputviewer", function(){}, false);
        if(entry.output) outputviewer.set(entry.output);
        else outputviewer.set(entry.error);
        });
        
      },
      
      displayDynamicStubEntry : function(key) {
        let input  = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][key].input;
        let output = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][key].output;
        if(typeof(output) === "undefined") {
          output = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][key].error;
        }
        iw.jsoninputeditor.set(input);
        iw.jsonoutputeditor.set(output);
        
        iw.stubs.selecteddynamickey = key;
      },
      
      composeDownloadFileLink: function(alias, path) {
        let url = "/invoke/iw.test.ui.testrun/getPipeline?download=true&file-name=" + path;
        if(typeof(alias) === "string" && alias.length > 0) {
            url += "&$alias=" + alias;
        }
        return url;
      }
    
    }
  });

  iw.stubsApp.component('list-stubs', {
  
    template : "#list-stubs-template",
      
    props : ['alias', 'scope', 'subScope', 'services'],
      
    data : function() {
      console.log("Initializing 'list-stubs'-component");
      console.log(this.alias);
      console.log(this.scope);
      console.log(this.services);
      return {
        expanded : true,
        stubbedService : {}
      }
    },
     
    methods: {
      off : function(alias, id, service) {
        iw.log("Remove stub called. alias: " + alias +  "; id: " + id + "; service: " + service, 3);
        iw.stubs.confirm.question = "Are you sure you want to remove the stub for service " + service + "?";
        
        iw.stubs.confirm.confirmAction = function() {
        
          let params = {"$alias": alias, "id": id};
          iw.invoke("iw.test.ui.stub:off", params, function(data){
             iw.stubs.response(data);
             if(data.$success == "true") {
               iw.stubs.listStubbedServices(alias);
             }
             iw.stubs.confirm.showconfirmationdialog = false;
          });
        }
        iw.stubs.confirm.showconfirmationdialog = true;
      },
  
      showStubDetails : function(alias, service, scope, subScope) {
        let params = {"$alias" : alias, "service" : service, "scope": scope };
        if(scope === "user")    params.user  = subScope;
        if(scope === "session") params.ssnid = subScope;
        
        iw.invoke("iw.test.ui.stub:get", params, function(data){
          iw.stubs.stubbedService = Object.freeze(data["stubbed-service"]);
          iw.stubs.showstubdetailsdiv = true;
          
            if(iw.stubs.stubbedService.stub.type === "pipeline" || iw.stubs.stubbedService.stub.type === "service") {
              iw.stubs.showpipelineviewer = true;
              iw.stubs.singleviewer       = true;
              iw.stubs.pipelineviewertopposition = 180;
              if(iw.stubs.stubbedService.stub.type === "service") {
                iw.stubs.pipelineviewertopposition = 210;
              }
            } else if(iw.stubs.stubbedService.stub.type === "dynamic" ) {
              iw.stubs.showpipelineviewer = true;
              iw.stubs.singleviewer       = false;
              iw.stubs.pipelineviewertopposition = 180;
            } else {
              iw.stubs.showpipelineviewer = false;
            }
          
          Vue.nextTick(function(){
            
            
            if(iw.stubs.stubbedService.stub.type === "pipeline" || iw.stubs.stubbedService.stub.type === "service") {
              let editorElement = "pipelineviewer";              
              
              iw.jsoninputeditor = iw.stubs.createJSONEditor(editorElement, function(){}, false);
              
              iw.jsoninputeditor.set(iw.stubs.stubbedService.stub.data);
            } else if(iw.stubs.stubbedService.stub.type === "dynamic") {
              let inputEditorElement  = "pipelineinputviewer";
              let outputEditorElement = "pipelineoutputviewer";
              //input/output/error
              
              iw.jsoninputeditor  = iw.stubs.createJSONEditor(inputEditorElement, function(){}, false);
              iw.jsonoutputeditor = iw.stubs.createJSONEditor(outputEditorElement, function(){}, false);
              for(let e in iw.stubs.stubbedService.stub.data["$dynamic-stub-data"]) {
                let input  = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][e].input;
                let output = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][e].output;
                if(typeof(output) === "undefined") output = iw.stubs.stubbedService.stub.data["$dynamic-stub-data"][e].error;
                
                iw.jsoninputeditor.set(input);
                iw.jsonoutputeditor.set(output);
                iw.stubs.selecteddynamickey = e;
                break;
              }
              
              
              
              
              
            }
            
            
          });
        });
      }
    }
  });
   
  iw.stubsApp.component('stubs-details', {
  
    template : "#stubs-details-template",
      
    props : ['alias', 'scope', 'subScope', 'stub'],
      
    data : function() {
      console.log("Initializing 'stub-details'-component");
      console.log(this.alias);
      console.log(this.scope);
      console.log(this.services);
      return {
        expanded : true
      }
    },
     
   });

  //register the global directives
  iw.stubsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.stubsApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.stubsApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.stubsApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  iw.stubsApp.component(iw.app.components.selectService.name,      iw.app.components.selectService.impl);
  iw.stubsApp.component(iw.app.components.selectServiceModal.name, iw.app.components.selectServiceModal.impl);
  iw.stubsApp.component(iw.app.components.selectFile.name,         iw.app.components.selectFile.impl);

  iw.stubs = iw.stubsApp.mount("#stubs-app");

  iw.stubs.getInfo();    
  iw.stubs.getConfig(); 
  iw.stubs.getSession(); 
   
})(this, undefined);
      
