"use strict";

(function(window, undefined) {

  if(window.iw === undefined) window.iw = {};
  
  iw.testsuitesApp = Vue.createApp({
    created() {
    
    },

    data : function() {
      return {
        info : {},
        
        assertionTypes: {},
        
        suites: {},
        
        filteredSuites : {},
        
        testSuiteData: {
          baseDir: "",
          configuredBaseDir: "",
          packageName: "",
          service: "",
          testSuite: {}
        },

        showSuitesInTree     : true,
        showrundiv           : false,
        clearTestResults     : false,
        executeIndices       : [],      
        remoteTestSuiteAlias : "", //for the 'run' functionality
        
        showexecutediv       : false,
        isRepairMode         : false,
        repairOptionKeepRegexps : true,
        repairOptionExpected : true,
        
        packageFilter        : "",
        interfaceFilter      : "",
        serviceFilter        : "",
        dcc                  : false,
        skipStubs            : false,
        extraTargetPackages  : "",
        executeType          : "",
        remoteAlias          : "",  //for the 'executed' functionality
        running              : false,
        
        lastTestSuiteService : "",
        
        showdeletediv: false,
        deleteIndices: [],
        removeDataOnDisk: true,
        
        showpipelinediv: false,
        pipeline: {
          data                          : {},
          isproblematic                 : false,
          ignoreWarning                 : false,
          path                          : "",
          raw                           : "",
          service                       : null,
          schema                        : null,
          output                        : false,
          error                         : false,
          generateMinimal               : false,
          generateOnlyStructure         : false,
          generateNumberOfArrayElements : 1, 
          sampleData                    : null,
          sampleDataXML                 : null
        },
        
        showexecutesetupteardowndiv: false,
        executeServiceData: {
          remoteAlias : "",
          service     : "",
          baseDir     : "",
          fileName    : "",
          type        : ""
        },
        
        isdirtypipeline : false,
        
        isdirtyxmlpipeline : false,
        
        isdirtyjsonpipeline : false,
        
        pipelinePopup : null,
        
        packagesExpansionList : [],
        
        testCasesExpansionList : [],
        
        showeditdiv: false,
        
        showraweditor: false,    
        
        showresultsdiv: false,
        
        showduplicatetestcasediv : false,
        
        modal: false,
        
        duplicateTestCaseData : {
          remoteTestSuiteAlias : "",
          testSuiteServiceName : "",
          service              : "",
          originalTestCaseName : "",
          newTestCaseName      : "",
          originalStubs        : [],        
          testCaseName         : "",
          extraStubbedServices : [],
          tmpInputFile         : "",
          copyAssertions       : true,
          copyCallbacks        : true
        },
        
        results: {},
        
        selectedService: "",
        
        localPackages : [],
        
        message: "",
        
        success: true,
        
        environments: [],
        
        environment: "",

        aliases: [],      
        
        config : {},
        
        editTestSuiteDetailsZIndex : 0,
        
        lastEditedTestSuiteService : null
         
      }
    },
    computed : {
    
      runUrl : function() {
        let url = "";
        if(this.info.host) {
          url = this.info.host.protocol + "://" + this.info.host.server + ":" + this.info.host.port + "/invoke/iw.test.execution.pub/run";
          
          let query = "";
        
          if(this.executeType !== "") {
            if(query.length > 0) query += "&";
            query += "type=" + this.executeType;
          }

          if(this.dcc) {
            if(query.length > 0) query += "&";
            query += "dcc=true";
          }
        
          if(this.extraTargetPackages) {
            if(query.length > 0) query += "&";
            query += "extraTargetPackages=" + encodeURIComponent(this.extraTargetPackages);
          }
          if(this.packageFilter && this.packageFilter !== "") {
            if(query.length > 0) query += "&";
            query += "packageFilter=" + encodeURIComponent(this.packageFilter);
          }
        
          if(this.interfaceFilter && this.interfaceFilter !== "") {
            if(query.length > 0) query += "&";
            query += "interfaceFilter=" + encodeURIComponent(this.interfaceFilter);
          }
        
          if(this.serviceFilter && this.serviceFilter !== "") {
            if(query.length > 0) query += "&";
            query += "serviceFilter=" + encodeURIComponent(this.serviceFilter);
          }
        
          if(this.remoteAlias !== "") {
            if(query.length > 0) query += "&";
            query += "remote-alias=" + encodeURIComponent(this.remoteAlias);          
          }
          if(this.environment !== "") {
            if(query.length > 0) query += "&";
            query += "environment=" + encodeURIComponent(this.environment);            
          }
          if(query !== "") url += "?" + query;
          
          //Prevent from making a call to the IS if the rundiv is not active
          if(this.showrundiv === true) { 
            this.getFilteredTestSuites()
          }
          
        }
        iw.log("Computed url: " + url, 3);
        return url
      },

      containsCallbacks : function() {
        let result = false;
        if(this.testSuiteData.testSuite && this.testSuiteData.testSuite["test-cases"]) {
        
          if(this.executeIndices && this.executeIndices.length > 0 ) {
              for(let k = 0; k < this.executeIndices.length ; k++) {

                let tc = this.testSuiteData.testSuite["test-cases"][this.executeIndices[k]]
                 if(tc.callbacks && tc.callbacks.length > 0) {               
                    result = true;
                    break ;            
                }
              }
          } else {
            //loop over test-cases and check whether there are any valid ones
            for(let i = 0; i < this.testSuiteData.testSuite["test-cases"].length; i ++) {
                let tc = this.testSuiteData.testSuite["test-cases"][i];         
                if(tc.callbacks && tc.callbacks.length > 0) {               
                    result = true;
                    break;            
                }
            }
          }
        }
        return result;
      },

      editTestSuiteDetailsVerticalOffset : function() {
        let offset = 245;
        
        if(typeof(this.testSuiteData.testSuite.setup)    !== "undefined" && typeof(this.testSuiteData.testSuite.setup.service) == "string") {
          offset += 30;
        }
        if(typeof(this.testSuiteData.testSuite.teardown) !== "undefined" && typeof(this.testSuiteData.testSuite.teardown.service) === "string") {
          offset += 30;
        }
        return offset;
      },
      
      runTestSuitesVerticalOffset : function() {
        let offset = 315;
        
        if(this.config['ui.distributed.enabled'] === 'true') {
          offset += 30;
        }
        if(this.dcc === true) {
          offset += 30
        }
        return offset;
      }
    },
    
    watch : {
      //Whenever environment changes, update the list of allowed remote aliases
      environment : function(newEnvironment, oldEnvironment) {
        if(newEnvironment !== "") {
          this.aliases = this.environments.filter(function(env){ return env.name === newEnvironment})[0].aliases
        } else {
          iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.log("Aliases retrieved from server", 3);
            iw.testsuites.aliases = data.aliases.map(function(a){return a.split(":")[0]}).sort(function(a,b){return a > b});          
          });
        }
      }
    },
    
    methods : {
      
      setEditTestSuiteDetailsZIndexForground : function() {
        this.editTestSuiteDetailsZIndex = -1;
      },
      setEditTestSuiteDetailsZIndexBackground : function() {        
        this.editTestSuiteDetailsZIndex = 0;
      },
    
      //Use this function for showing the result of actions, not for data retrieval
      response : function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(JSON.stringify(data), 4);
         iw.testsuites.showMessage(data["$message"], data["$success"] === "true" , 2500);        
         //iw.testsuites.getAllTestSuites();
      },
      
      error : function(msg) { 
        iw.log(msg, 0);
        iw.testsuites.showMessage(msg, false , 3000);       
      },
      
      showMessage : function(msg, success, timeout) {  
         iw.testsuites.message = msg;
         iw.testsuites.success = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.testsuites.message= ""; iw.testsuites.success = true}, timeout);
         }
      },
      nonAlphaNumsToUnderscores : function(text) {
		      // \W matches all non-alphanumeric. Equivalent to [^A-Za-z0-9_]
		      return text.replace(/[\W]+/g, '_');
      },
      hideMessage : function() {
         iw.testsuites.message = "";
         iw.testsuites.success = true;
      },
      
      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.testsuites.info = data;          
        });
      },
      getSession : function() {
         iw.invoke("pub.flow:getSession", {}, function(data) {
            iw.testsuites.lastEditedTestSuiteService  = data.$session["last-edited-test-suite-service-name"];            
         }, iw.testsuites.error);
      },    
      
      setLastEditedTestSuiteService : function(testSuiteServiceName) {
          iw.testsuites.lastEditedTestSuiteService = testSuiteServiceName;
          let params = { "test-suite-service-name" : testSuiteServiceName};
          iw.invoke("iw.test.generate.service:storeLastEditedTestSuite", params, function(data) {}, iw.testsuites.error);
      },
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.testsuites.config = data;          
        });        
      },
      
      getAssertionTypes : function() {
        iw.invoke("iw.test.assertion.service:getAssertionTypes", {}, function(data) {
          iw.testsuites.assertionTypes = data['assertion-types'];          
        })      
      },
      
      refreshAllTestSuites : function() {
        iw.invoke("iw.test.ui.testsuite:list", {"refresh" : "true"}, function(data) {
          iw.testsuites.suites = data;          
          iw.log("Test suite data retrieved from server (refresh)", 3);
          iw.testsuites.response(data);
        })
      },
      
      getAllTestSuites : function(isInitial) {
        iw.invoke("iw.test.ui.testsuite:list", {}, function(data) {
          iw.testsuites.suites = data;          
          iw.log("Test suite data retrieved from server", 3);

          //Handle query parameters: open a test suite editor and expand the right test case          
          if(isInitial) {
            
            if(iw.queryParams && (iw.queryParams.testSuiteName || iw.queryParams.testSuiteServiceName)) {
              iw.log("Query params: testSuiteServiceName: " + iw.queryParams.testSuiteServiceName + "; testSuiteName: " + iw.queryParams.testSuiteName + "; testCaseName: " + iw.queryParams.testCaseName, 3)
              let found = false;
              //Lookup the test suite service/package based on testSuiteName. The list is available in iw.testsuites.suites
              for(let i = 0 ; i < iw.testsuites.suites['test-packages'].length ; i ++) {
                for(let j = 0 ; j < iw.testsuites.suites['test-packages'][i]['test-suite-service'].length ; j ++) {
                  //No test suite service given, only the test suite name.
                  if(iw.queryParams.testSuiteName) {
                    if(iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-suite-name'] === iw.queryParams.testSuiteName ) {
                      iw.log('bingo: ' + iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-suite-name'], 3); 

                      //If the test case name is given, look for the it in this test suite, else just use the test suite service
                      if(iw.queryParams.testCaseName) {
                        for(let k = 0 ; k < iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-cases'].length ; k ++) {
                          if(iw.queryParams.testCaseName === iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-cases'][k].name) {
                            var testSuiteServiceName = iw.testsuites.suites['test-packages'][i]['test-suite-service'][j].name;
                            var packageName          = iw.testsuites.suites['test-packages'][i]['package'];
                            found = true;
                            break;
                          } else {
                            iw.log('mist2: ' + iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-cases'][k].name, 3); 
                         
                          }
                        }
                      } else {
                        var testSuiteServiceName = iw.testsuites.suites['test-packages'][i]['test-suite-service'][j].name;
                        var packageName          = iw.testsuites.suites['test-packages'][i]['package'];
                        found = true;
                        break;
                      }
                    } else {
                        iw.log('mist: ' + iw.testsuites.suites['test-packages'][i]['test-suite-service'][j]['test-suite-name'], 3); 
                    }
                  } 
                  if(iw.queryParams.testSuiteServiceName) {
                    if(iw.testsuites.suites['test-packages'][i]['test-suite-service'][j].name  === iw.queryParams.testSuiteServiceName ) {
                      var testSuiteServiceName = iw.testsuites.suites['test-packages'][i]['test-suite-service'][j].name;
                      var packageName          = iw.testsuites.suites['test-packages'][i]['package'];
                      found = true;
                      break;
                    }
                  } 
                  if (found) break;  
                }     
                if (found) break;  
              }
   
              if(testSuiteServiceName) {                
                iw.testsuites.showEditDialog({testSuiteServiceName: testSuiteServiceName, testCaseName: iw.queryParams.testCaseName});
                //Expand the package and highlight the service
                //Vue.set(iw.testsuites.packagesExpansionList, packageName, true);
               iw.testsuites.packagesExpansionList[packageName] = true;
              } else {
                iw.log("No test suite service found for test suite " + iw.queryParams.testSuiteName, 3);
              }
            }


          }          

        });
        
        iw.invoke("iw.test.environment:list", {environment: this.environment}, function(data){
          iw.testsuites.environments = data.environments;
        });
        
        /* Call to iw.test.ui.config:get instead of to iw.test.alias:list in order to get the availability */
        iw.invoke("iw.test.ui.config:get", {}, function(data) {
          iw.log("Aliases retrieved from server", 3);
          iw.testsuites.aliases = data.agents.filter(function(agent){return agent.$success === "true"}).map(function(agent){return agent.$alias});
        });
       
      },
      
      getFilteredTestSuites : function() {
        iw.invoke("iw.test.ui.testsuite:list",
          {"packageFilter": this.packageFilter, "interfaceFilter" : this.interfaceFilter, "serviceFilter": this.serviceFilter, "type": this.executeType}, 
            function(data) {
              iw.testsuites.filteredSuites = data;          
              iw.log("Filtered test suites retrieved from server", 3);
            }       
        )
      },      
      
      getTestSuite : function(testSuiteServiceName, showFunction) {
        iw.log("[getTestSuite] testSuiteServiceName: " + testSuiteServiceName + "; showFunction: " + showFunction), 3; 
        iw.testsuites.testSuiteData.service      = testSuiteServiceName;

        iw.invoke(testSuiteServiceName, {"definition-only" : true}, function(data) {

          let now = Date.now();          
          let testCases = data["test-suite"]["test-cases"];
          //Define keys for test suites, assertions, stubs and callbacks
          for(let i = 0; i < testCases.length; i++) {
              testCases[i].key = now;
              now += 100;
              
              if(testCases[i].stubs !== undefined) {
                for(let j = 0 ; j < testCases[i].stubs.length; j++) {
                  testCases[i].stubs[j].key = now;
                  now += 100;
                }              
              }
              if(testCases[i].callbacks !== undefined) {
                  for(let k = 0 ; k < testCases[i].callbacks.length; k++) {
                    testCases[i].callbacks[k].key = now;
                    now += 100;
                } 
              }
              
              if(testCases[i].expected !== undefined) {
                if(testCases[i].expected.assertions !== undefined) {
                  for(let n = 0 ; n < testCases[i].expected.assertions.length; n++) {
                    testCases[i].expected.assertions[n].key = now;
                    now +=100;
                  }
                }
              }
            
          }

          iw.testsuites.testSuiteData.testSuite         = data["test-suite"];
          iw.testsuites.testSuiteData.configuredBaseDir = data["base-dir"];
          iw.testsuites.testSuiteData.baseDir           = data["actual-base-dir"];      
        
          iw.testsuites.getTestSuiteResults();
          
          if(showFunction) {showFunction()};
          iw.log("Retrieved test suite data for " + testSuiteServiceName, 3);
        }        
        
      )},
      
      getTestSuiteResults : function() {
          //retrieve most recent results for this test suite, if any
          //This is used to indicate whether repairs are necessary
          let params = { "summary-only": true, "test-suite-name" : iw.testsuites.testSuiteData.testSuite.name};
          iw.invoke("iw.test.results.pub:get", params, function(data){
            iw.testsuites.results = Object.freeze(data.results);
          });
      },
      
      showRunDialog : function(args) {
        if(args) {
          let packageName          = args.packageName;
          let testSuiteServiceName = args.testSuiteServiceName;        
          let testCaseName         = args.testCaseName;
          
          iw.testsuites.packageFilter  = packageName;
          if(testSuiteServiceName !== undefined && testSuiteServiceName !== null) {
            if(testSuiteServiceName.indexOf(":") > 0) {
              iw.testsuites.interfaceFilter = testSuiteServiceName.split(":")[0];
              iw.testsuites.serviceFilter   = testSuiteServiceName.split(":")[1];
              iw.testsuites.lastTestSuiteService = testSuiteServiceName;
            } else {
              iw.testsuites.interfaceFilter = testSuiteServiceName + ".*";
            }
          } else {
              iw.testsuites.interfaceFilter = null
              iw.testsuites.serviceFilter   = null
          }
        }
        iw.testsuites.showrundiv = true;  
      },
      
      hideRunDialog : function() {
        iw.testsuites.showrundiv      = false;      
        iw.testsuites.packageFilter   = "";
        iw.testsuites.interfaceFilter = "";
        iw.testsuites.serviceFilter   = "";
        iw.testsuites.skipStubs       = false;
        iw.testsuites.dcc             = false;
        
      },
      
      runTestSuites : function(message) {

        iw.log("Running test suites. type: [" + this.executeType + "] package filter: [" + this.packageFilter + "] interface filter: [" + this.interfaceFilter + "] service filter: [" + this.serviceFilter + "] environment: [" + this.environment + "] remote alias: " + this.remoteAlias, 2);
        
        var pipeline = {
            "type"                   : iw.testsuites.executeType,
            "packageFilter"          : iw.testsuites.packageFilter,
            "interfaceFilter"        : iw.testsuites.interfaceFilter,
            "serviceFilter"          : iw.testsuites.serviceFilter,
            "skip-stubs"             : String(iw.testsuites.skipStubs),
            "dcc"                    : String(iw.testsuites.dcc),
            "extra-target-packages"  : iw.testsuites.extraTargetPackages,
            "environment"            : iw.testsuites.environment,
            "remote-alias"           : iw.testsuites.remoteAlias
        };
        if(iw.testsuites.remoteAlias) {
          pipeline["remote-alias"] = iw.testsuites.remoteAlias;
          if(iw.testsuites.environment) {
            pipeline.environment = iw.testsuites.environment;
          }
        }

        iw.invoke("iw.test.execution.pub:run", pipeline, function(data){
          iw.testsuites.running = false;
          iw.testsuites.showMessage(data["$message"], data["$success"] === "true" , 5000);
        });
        if(message !== undefined) {
            iw.testsuites.message = message;      
        } else {
            iw.testsuites.message = "Running test suites..";
        }
        
        iw.testsuites.running = true;
        iw.testsuites.showrundiv = false;
      },
      
      dccDisabled : function(alias) {
          return this.config['execute.coverage.enabled'] === 'false' || 
          (alias !== "" && alias.indexOf("local") < 0);
      },
      
      showExecuteDialog : function(testSuiteServiceName, repair) {
      
       iw.testsuites.isRepairMode   = repair;        
       iw.testsuites.showexecutediv = true;
       document.getElementById("executediv").focus();
       Vue.nextTick(document.getElementById("executediv").focus());
      
      },
      
      hideExecuteDialog : function() {
        iw.testsuites.showexecutediv = false;   
        iw.testsuites.executeIndices = [];
        iw.testsuites.skipStubs      = false;
        iw.testsuites.dcc            = false;
      },
      
      executeInlineTestCase : function(testSuiteService, clearTestResults, index) {
        //Always show execute dialog, to allow for disabling stubs
        iw.log("Executing inline test case. Test suite service: " + testSuiteService + "; clearTestResults: " + clearTestResults + "; index: " + index, 3);
        this.executeIndices = [index];
        this.showExecuteDialog(testSuiteService, false);
        return;
        if(iw.testsuites.config["ui.distributed.enabled"] === "true") {
          this.executeIndices = [index];
          this.showExecuteDialog(testSuiteService, false);
        } else {
          this.executeTestSuite(testSuiteService, clearTestResults, [index]);
        }
      },
      
      executeTestSuite : function(testSuiteService, clearTestResults, executeIndices, remoteTestSuiteAlias, environment) {
        iw.log("Executing test suite '" + testSuiteService +"'" + executeIndices + "; remote alias: " + remoteTestSuiteAlias +"; environment: " + environment, 3)
        //Show message popup
        iw.testsuites.message = "Executing test suite " + testSuiteService;
        
        //Results are always cleared, either partially, or completely
        var clearParams = {};
        var message = "";
        if(!clearTestResults) {
           //Get hold of the test suite name (not the service)
           clearParams["test-suite-name"] =  iw.testsuites.testSuiteData.testSuite.name;
           //Get hold of the test case names based on the given indices
           clearParams["test-case-names"] =  executeIndices.map(i => {return iw.testsuites.testSuiteData.testSuite["test-cases"][i].name});
        }

        iw.invoke("iw.test.assertion.pub:clear", clearParams, function(){})
        
        iw.testsuites.clearTestResults = false;
        message = "Results cleared\n";
        
        //Prepare execution        
        var params = {
            "index"              : executeIndices.map(i => {return ++i}).join(","), 
            "expand-assertions"  : "true",
            "skip-stubs"         : String(this.skipStubs),
            "dcc"                : String(this.dcc)
        };
        //Only set 'remote-alias' and 'environment' if they have a value other than the empty string
        if(remoteTestSuiteAlias) {
          params["remote-alias"] = remoteTestSuiteAlias;
          if(environment && environment !== "") {
            params["environment"] = environment;
          }
        }

        iw.invoke(testSuiteService, params, function(data){
           iw.log(data);
             
           iw.testsuites.showexecutediv = false;
           iw.testsuites.results        = Object.freeze(data.results);
           iw.testsuites.showresultsdiv = true;
           iw.testsuites.executeIndices = [];
           iw.testsuites.message        = "";
           iw.testsuites.isRepairMode   = false;
           iw.testsuites.skipStubs      = false;
           iw.testsuites.dcc            = false;
        }, function(message){
          
          iw.testsuites.showMessage(message, false, 3000);
          iw.testsuites.showexecutediv = false;
        });        
      },
    
      isTestCaseFailed : function(testSuiteName, testCaseName) {
        let c = 0;
        
        if(iw.testsuites.results.name === testSuiteName) {          
           c = iw.testsuites.results.testCases.reduce(function(sum, tc){
            if(tc.name.split("::")[0] === testCaseName && tc.result === false){ return ++sum } else { return sum }
          }, 0);
        }
        return c >= 1;  
      },    
      
      repairTestSuite : function(testSuiteServiceName, index) {
               
        if(typeof(index) === 'undefined') { //repair one or more test suites. Lookup the ones that failed
        
          if(iw.testsuites.testSuiteData.testSuite.name === iw.testsuites.results.name) { //this condition should always be true if this function is called.
              iw.log("Calculating the array with failed test case indices", 3);
              //There may be other test suite services with the same test suite name. Their results are registered
              //under the same name. Only consider the test cases in the result that are defined in the test cases.
              let failedIndices    = iw.testsuites.testSuiteData.testSuite["test-cases"].map(function(tc, index){  
                let isFailedAndDefinedInTestSuite = iw.testsuites.results.testCases.reduce(
                  function(sum, item){                    
                    if(item.name === tc.name && item.result === false){
                      return sum + 1;
                    } else { 
                      return sum;
                    }
                  }, 0);
                if(isFailedAndDefinedInTestSuite > 0) return index; else return -1;                
              });
              iw.log("Failed Indices: " + failedIndices, 3);
              this.executeIndices = failedIndices.filter(function(ix){return ix > -1});
          } else {
              iw.log("Setting the array with failed test case indices to the empty array", 3);
              this.executeIndices = [];
          }
        } else {
          this.executeIndices = index;
        }
              
        this.showExecuteDialog(testSuiteServiceName, true) 

      },
      
      doRepairTestSuite : function(testSuiteServiceName, executeIndices, remoteTestSuiteAlias, environment) {
        iw.log("Repairing test suite service: " + testSuiteServiceName + "; index: [" + executeIndices.join(",") + "]");
        
        //First clear the test results
        var clearParams = {
          "test-suite-name" : iw.testsuites.testSuiteData.testSuite.name          
        };
        //Clear the results of the selected test cases. 
        if(executeIndices.length > 0) {
          iw.log("[repair] Add test-case-names to clearParams. Length: " + executeIndices.length + "; first element: " + executeIndices[0], 3);
          clearParams["test-case-names"] = executeIndices.map(i => {return iw.testsuites.testSuiteData.testSuite["test-cases"][i].name});
        }
        
        iw.invoke("iw.test.assertion.pub:clear", clearParams, function(){})
        
        //Continue with repairing the test suite
        var params = {
          "repair"                   : "true",          
          "index"                    : executeIndices.map(i => {return ++i}).join(","), 
          "repair-options" : {
            "only-existing-expected"   : String(iw.testsuites.repairOptionExpected),
            "keep-regular-expressions" : String(iw.testsuites.repairOptionKeepRegexps)
          }
        };

        if(remoteTestSuiteAlias) {
          params["remote-alias"] = remoteTestSuiteAlias;
          if(environment) {
            params["environment"] = environment;
          }
        }
             
        iw.invoke(testSuiteServiceName, params, function(data) {
            iw.log("RepairTestSuite results", 3);
            
            let atLeastOneRepairFailure = false;
            let atLeastOneRepairSuccess = false;
            if(data["repair-results"] && data["repair-results"].length > 0) {
               //Format the repair result error message, if any:
               let repairResultFailureMessage     = "";
               let repairResultSuccessMessage     = "";
               
               let repairResults = data["repair-results"];
               for (let i = 0 ; i < repairResults.length ; i++) {
                  if(repairResults[i]["repair-result"] === "false") {
                     
                     if(atLeastOneRepairFailure) repairResultFailureMessage += "\n---\n"
                     repairResultFailureMessage +=  repairResults[i]["repair-message"] 
                     atLeastOneRepairFailure = true;
                  }
                  if(repairResults[i]["repair-result"] === "true") {
                     repairResultSuccessMessage += repairResults[i]["test-case-name"] + ": success"
                     if(atLeastOneRepairSuccess) repairResultSuccessMessage += "\n---\n"
                     atLeastOneRepairSuccess = true;
                  }
               }
               if(atLeastOneRepairFailure) {
                 let message = repairResultFailureMessage
                 if(atLeastOneRepairSuccess) message += "\n---\n" + repairResultSuccessMessage;
                 iw.testsuites.showMessage(message, false, 10000);
                 iw.testsuites.results        = Object.freeze(data.results);
                 iw.testsuites.showresultsdiv = true;
                 iw.testsuites.showexecutediv = false;
               }
            } 
            
            if(!atLeastOneRepairFailure){
              
              if(executeIndices.length === 0) {                                 
                iw.testsuites.executeTestSuite(testSuiteServiceName, false, [], remoteTestSuiteAlias, environment);
              } else {                
                iw.testsuites.executeTestSuite(testSuiteServiceName, false, executeIndices, remoteTestSuiteAlias, environment);
              }
            }
          },
          
          //on error
          function(message) {
            iw.testsuites.showMessage(message, false, 3000);
            iw.testsuites.showexecutediv = false;
          }
      
        );
        
      },
      
      showDeleteDialog : function(testSuiteServiceName, deleteIndices) {
        if(deleteIndices) {
           iw.testsuites.deleteIndices = deleteIndices;
        }
        iw.testsuites.lastTestSuiteService = testSuiteServiceName;
        //Retrieve test suite, if not already loaded
        if(iw.testsuites.testSuiteData.service  !== testSuiteServiceName) {
          iw.testsuites.testSuiteData.service     = testSuiteServiceName;
          iw.testsuites.getTestSuite(testSuiteServiceName, function(){
            //Only show the panel after the test suite has been loaded.
            iw.testsuites.showdeletediv = true;              
          });          
        } else {
          iw.testsuites.showdeletediv = true;                
        }
        
      },
      
      hideDeleteDialog : function() {
        iw.testsuites.deleteIndices = [];
        iw.testsuites.showdeletediv = false;
      },
      
      deleteTestSuite: function(testSuiteServiceName, deleteIndices) {
        var params = {"test-suite-service"  : testSuiteServiceName, 
                      "remove-data-on-disk" : iw.testsuites.removeDataOnDisk,
                      "index" : deleteIndices.join(",")}
                        
        iw.invoke("iw.test.ui.testsuite:remove", params, function(data) {
          
          iw.testsuites.response(data);
            
          iw.testsuites.showdeletediv = false;
          
          if(data["$is-complete-removal"] === "true") {
            iw.log("Test suite service " + testSuiteServiceName + " completely removed", 3);
            iw.testsuites.showeditdiv   = false;
            iw.testsuites.getAllTestSuites();
          } else {
            iw.log("Test cases ["+deleteIndices.map(i => {return ++i}).join(",")+"] removed from test suite service " + testSuiteServiceName, 3);
            iw.testsuites.getTestSuite(testSuiteServiceName);
          }
            
          
         }, iw.testsuites.error); 
        
         iw.testsuites.showdeletediv = false;
         iw.testsuites.deleteIndices = [];
      },
      
      deleteTestCase : function(testSuiteServiceName, index) {
        //this.hideEditDialog()
        this.showDeleteDialog(testSuiteServiceName, [index]);
      },
            
      //
      showEditDialog : function(args) {
        let testSuiteServiceName = args.testSuiteServiceName;
        let packageName          = args.packageName;
        let testCaseName         = args.testCaseName;
        iw.log("Show edit dialog called; test suite service name: " + testSuiteServiceName + "; package name: " + packageName + "; test case name: " + testCaseName, 3);
        
        iw.testsuites.lastTestSuiteService = testSuiteServiceName;        
        ///iw.testsuites.testSuiteData.packageName = packageName;
        
        //Lookup the package name of the test suite service the list of all test suites.
        let found = false;
        outer: for(let i = 0; i < iw.testsuites.suites["test-packages"].length ; i++) {
          iw.log("[lookup package] assessing package: " + iw.testsuites.suites["test-packages"][i]["package"]);
          for(let j = 0; j< iw.testsuites.suites["test-packages"][i]["test-suite-service"].length ; j++) {
            iw.log("[lookup package] assessing service: " + iw.testsuites.suites["test-packages"][i]["test-suite-service"][j].name);
            if( iw.testsuites.suites["test-packages"][i]["test-suite-service"][j].name === testSuiteServiceName) {
                iw.testsuites.testSuiteData.packageName = iw.testsuites.suites["test-packages"][i]["package"];
                iw.log("[lookup package] found: " + iw.testsuites.suites["test-packages"][i]["package"]);
                found = true;
                break outer;
            }
          }          
        }
        if(!found) {
          //If we get here, then the test suite service has not been found. Notify the user and return;
          iw.testsuites.error("Test suite service " + testSuiteServiceName + " does appear to exist");
          return;
        }
        
        iw.testsuites.listLocalPackages();
        iw.testsuites.getTestSuite(testSuiteServiceName, function(){
          iw.testsuites.showeditdiv = true;
          iw.testsuites.testCasesExpansionList =iw.testsuites.testSuiteData.testSuite["test-cases"].map(function(){return false});
          if(testCaseName) {
            let index = -1;
            for(let i =0 ; i < iw.testsuites.testSuiteData.testSuite["test-cases"].length ; i++) {
              iw.log("Considering test case " + i, 3)          
              if(iw.testsuites.testSuiteData.testSuite["test-cases"][i].name === testCaseName) {
                  iw.log("Found the test case to expand", 3)
                  index = i;
                  break;
              }
            }
            if(index >= 0) {
                iw.testsuites.toggleExpandTestCase(index);
            } else {
                iw.testsuites.toggleExpandTestCase(0);
            }
          } else {
              iw.testsuites.toggleExpandTestCase(0);
          }
          iw.testsuites.setLastEditedTestSuiteService(testSuiteServiceName);
        });
      },
      
      hideEditDialog : function() {
        iw.testsuites.showeditdiv = false;                      
        iw.testsuites.hidePipelineDialog();
        iw.testsuites.ignoreWarning = false;        
        iw.testsuites.testCasesExpansionList = [];
        iw.testsuites.testSuiteData.testSuite = {};
      },
      
      showDuplicateTestCaseDialog : function(testSuiteServiceName, testCase) {
        //Initialize parameters
        iw.testsuites.duplicateTestCaseData.testSuiteServiceName = testSuiteServiceName;
        iw.testsuites.duplicateTestCaseData.originalTestCaseName = testCase.name;
        iw.testsuites.duplicateTestCaseData.service              = testCase.service;
        iw.testsuites.duplicateTestCaseData.originalStubs        = testCase.stubs !== undefined ? testCase.stubs.map(function(stub){return stub['service-to-stub']}) : [];        
        iw.testsuites.duplicateTestCaseData.newTestCaseName      = testCase.name + " (duplicate)";
        iw.testsuites.duplicateTestCaseData.copyAssertions       = testCase.expected.assertions && testCase.expected.assertions.length > 0
        iw.testsuites.duplicateTestCaseData.copyCallbacks        = testCase.callbacks && testCase.callbacks.length > 0;
        iw.testsuites.duplicateTestCaseData.tmpInputFile         = "tmp-"+Date.now().toString() + ".xml"
        
        if(testCase.input && testCase.input["file-name"]) {
          //There is an input file (normally the case)
          //Copy the input of this testCase to $base-dir/
        
          let params = {"base-dir": iw.testsuites.testSuiteData.baseDir, "source-file-name" : testCase.input["file-name"], "target-file-name" : iw.testsuites.duplicateTestCaseData.tmpInputFile};
        
          iw.invoke("iw.test.util.file:copy", params, function(data){
        
            iw.testsuites.showduplicatetestcasediv = true;
        
          },iw.testsuites.error);
        
        } else {
          //There is no input file, so generate an empty one
             let params = {"$document": {}, "$path" : this.duplicateTestCaseData.tmpInputFile, "$baseDir": this.testSuiteData.baseDir, "overwrite" : false}
             iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
                 iw.log("Setup input file created? " + data["$success"], 3);
                 iw.testsuites.showduplicatetestcasediv = true;
              }, iw.testsuites.error);              
        }
        
        
      },
      
      addExtraStubbedService : function(service) {
        
        iw.testsuites.duplicateTestCaseData.extraStubbedServices.push(service);
      },
      
      removeExtraStubbedService : function(idx) {
        iw.testsuites.duplicateTestCaseData.extraStubbedServices.splice(idx, 1);        
      },
      resetDuplicateTestCaseData : function() {        
        let params = {"base-dir" : iw.testsuites.testSuiteData.baseDir, "file-name" : iw.testsuites.duplicateTestCaseData.tmpInputFile}
        iw.invoke("iw.test.util.file:remove", params, function(data){}, iw.testsuites.error);
        iw.testsuites.duplicateTestCaseData.remoteTestSuiteAlias = "";
        iw.testsuites.duplicateTestCaseData.testSuiteServiceName = "";
        iw.testsuites.duplicateTestCaseData.originalTestCaseName = "";
        iw.testsuites.duplicateTestCaseData.newTestCaseName      = "";
        iw.testsuites.duplicateTestCaseData.originalStubs        = [];        
        iw.testsuites.duplicateTestCaseData.originalTestCaseName = "";
        iw.testsuites.duplicateTestCaseData.extraStubbedServices = [];
        iw.testsuites.duplicateTestCaseData.copyAssertions       = true;
        iw.testsuites.duplicateTestCaseData.copyCallbacks        = true;
        iw.testsuites.duplicateTestCaseData.tmpInputFile         = "";
      },
      
      duplicateTestCase : function() {     
        let params = {         
          "test-suite-service-name" : iw.testsuites.duplicateTestCaseData.testSuiteServiceName,
          "original-test-case-name" : iw.testsuites.duplicateTestCaseData.originalTestCaseName,
          "new-test-case-name"      : iw.testsuites.duplicateTestCaseData.newTestCaseName,          
          "action"                  : "duplicate",
          "extra-stubbed-services"  : iw.testsuites.duplicateTestCaseData.extraStubbedServices,
          "copy-callbacks"          : iw.testsuites.duplicateTestCaseData.copyCallbacks,
          "copy-inline-assertions"  : iw.testsuites.duplicateTestCaseData.copyAssertions,          
          "alternative-input-file"  : iw.testsuites.duplicateTestCaseData.tmpInputFile
        }
        if(iw.testsuites.duplicateTestCaseData.remoteTestSuiteAlias) {
          params["remote-alias"] = iw.testsuites.duplicateTestCaseData.remoteTestSuiteAlias;
        }
          
        iw.invoke("iw.test.generate.pub:duplicateTestCase", params, function(data){        
            iw.testsuites.response(data);
            iw.testsuites.getTestSuite(iw.testsuites.testSuiteData.service);
            iw.testsuites.resetDuplicateTestCaseData();
        },
          iw.testsuites.error);      

        iw.testsuites.showduplicatetestcasediv = false;           
      },
      
      hideDuplicateTestCaseDialog : function() {
        iw.testsuites.resetDuplicateTestCaseData();
        iw.testsuites.showduplicatetestcasediv = false;      
      },
      
      assignInputFileName : function(tc, fileName) {
        if(!tc.input) tc.input = {};
        tc.input['file-name'] = fileName; 
      },
      
      assignExpectedFileName : function(tc, fileName) {
        if(!tc.expected) tc.expected = {};
        tc.expected['file-name'] = fileName; 
      },      
      
      toggleExpandPackage : function(name) {
        iw.log("Toggle visibility package ["+name+"]", 3);
        //Vue.set(iw.testsuites.packagesExpansionList, name, !iw.testsuites.packagesExpansionList[name]);
        iw.testsuites.packagesExpansionList[name] = !iw.testsuites.packagesExpansionList[name];
      },
      
      toggleExpandTestCase : function(index) {
        iw.log("Toggle visibility testcase ["+index+"]", 3);
        //Vue.set(iw.testsuites.testCasesExpansionList, index, !iw.testsuites.testCasesExpansionList[index]);
        iw.testsuites.testCasesExpansionList[index] = !iw.testsuites.testCasesExpansionList[index];
      },
      
      showResultsModal : function() {
        iw.testsuites.showresultsdiv = true;  
      },
      
      hideResultsModal : function() {
        iw.testsuites.showresultsdiv = false;      
        iw.testsuites.getTestSuiteResults();
      },      
      
      saveTestSuite : function() {
        iw.log("About to save test suite", 3);
        //TODO: Call service to remove files superfluous callback files.
        var params   = {"test-suite-service": iw.testsuites.testSuiteData.service, 
                        "test-suite"        : iw.testsuites.testSuiteData.testSuite,
                        "base-dir"          : iw.testsuites.testSuiteData.configuredBaseDir}
        iw.log("Just before saving the whole test suite", 3);
        iw.log(iw.testsuites.testSuiteData.testSuite, 3);
        iw.invoke("iw.test.ui.testsuite:save", params, function(data){        
            iw.testsuites.response(data);
            },
          iw.testsuites.error);
      },
      
      toggleDisableTestSuite : function(tc) {
        //Make sure that only the value 'true' gets saved
         if(tc.disabled !== true) {
           delete(tc.disabled);           
         }
         iw.testsuites.saveTestSuite();
      },
      
      saveTestSuiteAndClose: function() {
        iw.testsuites.saveTestSuite();
        iw.testsuites.hideEditDialog();        
      },
      
      showPipelineDialog : function(baseDir, path, service, output, error) {
        iw.testsuites.getPipeline(baseDir, path, service, output, error);
      },
      
      hidePipelineDialog : function() {
        iw.testsuites.showpipelinediv = false;
        if(iw.xmleditor) iw.xmleditor.getSession().setValue("" , 1);
        if(iw.peditor)   iw.peditor.set({})
      },
      
      showJSONEditor : function() {
        iw.log("showJSONEditor called", 3);
        iw.testsuites.showraweditor = false;
      },
      
      showXMLEditor : function() {
        iw.log("showXMLEditor called", 3);
        iw.testsuites.showraweditor = true;
      },
  
      setPipelinePopup : function(data) {
            iw.log("Setting pipeline popup..", 3);
            this.pipelinePopup = data;
      },

      getPipeline : function(baseDir, path, service, output, error) {
        iw.testsuites.pipeline.path    = path;
        iw.testsuites.pipeline.service = service;
        iw.testsuites.pipeline.output  = output;
        iw.testsuites.pipeline.error   = error;
        
        iw.log("[getPipeline] baseDir: " +  iw.testsuites.testSuiteData.baseDir + "; path: " +  iw.testsuites.pipeline.path + "; service: " +  iw.testsuites.pipeline.service + "; output: " +  iw.testsuites.pipeline.output + "; error: " +  iw.testsuites.pipeline.error, 3);
        
        var params = {"$path"       : path, 
                      "$baseDir"    : baseDir, 
                      "$package"    : iw.testsuites.testSuiteData.packageName,
                      "$include-raw": "true"}

        iw.invoke("iw.test.util.pub:restorePipelineFromFile", params, function(data) {
          //iw.testsuites.pipeline.data = JSON.stringify(data['$document'])
          iw.testsuites.pipeline.isproblematic = ("true" === data['$problematic']);
          
          if(iw.peditor === undefined) {
            var container = document.getElementById("pipelineeditor");
            var options = { modes:["tree","code","text"],
                            enableTransform: false,
                            onChange: function() {iw.log("JSON changed",3); iw.testsuites.isdirtypipeline = true; iw.testsuites.isdirtyjsonpipeline = true},
                            onClassName: function(c) {
                              //iw.log("on-class-name: " + c.path + " " + c.field + " " + c.value, 3)
                            }
                          }

             iw.peditor = new JSONEditor(container, options);
          }
          if(iw.xmleditor === undefined) {
             iw.xmleditor = JSONEditor.ace.edit("xmleditor");
             iw.xmleditor.getSession().setMode("ace/mode/xml");
             iw.xmleditor.on("change", function() {iw.log("XML changed",3); iw.testsuites.isdirtypipeline = true; iw.testsuites.isdirtyxmlpipeline = true});
          }

          //Raw data 
          //iw.testsuites.pipeline.raw = data['$raw'];
          iw.xmleditor.getSession().setValue( data['$raw'] , 1);

          //JSON
          iw.peditor.set(data['$document'])
          iw.peditor.setName("pipeline");
         
          iw.testsuites.getPipelineSchema(false)
          //This seems to be problematic. Sometimes 'expandAll() does not exist
          //iw.peditor.expandAll();
          
          //Reset isdirtypipeline, so the save button becomes disabled
          iw.testsuites.isdirtypipeline     = false;
          iw.testsuites.isdirtyjsonpipeline = false;
          iw.testsuites.isdirtyxmlpipeline  = false;

          //Explicitly show the XML editor if there are data types present that are not
          //supported by JSON
          if( iw.testsuites.pipeline.isproblematic) {
            iw.testsuites.showXMLEditor();
          }

          //iw.testsuites.showraweditor = iw.testsuites.pipeline.isproblematic;
          iw.testsuites.showpipelinediv = true;

        }, function(msg){
            iw.testsuites.hidePipelineDialog();
            iw.testsuites.error(msg)
          })
      },

      togglePipelineValidation : function() {
        if(this.pipeline.validate) {
          iw.peditor.setSchema(this.pipeline.schema);
        } else {
          iw.peditor.setSchema(null);
        }
      },

      getPipelineSchema : function(generateData) {
          if(this.pipeline.path && this.pipeline.path.indexOf("test-error.xml") >= 0) {
            
          }
          let self = this;
          if(this.pipeline.service !== null) {
             let params = { 'nodeName'                     : this.pipeline.service,
                            'no-sample-data'               : !generateData,
                            'generate-minimal'             : this.pipeline.generateMinimal, 
                            'generate-only-structure'      : this.pipeline.generateOnlyStructure,
                            'generate-nr-of-array-elements': this.pipeline.generateNumberOfArrayElements} 

              if(iw.testsuites.pipeline.error) {
                  params.nodeName               = "iw.test.doc:exception";
                  iw.testsuites.pipeline.output = false;
              }
              iw.invoke("iw.test.ui.schema:get", params, function(data){
                if(data["$success"] === "true") {                
                  if(iw.testsuites.pipeline.output) { 
                    self.pipeline.schema        = data['output-schema']
                    self.pipeline.sampleData    = data['sample-output-data']
                    self.pipeline.sampleDataXML = data['sample-output-xml']
                  } else { 
                    self.pipeline.schema        = data['input-schema']
                    self.pipeline.sampleData    = data['sample-input-data']
                    self.pipeline.sampleDataXML = data['sample-input-xml']
                  }
                  if(iw.testsuites.pipeline.validate === true) {
                    iw.peditor.setSchema(self.pipeline.schema);
                  }
                  if(generateData) {
                    //Only update the data of the active editor.
                    if(iw.testsuites.showraweditor) {
                      iw.xmleditor.getSession().setValue(self.pipeline.sampleDataXML, 1);
                    } else {
                      iw.peditor.update(self.pipeline.sampleData);
                      iw.log("JSON panel updated with sample data",3); 
                      //For some reason, this does not trigger the 'onChange' event, so the flags are updated here.
                      iw.testsuites.isdirtypipeline = true; 
                      iw.testsuites.isdirtyjsonpipeline = true
                    }
                  }
                } else {
                  iw.staticstubs.response(data);
                }

              }, iw.testsuites.error)
          }
     },
      
      savePipeline : function(closeDialog) {
        var params = {"$path"    : iw.testsuites.pipeline.path, 
                      "$baseDir" : iw.testsuites.testSuiteData.baseDir,
                      "$package" : iw.testsuites.testSuiteData.packageName}
                      
        if(iw.testsuites.showraweditor) {
          params["$raw"] = iw.xmleditor.getValue();
        } else {
          params["$document"] = iw.peditor.get();
        }
        
        iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
          iw.testsuites.showMessage(data["$message"], data["$success"] === "true" , 2500);          
          if(closeDialog) {
            iw.testsuites.hidePipelineDialog();        
          } else {
            iw.testsuites.getPipeline(iw.testsuites.testSuiteData.baseDir, iw.testsuites.pipeline.path,  iw.testsuites.pipeline.service);       
          }
          
        }, iw.testsuites.error)
        
      },
      
      addAssertion: function(testCase) {
        iw.log("Adding new assertion to test case " + testCase.name, 3)
        if(!testCase.expected) {
          iw.log("Adding new 'expected' section to test case "+ testCase.name , 3);
          //Vue.set(testCase, 'expected', {});
          testCase['expected'] = {};
        }
        if(testCase.expected.assertions === undefined) {
          iw.log("Adding new 'assertion' array section to test case "+ testCase.name , 3);
          //Vue.set(testCase.expected, "assertions", []);
          testCase.expected.assertions = [];
          
        }
        
        testCase.expected.assertions.push({"path": null, "check": "equals", "value": null, key: Date.now(), "foo": true});
        //testCase.expected.assertions.push({"path": null, "check": "equals", "value": null});
      },
      
      removeAssertion: function(expected, index) {
        expected.assertions.splice(index, 1);
        if(expected.assertions.length === 0 ) {
          iw.log("Last assertion removed: removing assertion structure", 3)
          delete(expected.assertions);
        }
      },
      
      addStub : function(testCase) {
        iw.log("Add stub called",3);
        if(testCase.stubs === undefined) {
          //Vue.set(testCase, "stubs", []);
          testCase.stubs = [];
        }
        testCase.stubs.push({"service-to-stub":"", scope: "session", key: Date.now(), "foo" : "bar"});
      },
      
      removeStub : function(tc, index) {
        iw.log("Deleting stub["+index+"]; base-dir: " + iw.testsuites.testSuiteData.baseDir, 3);
        iw.log(tc.stubs[index], 3);       
        tc.stubs.splice(index, 1);
        if(tc.stubs.length === 0 ) delete(tc.stubs)
      },      
      
      setStubFromComponent : function(stubs, stix, $event) {
        //console.log($event);
        stubs[stix] = $event;
        iw.log("After assignment of stub to position in stubs array:" + stix);
        iw.log(iw.testsuites.testSuiteData.testSuite, 4);
        iw.testsuites.saveTestSuite();
        //trigger rerendering
        stubs[stix].key++;
      },
      
      rerenderStub : function (stub) {
        stub.key++;
      },
      
      addCallback : function(testCase) {
        iw.log("Add callback called", 3);
        if(testCase.callbacks === undefined) {
          //Vue.set(testCase, "callbacks", []);
          testCase.callbacks = [];
        }     
        testCase.callbacks.push({service: "", event: "start", expected: {"file-name": "", lax: "true" }, key: Date.now(), "foo" : "bar"});
      },
      
      removeCallback : function(tc, index, testCaseDir) {
        tc.callbacks.splice(index, 1);
        
        if(tc.callbacks.length === 0 ) { //remove the 'callbacks' directory
          delete(tc.callbacks);
          let params = {"file-name": testCaseDir + "/callbacks", "base-dir" : iw.testsuites.testSuiteData.baseDir, "recursive": true};
             iw.invoke("iw.test.util.file:remove", params, function(data){
                  iw.log("Callbacks dir removed? " + JSON.stringify(params) + ": "+ data["$success"]);
             }, iw.testsuites.error);
        }
      },
      
      setCallbackFromComponent : function(callbacks, cbix, $event) {
        iw.log("Receiving callback data from component:");
        iw.log($event);
        callbacks[cbix] = $event;
        iw.log("After assignment of callback to position in stubs array: " + cbix);
        iw.log(iw.testsuites.testSuiteData.testSuite, 3);
        iw.testsuites.saveTestSuite();
      },      
      
      setCallbackService($event, cb) {
        iw.log("Set callback service called. Service: " +$event,3);
      },
      
      assignSetupService : function(service) {
        if(!service || service ==='') {
          this.removeSetupService();
        } else {      
          if(iw.testsuites.testSuiteData.testSuite.setup === undefined) {
             let inputFileName = "setup-input.xml";
             //Vue.set(iw.testsuites.testSuiteData.testSuite, 'setup', {service: service});
             iw.testsuites.testSuiteData.testSuite.setup = {service: service}
             
             //Create an empty input file for the setup service
             let params = {"$document": {}, "$path" : inputFileName, "$baseDir": this.testSuiteData.baseDir, "overwrite" : false}
             iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
                 iw.log("Setup input file created? " + data["$success"], 3);
              }, iw.testsuites.error);    
             
          } else {
             iw.testsuites.testSuiteData.testSuite.setup.service = service
          }        
        }
      },
      
      assignSetupInputFile : function(fileName) {
        if(iw.testsuites.testSuiteData.testSuite.setup !== undefined) {
           //Vue.set(iw.testsuites.testSuiteData.testSuite.setup, 'file-name', fileName);
           iw.testsuites.testSuiteData.testSuite.setup['file-name'] = fileName;
        }        
      },
      
      assignTeardownService : function(service) {
        if(!service || service ==='') {
          this.removeTeardownService();
        } else {
          if(iw.testsuites.testSuiteData.testSuite.teardown === undefined) {
             let inputFileName = "teardown-input.xml";
             //Vue.set(iw.testsuites.testSuiteData.testSuite, 'teardown', {service: service});
             iw.testsuites.testSuiteData.testSuite.teardown = {service: service};
             
             //Create an empty input file for the teardown service
             let params = {"$document": {}, "$path" : inputFileName, "$baseDir": this.testSuiteData.baseDir, "overwrite" : false}
             iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
                 iw.log("Teardown input file created? " + data["$success"], 3);
              }, iw.testsuites.error);      
              
          } else {
             iw.testsuites.testSuiteData.testSuite.teardown.service = service
          }       
        }
      },
      
      assignTeardownInputFile : function(fileName) {
        if(iw.testsuites.testSuiteData.testSuite.teardown !== undefined) {
           //Vue.set(iw.testsuites.testSuiteData.testSuite.teardown, 'file-name', fileName);
           iw.testsuites.testSuiteData.testSuite.teardown['file-name'] = fileName;
        }        
      },
      
      showExecuteServiceDialog : function (service, baseDir, fileName, type) {
      
        if(this.config["ui.distributed.enabled"]) {
          this.executeServiceData.service   = service;
          this.executeServiceData.baseDir   = baseDir;
          this.executeServiceData.fileName  = fileName,
          this.executeServiceData.type      = type;
          this.showexecutesetupteardowndiv = true;
        } else {
          this.executeService(service, baseDir, fileName, type)  
        }
      
      },
      
      hideExecuteServiceDialog : function () {
        this.showexecutesetupteardowndiv = false;      
      },
      
      executeService : function(service, baseDir, fileName, type, alias) {
      
        //type = [setup|teardown]
        let params = { "service": service, "base-dir": baseDir, "file-name": fileName, type: type}
        if(alias) params["remote-alias"] = alias;

        iw.invoke("iw.test.execution.service:executeSetupOrTeardown", params, function(data){
          //show results
          iw.testsuites.pipelinePopup = data.pipeline;
          iw.testsuites.showexecutesetupteardowndiv = false;
        }
        //standard error handler
        , iw.testsuites.error
      )},
      
      removeSetupService : function() {
        iw.log('Remove Setup called', 3);
        iw.testsuites.testSuiteData.testSuite.setup.service = null;
        delete(iw.testsuites.testSuiteData.testSuite.setup);
      },
      
      removeTeardownService: function() {
        iw.log('Remove teardown called', 3)
        iw.testsuites.testSuiteData.testSuite.teardown.service = null;
        delete(iw.testsuites.testSuiteData.testSuite.teardown);
      },
      
      composeCallbackFileName : function (testCaseDir, service, event) {
        return testCaseDir + "/callbacks/" +  service.replace(":",".") + "-" +event + ".xml"
      },

      listLocalPackages : function() {
		   var params = {};
		   iw.invoke("iw.test.ui.ns:listPackages", params, function(data) {
		      iw.log("Retrieved local packages", 3);

            iw.testsuites.localPackages = data.packages.filter(function(a){                 
                 var result = a["system-package"] !== "true" && a.enabled === "true";                 
                 return result;
            }).sort(function(a,b){ if(a.name >= b.name) return 1; else return -1});
            
                
         }, iw.testsuites.error);
		  },
      
      addItemHandler : function(item) {
        iw.log("Add item handler called", 3);
      }
      
    }
   
  });  
  
  iw.testsuitesApp.component("iwtree-item", {
     template: "#iwtree-item-template",
     props: {
        item                        : Object,
        packageName                 : String,
        selectedTestSuiteServiceName: String
     },
     data: function() {
       return {
         isOpen : true
       }
     },
     computed: {
       hasChildren : function() {
         return this.item.items;
       },
       shortName : function() {
         return this.item.name.split(":")[1];
       }
     },
     methods: {
      toggle: function () {
        this.isOpen = !this.isOpen
      },
      
     }
   
   });
  
  iw.testsuitesApp.component('edit-assertion', {
  
    template : "#edit-assertion-template",
    
    props: ['initialPath', 'initialCheck', 'initialValue', 'possibleChecks', 'initialFoo'],
    
    data : function() {
      iw.log("[edit-assertion] props: initialPath:" + this.initialPath + "; initialCheck: " + this.initialCheck + "; initialValue: " + this.initialValue + "; new: " + this.initialFoo, 3)
      return {
        path:        this.initialPath,
        check:       this.initialCheck,
        value:       this.initialValue,
        editing:     this.initialFoo,
        isDirty:     false
      }
    },
    
    methods : {
    
      assertionChanged : function() {
        
        //iw.log("Assertion changed; path: " + path + "; check: " + check + "; value: " + value);
        
        this.$emit('assertion-changed', {"path": this.path, "check": this.check, "value" : this.value});
        this.isDirty = false;
      },
      
      assertionUnchanged : function() {    
        if(this.initialFoo) {
            this.$emit('assertion-removed')
        }
        else {
          this.path    = this.initialPath;
          this.check   = this.initialCheck;
          this.value   = this.initialValue;
          this.isDirty = false;
        }        
      },
      
      assertionRemoved : function() {
        if(this.initialFoo)
          this.$emit('assertion-removed') 
        else
          this.$emit('assertion-removed-save');
      },
           
    }  
  });
   
  iw.testsuitesApp.component('edit-stub',{
  
    template : "#edit-stub-template",
      
    props : ['initialStub', 'localPackages', 'aliases', 'baseDir', 'testCaseDir', 'testSuiteName', 'testCaseName', 'stix', 'packageName', 'distributedEnabled'],
    
    emits : ['show-pipeline-editor', 'remove-stub', 'remove-stub-save', 'save-stub', 'reset-stub'],
    
    data : function() {
      iw.log("Initializing 'edit-stub'-component. testCaseDir: " + this.testCaseDir, 3);
        return {
          //make an independent copy of initialStub, so we can easily revert
          stub             : JSON.parse(JSON.stringify(this.initialStub)),
          stubTypes        : ['pipeline','service', 'exception','dynamic'],
          scopeTypes       : ['session','user','server'],
          initialStubType  : this.initialStub.pipeline ? 'pipeline' : (this.initialStub.service ? 'service' : (this.initialStub.exception ? 'exception' : (this.initialStub.dynamic ? 'dynamic' : null))),
          stubType         : this.initialStub.pipeline ? 'pipeline' : (this.initialStub.service ? 'service' : (this.initialStub.exception ? 'exception' : (this.initialStub.dynamic ? 'dynamic' : null))),
          isDirty          : false,
          confirm                   : {
            question                : null,
            showconfirmationdialog  : false,
            confirmAction           : function(){}
          }          
      }
    },
    
    computed : {
       stubBaseDir : function() {
          return this.baseDir + "/" + this.testCaseDir + "/stub-" + this.stub['service-to-stub'].replace(":","."); 
       }
    },
    
    methods: {
    
      handleStubTypeChange : function(stubType) {
        iw.log("Stub type change detected. old type: " + this.stubType + "; new type: " + stubType);
        if(stubType === 'pipeline') {
          
          if(!this.stub.pipeline) { //Create new pipeline config
            this.createPipelineStubFile();
            
          }
        }
        if(stubType === 'service') {
          //empty service, no input-file
          if(!this.stub.service) { 
            this.stub.service = {name:"",'input-file':""};   
            this.createServiceInputFile();
          }
        }
        if(stubType === 'exception') {
          if(!this.stub.exception) this.stub.exception = {"class" : "", message : ""};
        }
        
        if(stubType === 'dynamic') {
          if(!this.stub.dynamic) {
            this.createDynamicStubFiles();
            
          }
        }
        
        this.stubType = stubType;
        this.isDirty = true;
       },
      
      handleServiceToStubChange : function(newServiceName) {
        let oldServiceName = this.stub['service-to-stub'];
				this.stub['service-to-stub'] = newServiceName;
        this.isDirty = true;
				if(oldServiceName === "" || oldServiceName === null) {
					iw.log("Handle Service To Stub change. Old name null or empty, nothing to do",3);					
				} else {
					iw.log("Handle Service To Stub change. Old name: " + oldServiceName + "; new name: " + newServiceName, 3)
					
					let self = this;
					//try to rename the stub directory
					let params = {  "base-dir"          : this.baseDir + "/" + this.testCaseDir, 
													"existing-file-name": "stub-" + this.stub['service-to-stub'].replace(":","."),
													"new-file-name"     : "stub-" + newServiceName.replace(":",".")
													};
					iw.log("Params for stub directory change: " + JSON.stringify(params), 3);
					iw.invoke("iw.test.util.file:rename", params, function(data){
							if(data["$success"] === "true") {  
								//the change the paths in the stub accordingly
								self.changePathNames(oldServiceName, newServiceName);
							} else {
								iw.log("Could not rename directory of stub service "+ newServiceName );
							
							}
					}, iw.testsuites.error);       
				}
   
      },
         
      createPipelineStubFile : function () {
        if(this.stub['service-to-stub'] !== "") {
                      
          this.stub.pipeline = {"file-name" :  this.testCaseDir + "/stub-" + this.stub['service-to-stub'].replace(":",".") + "/pipeline.xml"};

          iw.log("Creating pipeline file " + this.baseDir + "/" + this.testCaseDir + "/" + this.stub.pipeline["file-name"]);

          let params = {"$document": {}, "$path" : this.stub.pipeline["file-name"], "$baseDir": this.baseDir}

          iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
                 iw.log("Pipeline file created? " + data["$success"], 3);
              }, iw.testsuites.error);
        } else {
          iw.log("Could not create pipeline file: 'service-to-stub' is empty");
        }
      },
         
      createServiceInputFile : function() {
        if(this.stub['service-to-stub'] !== "") {
        
          this.stub.service = {"input-file" :  this.testCaseDir + "/stub-" + this.stub['service-to-stub'].replace(":",".") + "/substitute-input.xml"};

          iw.log("Creating service input file " + this.baseDir + "/" + this.testCaseDir + "/" + this.stub.service["input-file"]);

          let params = {"$document": {}, "$path" :  this.stub.service["input-file"], "$baseDir": this.baseDir}

          iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Service input file created? " + data["$success"], 3);
          }, iw.testsuites.error   );
        } else {
          iw.log("Could not create service input-file: 'service-to-stub' is empty");
        }         
      },
         
      createDynamicStubFiles : function() {
        if(this.stub['service-to-stub'] !== "") {
                    
            this.stub.dynamic = {"stub-base-dir" :  this.testCaseDir + "/stub-" + this.stub['service-to-stub'].replace(":",".")};

            let firstDynamicInputFile  = this.stub.dynamic['stub-base-dir'] + "/00001/test-input.xml"
            let firstDynamicOutputFile = this.stub.dynamic['stub-base-dir'] + "/00001/test-output.xml"
            this.stub.dynamic["00001"] = {"input" : firstDynamicInputFile, "output": firstDynamicOutputFile};

            iw.log("Creating dynamic file " + this.baseDir + "/" + firstDynamicInputFile);

            let params = {"$document": {}, "$path" : firstDynamicInputFile, "$baseDir": this.baseDir };

            iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Dynamic stub input file created? " + data["$success"]);
            }, iw.testsuites.error   );

            iw.log("Creating dynamic file " + this.baseDir + "/" + firstDynamicOutputFile);
            
            params = {"$document": {}, "$path" : firstDynamicOutputFile, "$baseDir": this.baseDir};
            
            iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              iw.log("Dynamic stub output file created? " + data["$success"]);
            }, iw.testsuites.error   );
        } else {
          iw.log("Could not create dynamic stub file: 'service-to-stub' is empty");
        }         
      },

      changeDynamicStubEntryFolder : function(baseDir, oldFolderName, newFolderName, stub ) {
        iw.log("Changing file name; baseDir: " + baseDir + "; old file name: " + oldFolderName + "; new file name: " + newFolderName, 3);
        let params = {"base-dir": baseDir, "existing-file-name": oldFolderName, "new-file-name": newFolderName}
        let self = this;
        //console.log(stub);
        let dynamicStubEntry = stub.dynamic[oldFolderName];
        iw.invoke("iw.test.util.file:rename", params, function(data){
            iw.log("Dynamic stub folder name changed? " +data["$success"], 3);
            //console.log(stub);
            if(data["$success"] === "true") {
              if(dynamicStubEntry.input) {
                dynamicStubEntry.input = self.changeStubEntryPath(dynamicStubEntry.input, newFolderName);
              }
              if(dynamicStubEntry.output) {
                dynamicStubEntry.output = self.changeStubEntryPath(dynamicStubEntry.output, newFolderName);
              }
              if(dynamicStubEntry.error) {
                dynamicStubEntry.error = self.changeStubEntryPath(dynamicStubEntry.error, newFolderName);
              }
              delete(stub.dynamic[oldFolderName]);
              //Vue.set(stub.dynamic, newFolderName, dynamicStubEntry);
              stub.dynamic[newFolderName] = dynamicStubEntry;
              stub.dynamic = self.sortObject(stub.dynamic);
              self.saveStub();
            } else {
              //rerender stub
              self.saveStub();
              iw.testsuites.error("Could not change stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
            }
          }, iw.testsuites.error);
        return newFolderName;
      },

      //This method changes the third folder in a four-folder path. Path names of stub entries look like this:
      //
      // 00014/stub-iwtesttest.interface.service/00001/test-input.xml ->  00014/stub-iwtesttest.interface.service/foo/test-input.xml  
      changeStubEntryPath : function(path, newFolderName) {
        let a = path.split('/');
        a[2] = newFolderName;
        return a.join('/');
      },

      sortObject : function(unordered) {
        const ordered = {};
        Object.keys(unordered).sort().forEach(function(key){ordered[key] = unordered[key]});
        return ordered;
      },

      duplicateStubEntryFolder : function(baseDir, oldFolderName, stub) {
        let newFolderName = oldFolderName + "-duplicate";
        //Calculate the next folder name, if this folder name is numeric
        if(oldFolderName.match("^\\d+$")) {
           let b = Number(oldFolderName);
           let i = 0;
           while(true) {
             b++;
             newFolderName = String(b).padStart(oldFolderName.length, "0");
             iw.log("[duplicate] new folder name ("+i+"): " + newFolderName, 3);
             if(!stub.dynamic[newFolderName]) {
               break;
             }
             i++;
           }
        } 
        
        iw.log("Duplication stub entry;  baseDir: " + baseDir + "; old file name: " + oldFolderName + "; new file name: " + newFolderName, 3);
        let params = {"base-dir": baseDir, "source-file-name": oldFolderName, "target-file-name": newFolderName}
        let self = this;
        
        iw.invoke("iw.test.util.file:copy", params, function(data){
          iw.log("Copy successful? " +data["$success"], 3);
          if(data["$success"] === "true") {
            let dynamicStubEntry = stub.dynamic[oldFolderName];
            let newDynamicStubEntry = {};
            if(dynamicStubEntry.input) {
              newDynamicStubEntry.input = self.changeStubEntryPath(dynamicStubEntry.input, newFolderName); 
            }
            if(dynamicStubEntry.output) {
              newDynamicStubEntry.output = self.changeStubEntryPath(dynamicStubEntry.output, newFolderName);
            }
            if(dynamicStubEntry.error) {
              newDynamicStubEntry.error = self.changeStubEntryPath(dynamicStubEntry.error, newFolderName);
            }
            //Vue.set(stub.dynamic, newFolderName, newDynamicStubEntry);
            stub.dynamic[newFolderName] = newDynamicStubEntry;

            stub.dynamic = self.sortObject(stub.dynamic);

            self.saveStub();
          } else {
              iw.testsuites.error("Could duplicate stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
          }
 
        }, iw.testsuites.error);

      },

      deleteStubEntryFolder : function(baseDir, folderName, stub) {
        
        iw.log("Deleting stub entry;  baseDir: " + baseDir + "; folder name: " + folderName);
        let params = {"base-dir": baseDir, "file-name": folderName, "recursive": "true"};
        let self = this;
        
        iw.invoke("iw.test.util.file:remove", params, function(data){
          iw.log("Delete successful? " +data["$success"], 3);
         
          if(data["$success"] === "true") {
            delete(stub.dynamic[folderName]);
            //console.log(stub);
            self.saveStub();
          } else {
              iw.testsuites.error("Could delete stub entry '" + folderName );
          }

        }, iw.testsuites.error);

      },

      changeStubEntryResult : function(baseDir, name, path, stub) {
        iw.log("Changing stub entry result. baseDir: " + baseDir + "; name: " + name + "; path: " + path + "; stub: " + JSON.stringify(stub));
        //console.log(stub);
        let dynamicStubEntry = stub.dynamic[name];
        let oldFileName = path;
        let newFileName = "";
        if(dynamicStubEntry.output) {
          newFileName = oldFileName.replace('test-output.xml', 'test-error.xml'); 
        } else if (dynamicStubEntry.error) {
          newFileName = oldFileName.replace('test-error.xml', 'test-output.xml'); 
        } else {
          iw.warn("Cannot change stub entry result, because file is not 'test-output.xml' nor 'test-error.xml'", 2);
        }
        iw.log("Changing stub entry; baseDir: " + baseDir + "; old file name: " + oldFileName + "; new file name: " + newFileName, 3);
        let params = {"base-dir": baseDir, "existing-file-name": oldFileName, "new-file-name": newFileName}
        let self = this;
        //console.log(stub);
        iw.invoke("iw.test.util.file:rename", params, function(data){
            iw.log("Dynamic stub folder name changed? " +data["$success"], 3);
            //console.log(stub);
            if(data["$success"] === "true") {
              if(dynamicStubEntry.output) {
                //Vue.set(stub.dynamic[name], "error", newFileName);
                stub.dynamic[name].error = newFileName;
                delete(stub.dynamic[name].output);
              } else {
                //Vue.set(stub.dynamic[name], "output", newFileName);
                stub.dynamic[name].output = newFileName;
                delete(stub.dynamic[name].error);
              }
              self.saveStub();
            } else {
              //rerender stub
              self.saveStub();
              iw.testsuites.error("Could not change stub entry folder from '" + oldFolderName + "' to '" + newFolderName);
            }
          }, iw.testsuites.error);

      },

      changePathName : function(oldServiceName, newServiceName) {
        //pipeline['file-name']
        //service['input-file]
        //dynamic['stub-base-dir']
        if(this.stub.pipeline) {
          this.stub.pipeline['file-name'] = this.stub.pipeline['file-name'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Updated stub pipeline file name. New file name: " + this.stub.pipeline['file-name'], 3 );
        }
        if(this.stub.service && this.stub.service['input-file']) {
          this.service['input-file'] = this.service['input-file'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Updated stub service input file name. New file name: " +  this.service['input-file'], 3 );
        }
        if(this.stub.dynamic && this.stub.dynamic['stub-base-dir']) {
          this.stub.dynamic['stub-base-dir'] = this.stub.dynamic['stub-base-dir'].replace(oldServiceName.replace(":","."), newServiceName.replace(":", "."));
          iw.log("Update stub dynamic stub directory: new directory: " + this.stub.dynamic['stub-base-dir'] , 3);
        }
      },
         
      showPipelineDialog : function (baseDir, fileName, service, output, error) {
        iw.log("[stub] show pipeline dialog; output: " + output + "; error: " + error, 3);
        this.$emit('show-pipeline-editor', {"baseDir": baseDir, "fileName": fileName, "service" : service, "output": output, "error": error});
      },  
             
      removeStub : function(stix, service) {
        this.confirm.question = "Are you sure you want to delete stub for service " + service + "?";
        iw.log(this.confirm.question, 3);
        let self = this;
        this.confirm.confirmAction = function() {
          //First clean up any files
          self.removeAllStubFiles()
          if(self.stub.foo) {   //the stub was in state 'initial'              
            self.$emit('remove-stub', stix)              
          } else {
            self.$emit('remove-stub-save', stix)
          }      
        };
        this.confirm.showconfirmationdialog = true;
      },
                
      removePipelineFile : function () {
        let params = {"file-name": this.stub.pipeline['file-name'], "base-dir" : this.baseDir};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub pipeline file removed? " + data["$success"]);
        }, iw.testsuites.error);
      },       
      removeServiceStubInput : function() {
        let params = {"file-name": this.stub.service['input-file'], "base-dir" : this.baseDir};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub service input file removed? " + data["$success"]);
        }, iw.testsuites.error);         
      },
       
      removeDynamicStubInputFiles : function () {
        let params = {"file-name": this.stub.dynamic['stub-base-dir'], "base-dir" : this.baseDir, recursive: true, "only-subdirs": true};
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub dynamic files removed? " + data["$success"]);
        }, iw.testsuites.error);  
      },
       
      removeAllStubFiles : function () {
        let params = {"file-name": this.stubBaseDir, "base-dir" : ".", recursive: true};
        iw.log("Remove all stub files; params: " + JSON.stringify(params), 3);
        iw.invoke("iw.test.util.file:remove", params, function(data){
            iw.log("Stub dynamic files removed? " + data["$success"]);
        }, iw.testsuites.error);  
      },
       
      resetStub : function() {
        iw.log("Reset stub called. current stub: " + JSON.stringify(this.stub)); 
        iw.log("initial stub: " + JSON.stringify(this.initialStub));
        this.cleanupStubFiles(true);
        let self = this;
        //try to rename the stub directory if the service to stub has changed
        if(this.stub['service-to-stub'] !== this.initialStub['service-to-stub']) {
          let params = {  "base-dir"          : this.baseDir + "/" + this.testCaseDir, 
                          "existing-file-name": "stub-" + this.stub['service-to-stub'].replace(":","."),
                          "new-file-name"     : "stub-" + this.initialStub['service-to-stub'].replace(":",".")
                          };
            iw.invoke("iw.test.util.file:rename", params, function(data){
              if(data["$success"] === "true") {  
                  iw.log("Renamed stub directory back to 'stub-"+ self.initialStub['service-to-stub'] + "'");
              } else {
                iw.log("Could not rename stub directory back to "+ self.initialStub['service-to-stub'] );              
              }
          }, iw.testsuites.error);                                
        }
        this.isDirty = false;
        this.$emit('reset-stub');   
      },
       
      cleanupStubFiles : function(isReset) {
        iw.log("Clean up stub called. Reset: " + isReset,3);
        iw.log("this.stubType: " + this.stubType + "; this.initialStubType: " + this.initialStubType, 3);
        // clean up 
        if((!isReset && this.stubType  === 'pipeline') || (isReset && this.initialStubType === 'pipeline')) {
          iw.log("Cleaning up all but pipeline input", 3);
          if(this.stub.service  !== undefined) this.removeServiceStubInput();
          if(this.stub.dynamic  !== undefined) this.removeDynamicStubInputFiles();
         
          delete(this.stub.service);
          delete(this.stub.exception);
          delete(this.stub.dynamic);
          
        } else if((!isReset && this.stubType === 'service') || (isReset && this.initialStubType === 'service')) {
          iw.log("Cleaning up all but service input", 3);
          if(this.stub.pipeline !== undefined) this.removePipelineFile();
          if(this.stub.dynamic  !== undefined) this.removeDynamicStubInputFiles();
        
          delete(this.stub.pipeline);
          delete(this.stub.exception);
          delete(this.stub.dynamic);
        } else if((!isReset && this.stubType === 'exception') || (isReset && this.initialStubType === 'exception')) {
          iw.log("Cleaning up all stub files", 3);
          this.removeAllStubFiles();
          
          delete(this.stub.pipeline);
          delete(this.stub.service);
          delete(this.stub.dynamic);
          
        } else if((!isReset && this.stubType === 'dynamic') || (isReset && this.initialStubType === 'dynamic')) {
          iw.log("Cleaning up all but dynamic stub data", 3);
          if(this.stub.pipeline !== undefined) this.removePipelineFile();
          if(this.stub.service  !== undefined) this.removeServiceStubInput();            
          
          delete(this.stub.pipeline);
          delete(this.stub.service);
          delete(this.stub.exception);
          
        } else {
          iw.log("Not cleaning stub files: no condition applied", 3);
        }
      },
      
      saveStub : function() {
        this.isDirty = false;
        delete(this.stub.foo);
        this.cleanupStubFiles();
        this.$emit('save-stub', this.stub);
     }
    }    
  });
  
  iw.testsuitesApp.component('edit-callback', {
   
    template : "#edit-callback-template",
    
    props : ['initialCallback', 'localPackages', 'aliases', 'baseDir', 'testCaseDir', 'testSuiteName', 'testCaseName', 'cbix', 'packageName', 'distributedEnabled', 'assertionTypes'],
    
    data : function() {
      return {
          //make an independent copy of initialCallback, so we can easily revert
          cb               : JSON.parse(JSON.stringify(this.initialCallback)),
          eventTypes       : ['start','success','end','error'],
          isDirty          : false,
          expectedKey      : Date.now(),
          confirm                   : {
            question                : null,
            showconfirmationdialog  : false,
            confirmAction           : function(){}
          } 
      }
    },
    
    computed : {
    
    },
    
    methods : {
    
      showPipelineDialog : function (baseDir, fileName) {
            let output = this.cb.event === 'end' || this.cb.event === 'success' ;
            let error  = this.cb.event === 'error';
            this.$emit('show-pipeline-editor', {"baseDir": baseDir, "fileName": fileName, "service" : this.cb.service, "output": output, "error": error});
      },  
      
      removeCallback : function(cbix, service) {
        this.confirm.question = "Are you sure you want to delete callback on " + service + "?";
        let self = this;
        this.confirm.confirmAction = function() {
          iw.log("Removing callback: cleaning up files", 3);
          if(self.cb.expected !== undefined && self.cb.expected["file-name"] !== "") {
            iw.log("Deleting file " + self.cb.expected["file-name"] + "; base-dir: " + self.baseDir, 3);
            var params = {"file-name": self.cb.expected["file-name"], "base-dir": self.baseDir};
            iw.invoke("iw.test.util.file:remove", params, function(){}, iw.testsuites.error );        
          }
          if(self.cb.foo) {
            self.$emit('remove-callback', self.cbix)
          } else {
            self.$emit('remove-callback-save', self.cbix)
          }
        };
        this.confirm.showconfirmationdialog = true;
        
      },
      
      addAssertion: function(callback) {
        if(callback.expected === undefined){
          //Vue.set(callback, "expected", {});
          callback.expected = {};
        }
        if(callback.expected.assertions === undefined) {
          //Vue.set(callback.expected, "assertions", []);
          callback.expected.assertions = [];
        }
        
        callback.expected.assertions.push({"path": null, "check": "equals", "value": null, key: Date.now(), "foo": true});
      },  
      
      removeAssertion : function(expected, adx) {
         expected.assertions.splice(adx, 1);
         if(expected.assertions.length === 0) delete(expected.assertions);
      },
      
      saveCallback : function() {
          this.isDirty = false;
          delete(this.cb.foo);      //Remove the 'new' marker
          this.$emit('save-callback', this.cb);      
      },
      
      //MARKED FOR DELETION
      resetCallback : function() {
        let self = this;
        if(this.initialCallback.expected === undefined || this.initialCallback.expected["file-name"] === undefined) {
          if( this.cb.expected &&  this.cb.expected['file-name']) {
            iw.log("Callback reset: there was no initial expected file. Deleting "+ this.cb.expected["file-name"] , 3);
            var params = {"file-name": this.cb.expected["file-name"], "base-dir": this.baseDir};
            iw.invoke("iw.test.util.file:remove", params, function(){}, iw.testsuites.error );        
          } else {
            iw.log("Callback reset: no file to clean up", 3);
          }

        } else {
          if(this.initialCallback.expected["file-name"] === this.cb.expected["file-name"]) {
            iw.log("Callback reset called: there was no change in service or event type. Nothing to delete");
          } else {
            iw.log("Callback reset called. Renaming " + this.cb.expected["file-name"] + " to " + this.initialCallback.expected["file-name"], 3) ;
            var params = {"existing-file-name": this.cb.expected["file-name"], "new-file-name": this.initialCallback.expected["file-name"], "base-dir": this.baseDir};
              iw.invoke("iw.test.util.file:rename", params, function(result){
                if(result.$success === "true") {
                  iw.log("Callback pipeline file renamed. old name: " + params["existing-file-name"] +  "; new name: " + params["new-file-name"]);
                
                } else {
                  iw.log("Callback pipeline file rename failed: continue to use the old name: " + params["existing-file-name"] , 3);            
                }
            
              }, iw.testsuites.error );
          }
        }
        this.isDirty = false;
        this.$emit('reset-callback');
      },
      
      //This function handles both a change of the service and the event
      handleCallbackServiceChange : function(cb, field, value) {
        let self = this;
        let oldService = cb.service;
        let oldEvent   = cb.event;
        let newService = cb.service;
        let newEvent   = cb.event;
        
        iw.log("Callback changed. Dir: " + this.testCaseDir, 3);
        if(field === 'service') {
          //Change the service to the new value:
          newService   = value; 
          iw.log("Old service: " + oldService +"; new service: " + newService, 3);          
        }
        if(field === 'event') {
          //Change the event to the new value:
          newEvent     = value; 
          iw.log("Old event: " + oldEvent +"; new event: " + newEvent);                    
        }
        
        if(field === 'service' || cb.service !== "") {   //both event and service are present
          
          //Compose the callback file name using new values
          var cbFileName = iw.testsuites.composeCallbackFileName(this.testCaseDir, newService, newEvent);                                                   
          
          if(cb.expected["file-name"] === "") { //New callback
            
            //create empty pipeline
            iw.log("Callback pipeline created. Name: " + cbFileName, 3);
            
            let document = {};
            //Pre-populated the 
            if(newEvent === "error") {
               document = {"message"    : "Sample exception message",
                           "class-name" : "FlowException"
               }
            }
                        
            var params = {"$document" : document, 
                          "$path"     : cbFileName,
                          "$baseDir"  : this.baseDir,
                          "overwrite" : false
                          }
            iw.invoke("iw.test.util.pub:savePipelineToFile", params, function(data){
              if(data.$success === 'true') {
                 cb.service = newService; cb.event = newEvent; cb.expected["file-name"] = cbFileName;
                 self.expectedKey++;  //rerender the 'expected' component
                 self.saveCallback();
              } else {
                let message = "Could not create the callback on [" + cb.event + "] of " + cb.service + " because it already exists"
                iw.log(message, 2);
                self.$emit('reset-callback');
                self.showMessage({
                    message: message,
                    result: false,
                    timeout: 5000
                  });       
                
              }
              
            }, iw.testsuites.error   );

          } else { 
            //rename existing pipeline if we're dealing with a callback created via the UI
            
            var expectedOldCbFileName = iw.testsuites.composeCallbackFileName(this.testCaseDir, oldService, oldEvent);
            iw.log("Expected old callback file name: " + expectedOldCbFileName, 2 );
            iw.log("Current callback file name: "      + cb.expected["file-name"], 2 );
            
            if(expectedOldCbFileName ===  cb.expected["file-name"]) {
              var params = {"existing-file-name": cb.expected["file-name"],
                            "new-file-name"     : cbFileName,
                            "base-dir"          : this.baseDir,
                            "overwrite"         : "false"};
              iw.log("Rename parameters: " + JSON.stringify(params));
              
              

              //Try to rename the file. This will usually work, unless the target file already exists
              iw.invoke("iw.test.util.file:rename", params, function(result){
                if(result.$success === "true") {
                  iw.log("Callback pipeline file renamed. old name: " + cb.expected["file-name"] +  "; new name: " + cbFileName);                  
                  cb.service = newService; cb.event = newEvent; cb.expected["file-name"] = cbFileName;
                  self.expectedKey++;  //rerender the 'expected component
                  self.saveCallback();
                } else {
                  let message = "";
                  if(field === 'event')   message = "Could not change the event of the callback, as another callback for the [" + cb.event + "] event already exists";
                  if(field === 'service') message = "Could not change the service of the callback, as another callback for  [" + cb.event + "] of " + cb.service + " already exists";
                  
                  self.$emit('reset-callback');
                  iw.log(message, 2);     
                  self.showMessage({
                    message: message,
                    result: false,
                    timeout: 5000
                  });       
                  
                }
            
              }, iw.testsuites.error );

            } else {
              iw.log("Existing callback file name was not created via the UI. Leaving it as is", 2);
              //Nevertheles, save the callback
              this.saveCallback();
            }                                              
          }
        } else {
          cb.event   = newEvent;
          cb.service = newService;
        }

        
      },    
      
      showMessage : function ($event) {
        iw.log("[edit-callback] showMessage called. $event: " + $event, 3);
        this.$emit('message', $event);
      }
       
    
    }
  
  });
  
  iw.testsuitesApp.component('edit-expected',{
  
    template : "#edit-expected",
    
    props    : {
      packageName : String,
      baseDir     : String,
      testCase    : Object
    },
    
    data : function() {
      return {          
          ex               : this.testCase.expected ? JSON.parse(JSON.stringify(this.testCase.expected)) : {},
          expectedType     : this.testCase.expected && this.testCase.expected['file-name'] !== '' ? 'Expected' : this.testCase.expected && this.testCase.expected.exception && this.testCase.expected.exception.message ? 'Exception' : '',
          expectedTypes    : ['Expected','Exception', ''],
          isDirty          : false      
      }
    },
    
    methods  : {
      showPipelineDialog : function(baseDir, fileName, service, output, error) {
        this.$emit('edit-file',{baseDir : baseDir, fileName : fileName, service: service, output: output, error: error})
      },
       
      handleExpectedTypeChange : function(expectedType) {
        iw.log("Expected type change. new type: [" + expectedType + "]", 3);
        if(expectedType === 'Expected' && !this.ex['file-name'] ) {
           //Vue.set(this.ex, 'file-name', "");
           this.ex['file-name'] = "";
           //Vue.set(this.ex, 'lax'      ,false);
           this.ex.lax = false;
        } else if(expectedType === 'Exception' && !this.ex.exception){
           this.ex.exception = {message: "", "class-name" : ""}        
        }
        this.expectedType = expectedType;       
      },
      
      assignExpectedFileName($event) {
          iw.log("assignExpectedFileName (edit-expected) called. event: " + $event, 3);
          //Vue.set(this.ex, 'file-name', $event);
          this.ex['file-name'] = event;
          //Immediately save
          this.$emit('save-expected', this.ex)         
      },
            
      saveExpected : function() {
        if(this.ex['ignore-data-type-difference'] === ''){
          delete(this.ex['ignore-data-type-difference']);
        }
        if(this.expectedType === '') {
          delete(this.ex['file-name']);
          delete(this.ex['lax']);
          delete(this.ex['ignore-data-type-difference']);
          delete(this.ex.exception);
        } else if(this.expectedType === 'Exception') {
          delete(this.ex['file-name']);
          delete(this.ex['lax']);        
          delete(this.ex['ignore-data-type-difference']);
        } else {
          delete(this.ex.exception);
        }
         this.isDirty = false;
         this.$emit('save-expected', this.ex)         
      },
      
      resetExpected : function() {
         
         this.isDirty = false;
         this.$emit('refresh-expected')      
      },
       
      showMessage : function ($event) {
        iw.log("[edit-expected] showMessage called. $event: " + $event, 3);
        this.$emit('message', $event);
      }
       
    
    }
  
  });
  
  //register the global directives
  iw.testsuitesApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.testsuitesApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.testsuitesApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.testsuitesApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  iw.testsuitesApp.component(iw.app.components.selectService.name,      iw.app.components.selectService.impl);
  iw.testsuitesApp.component(iw.app.components.selectServiceModal.name, iw.app.components.selectServiceModal.impl);
  iw.testsuitesApp.component(iw.app.components.selectFile.name,         iw.app.components.selectFile.impl);
  
  iw.testsuites = iw.testsuitesApp.mount('#testsuites-app');
  iw.testsuites.getInfo();
  iw.testsuites.getConfig();
  iw.testsuites.getSession();
  iw.testsuites.getAssertionTypes();
  iw.testsuites.getAllTestSuites(true); 
  //iw.testsuites.listLocalPackages();

})(this, undefined);
