#/bin/sh -e
#This script loads iw-instrumentation agent onto a running
#JVM instance, identified by its processId (PID).

#Usage: attach-agent.sh JAVA_HOME PID ADD_TOOLS_LIB INSTRUMENTATION_JAR

#JAVA_HOME: used to locate the 'java' program in JAVA_HOME/bin
JAVA_HOME=$1

#The process Id of the JVM
PID=$2

#Whether to add 'tools.jar' to the classpath. This is necessary
#for java 1.8 or lower. valid values: 'true' or 'false'
ADD_TOOLS_LIB=$3

INSTRUMENTATION_JAR=$4

echo "[attach-agent.sh] JAVA_HOME: $JAVA_HOME; PID: $PID; add tools: $ADD_TOOLS_LIB"

#Optionally provide the location of the tools.jar library. Only for Java 8 or lower
#if tools.jar is not located in the usual location: $JAVA_HOME/lib/tools.jar or $JAVA_HOME/jre/lib/tools.jar
#JDK_TOOLS_LIB=$SAG_HOME/jvm/jvm/lib/tools.jar

CP=$INSTRUMENTATION_JAR

if [ "true" = "$ADD_TOOLS_LIB" ]; 
then
  if [ -f $JAVA_HOME/lib/tools.jar ];
  then
    CP=$CP:$JAVA_HOME/lib/tools.jar
  else
    if [ -f $JAVA_HOME/jre/lib/tools.jar ];
    then
      CP=$CP:$JAVA_HOME/jre/lib/tools.jar
    else
      if [ "" = "$JDK_TOOLS_LIB" ];
      then
	      echo tools.jar not found. Cannot attach code coverage agent. To correct, set the environment variable 'JDK_TOOLS_LIB'
        exit 3
      else
        if [ -f $JDK_TOOLS_LIB ];
        then
          CP=$CP:$JDK_TOOLS_LIB
        else
          echo JDK_TOOLS_LIB does not point to tools.jar. Please make sure it does.
          exit 4
        fi
      fi
    fi
  fi  
fi

$JAVA_HOME/bin/java -classpath $CP iw.test.cv.Attacher $PID $INSTRUMENTATION_JAR
