(function(window, undefined) {
  window.iw = {
    //global indicator. Set to true for exports
    offline       : false,
    
    logleveltable : ["error", "warn", "info", "debug", "trace"],
    
    logginglevel  : 1, 

    logging       : true,
    
    localAlias    : "(local)",
    
    addJsonFormat : true,
    
    queryParams   : {},
    
    log: function(message, level) {        
      if(iw.logging && window.console) {  //only if if console is defined
        if(level === undefined) level = 2 //info
        if(level <= iw.logginglevel) {
          //console.log("["+iw.logleveltable[level]+"] " + message);
          if(level == 0) console.error(message);
          if(level == 1) console.warn(message);
          if(level == 2) console.info(message);
          if(level == 3) console.debug(message);
          if(level == 4) console.debug(message);
        }
        
      }
    },
    
    uuidv4 : function() {      
      return ([1e7]+1e3+4e3+8e3+1e11).replace(/[018]/g, c =>
        (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
      )
    },
    
    parseQueryParameters : function() {
      let uri = window.location.href.split('?');
      if (uri.length == 2) {
        let query = uri[1];
        //Remove trailing '#/'
        if(query.endsWith("#/")) query = query.substring(0, query.length - 2);
        let vars = query.split('&');
        let getVars = {};
        let tmp = '';
        vars.forEach(function(v){
          tmp = v.split('=');
          if(tmp.length == 2) {
            let key   = tmp[0];
            let value = tmp[1];
            getVars[key] = decodeURIComponent((value + '').replace(/\+/g, '%20'));
          }
        });
        iw.queryParams = getVars;
        
        iw.log(this.queryParams,3);
      }  
    },
    
    /**
		* @input s:  string
		* @input a:  string array
		* @returns : longest common string
		*/
		findLongestCommonString : function (s, a) {
		   iw.log("[find LCS]: start", 3);
		   
         //only evaluate if both s and a are defined and a has at least one element
		   if(!s ||!a || a.length === 0 ) {
		      iw.log("[find LCS]: returning, input doesn't qualify", 4);
		      return s;
		   } 
		   
		   //only evaluate if s is a substring of the first element of a		   
		   if(a[0].indexOf(s) < 0) {
		      iw.log("string is not a substring of " + a[0], 4);
		      return s;
		   }
		   
		   var start = a[0].toLowerCase().indexOf(s.toLowerCase());
		   var sl    = s.length;
		   var ts    = s;

		   iw.log("start: "+start+" ts: " + ts + "; sl: " + sl, 4);
		   while(start >= 0 && start + sl < a[0].length) {  //limit loop to the length of the first array element
		      sl++;
		      iw.log("start: " + start + "; length: "+ sl, 4);
		      ts = a[0].substr(start, sl);
		      iw.log("next substring: " + ts, 4);
		      tmpA = a.filter(function(el){
		            return el.toLowerCase().includes(ts.toLowerCase());
		      });
		        
		      if(tmpA.length !== a.length) {
		      
		          ts = ts.substr(0, ts.length - 1);
		          iw.log("returning one character less. ts: " + ts, 4);
		          break;
		      }
		   
		   }
		   return ts;
		},
    
    parseContentType : function(contentType) {
      if(contentType == undefined) 
        return {}
      let parts = contentType.split(";").map(a => {return a.trim()});
      let type = parts[0];
      let result = {"type": parts[0]}
      if(parts.shift() !== undefined) {
        parts.map(a => {  
          let pt = a.split("=");
          result[pt[0]] = pt[1];
        });
      }
      return result;
    
    },
   
    isEmpty : function (obj) {
      for (const prop in obj) {
        if (Object.hasOwn(obj, prop)) {
          return false;
        }
      }
      return true;
    },
   
    invoke : function(service, data, onSuccess, onError) {
      var payload = {};
      if (data !== undefined) {
        payload = JSON.stringify(data);
      }
    
      try {
        var xhr = new XMLHttpRequest();
        let url = "/invoke/" + service.replace(":","/");
        if(iw.addJsonFormat === true) {
          //Add queryParameter 'jsonFormat' to override the corresponding Extended Setting 'watt.server.http.jsonFormat'
          url += "?jsonFormat=parsed";
        }
        
        xhr.open("POST", url);
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.setRequestHeader('Accept'      , 'application/json');
        //console.log("Posting to the IS");

        xhr.onreadystatechange = function() {
          //console.log("state: " + xhr.readyState);
          if(xhr.readyState == 4 ) {
            let contentType = iw.parseContentType(xhr.getResponseHeader('Content-Type'));
            if(xhr.status >= 200 && xhr.status < 300) {
              
              if(contentType.type === 'application/json') {  
                let parsedResult = JSON.parse(xhr.response);
                delete parsedResult.jsonFormat;
                onSuccess(parsedResult);
              }  else {
                //pass the raw response, along with the content-type
                onSuccess(xhr.response, contentType)
              }
            } else if (onError !== undefined){    
              var msg = xhr.response;
              if(contentType.type === 'application/json') {
                let errorResponse = JSON.parse(xhr.response);
                if(errorResponse.$error) {
                  msg = errorResponse.$errorType + ": " + errorResponse.$error;
                } 
                onError(msg, contentType, errorResponse);
                 
              } else {
                iw.log( "Content-Type: " +contentType.type, 1)
                try {
                  onError(msg, contentType, JSON.parse(msg));
                } catch {
                  onError(xhr.statusText, contentType, msg)
                }
              }

            }
          }
        }
         xhr.onerror = function(arg, msg) {
            iw.log("XHR Error:");
            iw.log(JSON.stringify(arg), 0);
            iw.log(JSON.stringify(xhr), 0);
            onError(msg);
         };
       
         xhr.upload.onerror = function(arg, msg) {
            iw.log("XHR Upload Error:");
            iw.log(arg);
            iw.log(xhr);
            iw.success = false;
            onError("Not connected anymore...")
         };
       
         xhr.onabort = function(arg) {
            iw.log("XHR Abort:");
            iw.log(arg);
            if(onError !== undefined) onError("Aborted");
         };
   
        xhr.send(payload);
      } catch(exception) {
          iw.log(exception, 0);
      }        
    },        
  
    listAliases: function() {
         iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.availableAliases = data.aliases;
            if(data.aliases.length === 0 ) {
               //iw.availableAliases.push("(local)");              
            }                               
         });
    },
    
  }
  
  iw.parseQueryParameters();

  if(!iw.offline) {
    //Query the server to find out whether watt.server.http.jsonFormat != parsed
    iw.invoke("wm.server.query:getSetting",{property: 'watt.server.http.jsonFormat'}, function(data){
      if(data.property === 'parsed') {
        iw.addJsonFormat = false;
      }
    });
  }
  
  iw.app = {
    directives: {},
    components: {}
  };
  
  iw.app.directives.focus = {name: 'focus', 
    impl: {
      inserted : function(element) {
        element.focus();
      }
    }
  };
  
  iw.app.components.menu = {name: 'iw-menu' , 
    impl: {
      template: `
        <div class="main-header">
            <a href=""><img class="logo" src="img/iw-logo-61x23.png" style="position: relative; top: 5px; left: 5px"/></a>
   
            <div class="dropdown"      v-bind:class="{'menu-active' : item === 'testsuites' || item === 'staticstubs' || item === 'stats'}" >Definitions
              <div class="dropdown-content">
                <a href="testsuites.html"  v-bind:class="{'menu-active' : item === 'testsuites'}"  >Test Suites</a>
                <a href="staticstubs.html" v-bind:class="{'menu-active' : item === 'staticstubs'}" >Static stubs</a>
                <a href="stats.html"       v-bind:class="{'menu-active' : item === 'stats'}"      > Static Code Coverage</a>
              </div>
            </div>

            <div class="dropdown"          v-bind:class="{'menu-active' : item === 'results' || item === 'coverage'}"     >Results
              <div class="dropdown-content">
                <a href="results.html"     v-bind:class="{'menu-active' : item === 'results'}" >Test Cases</a>
                <a href="coverage.html"    v-bind:class="{'menu-active' : item === 'coverage'}" >Dynamic Code Coverage</a>
              </div>
            </div>

            <div class="dropdown"      v-bind:class="{'menu-active' : item === 'record' || item === 'stubs'}" >Runtime
              <div class="dropdown-content">
                <a href="record.html"      v-bind:class="{'menu-active' : item === 'record'}"     >Record</a>
                <a href="stubs.html"       v-bind:class="{'menu-active' : item === 'stubs'}"      >Active Stubs</a>
              </div>
            </div>

            <div class="dropdown"      v-bind:class="{'menu-active' : item === 'config'}"     >Configuration
              <div class="dropdown-content">
                <a href="settings.html"                                         >Settings</a>
                <a v-if="distributedEnabled === 'true'" href="environment.html" >Environment</a>
              </div>
            </div>

            <div class="dropdown" v-bind:class="{'menu-active' : item === 'logs'}">
              <a href="logs.html">Logs</a>
            </div>
            
            <div class="dropdown" v-bind:class="{'menu-active' : item === 'docs'}">
              <a href="index.html">Docs</a>     
            </div>
            
            <div class="dropdown" v-bind:class="{'menu-active' : item === 'about'}">
              <a href="about.html">About</a>     
            </div>
            
          <div class="bell" v-if="isLatestVersionNewer && isLatestVersionNewer === 'true'">
            <a href="about.html" v-bind:title="'v'+latestVersion+' is available'"><span class="glyphicon glyphicon-bell"></span></a>
          </div>

        </div>
        

        `,
        props: ['item', 'isLatestVersionNewer', 'latestVersion', 'distributedEnabled'],
    }
  };
  
  iw.app.components.confirmModal = {name: 'confirm-modal', 
    impl: {
        template : `
          <div style="z-index: 100" class="modal" id="confirmationdiv">
            <div class="modal-box confirmation-modal" v-on:keyup.esc="cancelAction()">  
              <table class="table">
                <thead>
                  <tr><th class="header"><span class="glyphicon glyphicon-question-sign"></span></th>
                  </tr>
                </thead>             
                <tbody class="high">
                  <tr>
                    <td class="header">{{question}}</td>
                  </tr>
                </tbody>
                <tfoot>
                  <tr >
                    <th class="header">
                      <button class="btn" type="submit" v-focus v-on:click="confirmAction()">
                        <span class="glyphicon glyphicon-ok"></span> Confirm</button>                    
                      <button class="btn" type="submit" v-on:click="cancelAction()">
                        <span class="glyphicon glyphicon-remove"></span> Cancel</button>
                    </th>
                  </tr>
                </tfoot>                   
              </table>
            </div>
          </div>
        `,
        
        props : ['question'],
        
        emits : ['confirmed', 'canceled'],
        
        data : function() {
          return {            
              
          }
        },
        
        methods : {
          showConfirmDialog : function() {  //string, function                      
          },
          
          confirmAction : function() {
            iw.log("Confirm: " + this.question, 3)
            this.$emit("confirmed", "confirm");
          },
          
          cancelAction : function() {
            iw.log("Cancel: " + this.question, 3);        
            this.$emit("canceled", "cancel");
          }        
        }
    }
  };

  iw.app.components.editTextField = {name: 'edit-text-field',
   impl: {  
      template: `
        <span>        
          <span v-if="editValue">
            <a href="#/" v-bind:disabled="!isDirty === true ? true : null" v-on:click="valueChanged(value); " style="padding-right: 3px" > <span class="glyphicon glyphicon-ok"     aria-hidden="true" title="save"  /></a>
            
            <a href="#/"                            v-on:click="valueUnchanged();    " > <span class="glyphicon glyphicon-remove" aria-hidden="true" title="cancel"/></a>
            &nbsp;
            <select v-if="possibleValues" v-focus class="short" v-model='value' v-on:change="isDirty=true"  v-on:keyup.enter="valueChanged(value)">
               <option v-for="v in possibleValues">{{v}}</option>
            </select>
            <input v-else v-focus v-bind:style="{'width' : width}" v-bind:type="inputType" v-model='value' v-on:keyup="isDirty=true" v-on:keyup.enter="valueChanged(value)"/>
          </span>
          <span v-else>
            <a href="#/" v-bind:disabled="editValue === true? true : null" v-on:click="editValue = true" > <span class="glyphicon glyphicon-pencil" aria-hidden="true" title="edit"  /></a>
            &nbsp;
            <span v-if="enableClickEvent">
                 <a class="event" href="#/" v-on:click="$emit('clicked')"> {{value}} </a>          
            </span>
            <span v-else>
                {{value}}
            </span>
          </span>
        </span>
      `,
      
      props: ['initialValue', 'possibleValues', 'inputType', 'enableClickEvent', 'initialEditValue', 'width'],
      
      data : function() {
        iw.log("[edit-text-field] props: initialValue:" + this.initialValue + "; width: " + this.width, 3)
        return {
          value:       this.initialValue,
          editValue:   this.initialEditValue? true : false,
          isDirty:     false
        }
      },
      
      methods : {
      
        valueChanged : function(value) {
          this.editValue = false;
          this.$emit('changed-value', value)
          this.isDirty = false;
        },
        
        valueUnchanged : function() {     
          this.editValue = false;
          this.value = this.initialValue;
          this.isDirty = false;
        } 
      }  
    }
  };

  iw.app.components.selectService = {name: 'select-service' , 
    impl: {
      template: `
        <div>        
        
          <div class="row" v-if="distributedEnabled === 'true' && aliasChangeable && availableAliases.length > 1" >
            <div class="column1">Remote server:</div>
            <div class="column2">
              <select v-model="alias" v-on:change="listPackages(alias)">
                <option></option>
                <option v-for="serverAlias in availableAliases">{{serverAlias}}</option>
             </select>                                          
            </div>
          </div>
          
          <div class="row" v-else-if="distributedEnabled === 'true' && alias">
            <div class="column1">Remote server:</div>
            <div class="column2">{{alias}}</div>            
          </div >
          
          <div class="row">
            <div class="column1">Package (optional):</div>
            <div class="column2">
              <select id="package-select"  v-bind:value="packageName" v-on:change="handlePackageChange($event)">
                <option></option>
                <option v-for="p in packages">{{p.name}}</option>
              </select>
            </div>
          </div>
        
          <div class="row">
            <div class="column1">Service:</div>
            <div class="column2">
              <div style="position: relative">
                <input  v-focus id="search-service-input" style="width: 100%" v-bind:value="serviceName" v-on:paste="handleServiceNamePaste($event)" v-on:keyup="handleServiceNameChange($event)" type="text" placeholder="type service name"></input>
                <textarea v-show="filteredServices.length > 0 && !selected" style="position: absolute; top: 25px; left:0" 
                        id   = "service-list-area" 
                        ref  = "ta"
                        readonly 
                        v-bind:value="servicesText"
                        v-bind:rows="filteredServices.length > 20 ? 20 : filteredServices.length"                       
                        v-on:keyup       = "setSelectLine($event)"
                        v-on:click       = "setSelectLine($event)"
                        ></textarea>
              </div>
            </div>
          </div>                       
      
        </div>    
      `,
    
      props: ['distributedEnabled', 'initialAlias', 'initialPackages', 'initialServiceName', 'initialPackageName', 'aliasChangeable','availableAliases'],
    
      data : function() {
        return {
          alias:       this.initialAlias,
          packages:    this.initialPackages,
          serviceName: this.initialServiceName,
          packageName: this.initialPackageName,
          services: [],
          filteredServices : [],
          servicesText: "",
          selected: true
        }
      },
    
      methods: {
      
        setPackages : function(data) {
          iw.log("Retrieved packages", 3);
          if(data.packages) {
            this.packages = data.packages;
          } else {
            this.packages = [];
          }
        },
        
        
        listPackages : function (alias) {
          
          var params = {"$alias": alias};
          
          let rp = [];
          
          iw.invoke("iw.test.ui.ns:listPackages", params, this.setPackages); 
        
          this.$emit("update-alias", alias);
        },
        serviceComparator : function(a, b) {
          return a.nsname > b.nsname ? 1 : (b.nsname > a.nsname ? -1 : 0);
        },
        
        setServices : function(data) {
          this.services = data.services.sort(this.serviceComparator);
          iw.log("-- Retrieved services", 3);
          iw.log(this.services, 4);
          this.filteredServices = this.services;
          this.servicesText = this.filteredServices.map(function(s){return s.nsname}).join("\n");
          if(this.servicesText.length == 0) {
             this.servicesText = "<no matching services>";
          }              
        },
        
        retrieveServices : function(pkg, namePart) {
          let params = {"package": pkg === undefined || pkg === null ? "" : pkg , "serviceNamePart": namePart, "$alias" : this.alias};
          iw.invoke("iw.test.ui.ns:listServices", params , this.setServices, this.error);		       
        },
        
        handlePackageChange : function(event) {
          iw.log("-- Handling package change. Retrieving services for " + event.target.value, 3);
          //get hold of the newly selected package
          let pkg = event.target.value;
          this.selected = false;
          //Reset the service name
          this.serviceName = "";
          this.$emit('service-deselected');
          this.retrieveServices(pkg);
          this.packageName = pkg;
        },
            
        handleServiceNameChange : function(event) {
          this.serviceName = event.target.value;
          iw.log("Service name changed: event code: " + event.keyCode + "; service name: "+ this.serviceName, 3);  
          iw.log(event,3);
          this.selected = false;
          this.$emit('service-deselected');
          /*
          - If there is no package selected, and the length of the service name part == 2, then and 
            only then query the IS.
            In all other cases, filter the list of services.
          */
          if(!this.packageName && this.serviceName && this.serviceName.length <= 2) {
            if(this.serviceName.length == 2) {  
              iw.log("Service Name length == 2 and no package selected: retrieving services from IS", 3);
              this.retrieveServices(null, this.serviceName);
            } else {
              //clear the list of services and filtered services
              this.services = [];
              this.filteredServices = [];
            }
          } else {		       
              this.filterServices();
              //Trying to the extend serviceName..
              //The filtered service list is not changed here.
              //But only if there is a filteredServicesList and if the user wasn't deleting characters
              //event.keyCode 46 = delete
              //event.keyCode  8 = backspace
              iw.log("Event key code: " + event.keyCode, 3);
              if(this.filteredServices.length > 0 && this.serviceName && this.serviceName.length > 2 && (event.keyCode != 46 && event.keyCode != 8)) {
                  iw.log("Extending the service name...", 3);
                  this.serviceName = iw.findLongestCommonString(this.serviceName, this.filteredServices.map(function(el){return el.nsname }));
                  if(this.filteredServices.length == 1) {
                    this.serviceName = this.filteredServices[0].nsname;
                    this.selected = true;
                    this.$emit('service-selected', this.serviceName);    
                  }
              }
              //end smart extension of the service name
          }
        },
        
        handleServiceNamePaste : function () {
          var pastedString = event.clipboardData.getData('text');
          iw.log("Service name pasted in: event code: " + event.keyCode + "; service name: "+ pastedString, 3);  		    
          this.retrieveServices(null, pastedString);
          this.serviceName = pastedString;
        },
        
        filterServices : function () {
           iw.log("Filtering service list", 3);  
           if(this.serviceName) {
              let s = this.serviceName.toLowerCase();
              iw.log("service name part: " + s, 4);
              this.filteredServices = this.services.filter(function(a){
                let result = false;
                if (a.nsname.toLowerCase().includes(s)) {
                  result = true;
                } 
                iw.log(a.nsname + " qualifies? " + result, 4);
                return result
              });
            } else {
              this.filteredServices = this.services;
            }
          this.servicesText = this.filteredServices.map(function(s){return s.nsname}).join("\n");
          if(this.servicesText.length == 0) {
             this.servicesText = "<no matching services>";
          }  
        },
        
        getLineBeginEnd : function(cursorPosition, text) {          
            let lineStart = 0;
            let lineEnd   = 0;
            
            lineStart = text.lastIndexOf("\n", cursorPosition - 1) + 1
            lineEnd   = text.indexOf("\n", lineStart);
            if(lineEnd < 0) {
                lineEnd = text.length;
                iw.log("[line-begin-end] line end < 0; setting to text.length: " + lineEnd, 3);
            }
            iw.log("[line-begin-end] cursor position: " + cursorPosition + "; computed line start & end: " + lineStart + ":" + lineEnd, 3);
            return {lineStart: lineStart, lineEnd: lineEnd};
        }, 
        
        setSelectLine : function(event) {
          
          let cursorPosition = event.target.selectionStart
          if(event.keyCode === 9) {  //that's a 'tab', this means the textarea got focus
             //Normally the cursor is positioned at the end of the text area,
             //but we want to select the first line when the textarea received focus
             cursorPosition = 0;
          }
          //Calculate the begin and end positions of the line the cursor is at
          let beginEnd = this.getLineBeginEnd(cursorPosition, event.target.value);          
          
          event.target.selectionStart = beginEnd.lineStart;
          event.target.selectionEnd   = beginEnd.lineEnd;
          let selectedService = event.target.value.substring(beginEnd.lineStart, beginEnd.lineEnd);
          iw.log("[select-line] ["+beginEnd.lineStart+":"+beginEnd.lineEnd+"] service: " + selectedService);
          
          //Use the selected service
          if(event.type === "click" || event.key === "Enter") {
              this.serviceName    = selectedService;
              this.selected       = true;
              this.$emit('service-selected', selectedService);
           }
        }
      }
    }
  };
    
  iw.app.components.selectServiceModal = {name: 'select-service-modal', 
    impl: {
      template : `
        <div style="display: inline-block">
          
          <div>
            <a href="#/" v-on:click="showSelectServiceModal()"> 
               <span class="glyphicon glyphicon-search" aria-hidden="true"></span>
            </a>
            &nbsp;
            <span v-if="service !== undefined && service !== null && service !== '' && !noDisplay">  
              <a href="#/" v-on:click="clearService()">
                <span class="glyphicon glyphicon-remove" aria-hidden="true" ></span>
              </a>
              &nbsp;&nbsp;{{service}}   
            </span>
          </div>
          
          <div class="modal" v-if="showModal">
            <div class="modal-box select-service-modal" style="z-index: 995" id="selectservicemodal" >
          
              <div class="table">
                <div class="header">Search Service</div>
              </div>          

              <div class="table">

                <select-service v-bind:initial-alias        = "initialAlias"
                                v-bind:initial-packages     = "initialPackages"                            
                                v-bind:initial-package-name = "initialPackageName"
                                v-bind:alias-changeable     = "true"         
                                v-bind:distributed-enabled  = "distributedEnabled"
                                v-bind:available-aliases    = "availableAliases" 
                                v-on:service-selected       = "selectedService = $event"
                                v-on:update-alias           = "selectedAlias = $event"
                ></select-service>
                <!-- v-bind:initial-service-name = "initialServiceName" -->
              
                <table class="table">
                  <tfoot>
                    <tr >
                      <th class="header">
                        <button class="btn" v-bind:disabled="false" type="submit" v-on:click="assignSelectedService()">
                         <span class="glyphicon glyphicon-play"></span> Select Service</button>
              
                        <button class="btn" v-bind:disabled="false" type="submit" v-on:click="hideSelectServiceModal()"> 
                          <span class="glyphicon glyphicon-remove"style="color: #E2F9EB" aria-hidden="true"></span> Cancel</button>
                      </th>
                    </tr>
                  </tfoot>
                </table>          
               
              </div>          
            
            </div>
          </div>
          
        </div>
      `, 
      
       props: ['distributedEnabled', 'initialAlias', 'initialPackages', 'initialServiceName', 'initialPackageName', 'aliasChangeable','availableAliases', 'noDisplay'],
    
       data : function() {
         iw.log("[select-service-modal][init] initialServiceName: " + this.initialServiceName, 3);
         return {
            service         : this.initialServiceName,
            selectedService : this.initialServiceName,
            selectedAlias   : this.initialAlias,
            showModal       : this.initialServiceName === null 
        }
      },
      
      methods : {
        
        assignSelectedService : function() {
          this.service   = this.selectedService;
          this.showModal = false;
          this.$emit('update-alias', this.selectedAlias);
          this.$emit('service-selected', this.service )        
        },
        
        clearService : function() {
          this.service = "";
          this.$emit('service-selected', this.service )
        },
        
        showSelectServiceModal : function() {
            this.showModal = true;
            this.$emit('search-icon-clicked', true)
        },
        
        hideSelectServiceModal : function() {
          this.showModal = false;      
          this.$emit('search-modal-closed', true)
        }    
      }  
    }
  };
  
  iw.app.components.selectFile = {name: 'select-file', 
    impl: {  
      template: `   
        <div style="display : inline-block">
        
          <!-- Start inline icons -->
          <div>
            <a href="#/" v-on:click="showSelectFileModal()">   <span class="glyphicon glyphicon-search" aria-hidden="true"></span></a>
            &nbsp;                    

            <span v-if="isFile && initialFileName && initialFileName !== ''">
               <a  v-bind:title="'Edit '    + initialFileName"    href="#/" v-on:click="editFile()"> <span class="glyphicon glyphicon-pencil" aria-hidden="true"></span></a> &nbsp;
            </span>
            
            <span v-if="isFile && initialFileName && initialFileName !== ''" >
              <a  v-bind:title="'Download ' + initialFileName"    v-bind:href="'/invoke/iw.test.util.file/getContent?base-dir=' + baseDir + '&file-name=' + fileName" v-bind:download="downloadPrefix.replace(':','.') + '-' + fileName"> <span class="glyphicon glyphicon-download" aria-hidden="true"></span> </a>  
              &nbsp;
            </span>

            <span v-if="initialFileName && initialFileName.length > 0">  
              <a v-bind:title="'Remove '    + initialFileName"     href="#/" v-on:click="clearFile()">  <span class="glyphicon glyphicon-remove" aria-hidden="true" ></span></a>
              &nbsp; 
            </span>
            <span v-bind:class = "{error : RegExp('test-error.xml').test(fileName)}">{{fileName}}</span>
            &nbsp;
            
            <span v-if="isFile && initialFileName && initialFileName.length > 0 && isRegularOrErrorResult(fileName)">  
              <a v-bind:title="getToggleText(fileName)"     href="#/" v-on:click="toggleOutputErrorFile()">  <span class="glyphicon glyphicon-refresh" aria-hidden="true" ></span></a>
              &nbsp; 
            </span>
            
          </div>        
          <!-- End inline icons -->      
          
          <!-- start file modal -->
          <div class="modal" v-if="showModal">
          
            <div class="modal-box select-file-modal" id="selectfilemodal" >
          
              <table style="text-align: left; " class="table">  <!-- test suite table -->
                <thead>
                  <tr>
                    <th colspan="2">
                     <button class="btn" v-bind:disabled="false" type="submit" v-on:click="hideSelectFileModal()"> 
                      <span class="glyphicon glyphicon-remove"style="color: #E2F9EB" aria-hidden="true"></span> Close</button>
                      
                 <button class="btn" v-if="isFile" type="submit" v-on:click="selectFile()"> 
                      <span class="glyphicon glyphicon-ok"style="color: #E2F9EB" aria-hidden="true"></span> Select file</button>
                          
                 <button class="btn" v-if="!isFile" type="submit" v-on:click="selectDirectory()"> 
                      <span class="glyphicon glyphicon-ok"style="color: #E2F9EB" aria-hidden="true"></span> Select folder</button>
                    </th>
                  </tr>
                </thead>
                <tbody class="high" style="border-bottom: 2px solid green">
                  <tr>
                    <td class="bold" width="80px">Folder: </td>
                    <td>{{dir}}</td>
                  </tr>
                  <tr v-if="isFile">
                    <td class="bold">File: </td>
                    <td>{{selectedFileName}}</td>
                  </tr>              
                </tbody>
              
              </table>
            
              <div class="scroll" style="flex: 1">
                              
                <table style="text-align: left" class="table">

                  <thead>
                    <tr>               
                        <th>name</th>
                        <th style="text-align: right">size (bytes)</th>
                        <th style="text-align: right; padding-right: 10px">last modified</th>
                    </tr>
                  </thead>

                  <tbody> 
                          
                    <tr v-if="dir.length > baseDir.length">
                      <td>
                        <span class="glyphicon glyphicon-directory"></span>
                        &nbsp;
                        <a href="#/" v-on:click="getDirContents(parent)"> ..</a>
                      </td>
                      <td></td>
                      <td></td>
                    </tr>
                  
                    <tr v-for="(item, idx) in dirContents">
                      <td>              
                        <span v-if="item['is-dir']" class="glyphicon glyphicon-directory"></span>
                        <span v-else                class="glyphicon glyphicon-file"></span>              
                    
                        &nbsp;
                 
                        <a v-if="item['is-dir']" href="#/" v-on:click="getDirContents(dir, item.name)"> {{item.name}}</a>
                        <a v-else                href="#/" v-on:click="selectedFileName=item.name"> {{item.name}}</a>
                      </td>
                      <td style="text-align: right">{{item.size}}</td>
                      <td style="text-align: right; padding-right: 10px">{{item['last-modified-date']}}</td>
                    </tr>

                  </tbody>

                </table>

              </div>
            
            </div>
          </div>

          <!-- End file modal -->        
          
          
        </div>
     `,
      
      props: ['initialBaseDir', 'initialFileName', 'packageName', 'isFile', 'downloadPrefix'],
      
      data : function () {
        iw.log("Initializing 'select-file' component. baseDir: " + this.initialBaseDir + "; is-file: " + this.isFile + "; fileName: " + this.initialFileName, 3);

        return {
          dir              : this.isFile ? this.initialBaseDir : this.initialFileName,
          baseDir          : this.initialBaseDir,
          dirContents      : [],
          parent           : ".",
          fileName         : this.initialFileName,
          selectedFileName : "",
          selectedDir      : "",
          showModal        : false
        }    
      },
      
      methods : {
        getDirContents : function(dir, item) {
                
          iw.log("[select-file] 'getDirContents called. dir: " + JSON.stringify(dir), 3);
          if(dir === null || "" === dir) return;
          
          if(this.baseDir !== undefined) {
            if(dir.length < this.baseDir.length) {
              dir = this.baseDir;
            }
          } else {
            if(dir.length < this.initialBaseDir.length) {
              dir = this.initialBaseDir;
            }        
          }
          let self = this;
          let params = {dir: dir }
          if(item !== undefined && dir !== "") params = {dir: dir + "/" + item}
          if(item !== undefined && dir === "") params = {dir: item}
          
          iw.log("Retrieving folder contents for: " + JSON.stringify(params), 3);
          iw.invoke("iw.test.util.file:list", params, function(data){
            if(data.children !== undefined) {
              self.assignFolderData(data);    
            }  else {

              //if there are no children, then the directory doesn't exist. In that case, the directory is probably relative
              //to the package
              let bdir = "packages/" + self.packageName;
              iw.log("Folder not found. Trying with " + bdir, 3)
              
              params = {dir: bdir}
                iw.invoke("iw.test.util.file:list", params, function(data){     
                  if(data.children !== undefined) {
                     self.baseDir = bdir;
                     self.assignFolderData(data);
                  } else {
                     //Issue error message?
                  }              
                });            
            }

          });
          
        },
        
        assignFolderData : function(data) {
          this.parent = data.parent;
          this.dir    = data.dir;
          this.dirContents = data.children;
           
          if(this.dirContents !== undefined) {          
              this.dirContents.map(function(a){a['last-modified-date'] = (new Date(a['last-modified'])).toLocaleString()}); 
            }            
        },
        
        clearFile : function() {
          this.fileName = '';
          this.$emit('file-selected', '')
        },
        
        editFile :  function() {
          this.$emit('edit-file', {baseDir: this.baseDir, fileName: this.fileName});
        },
        
        isRegularOrErrorResult : function(fileName) {
          return (fileName.indexOf('test-output.xml') > -1 || fileName.indexOf('test-error.xml') > -1 );
        },
        
        getToggleText : function(fileName) {
            if(fileName.indexOf("test-error.xml") >= 0) {
              return "Change an expected exception to a normal expected result";
            } else if (fileName.indexOf("test-output.xml") >= 0) {
              return "Change normal expected result into an expected exception"
            } else return "";
            
        },
        
        toggleOutputErrorFile : function() {
          iw.log("Toggle output/error; baseDir: " + this.baseDir + "; fileName: " + this.fileName + "; initialFileName: " + this.initialFileName, 3);
          let newFileName = null;
           if(this.fileName.indexOf("test-output.xml") > -1) {            
              newFileName = this.fileName.replace("output", "error");         
           } else if (this.fileName.indexOf("test-error.xml") > -1) {           
             newFileName = this.fileName.replace("error", "output");         
           }

          if(newFileName === null) {
            iw.log("Not renaming " + this.fileName + ". Could not determine new file name", 2);
            return;
          }
           let params = {
             "existing-file-name": this.fileName,
             "new-file-name":  newFileName,
             "base-dir": this.baseDir,
             "overwrite": "false"
           };
           
           let self = this;
           
           iw.invoke("iw.test.util.file:rename", params, function(data){
             if(data.$success === "true") {
               iw.log("Renamed " + self.fileName + " to " + newFileName, 3 );
               self.fileName = newFileName;
               self.$emit('file-selected', self.fileName );
               iw.log("Toggle output/error after $emit; baseDir: " + self.baseDir + "; fileName: " + self.fileName + "; initialFileName: " + self.initialFileName, 3);
             } else {
               let message = "Cannot change result type. " + newFileName + " already exists";
               window.iw.log(message, 2);
               self.$emit('message', {message: message , result: false, timeout: 3000});
             }
           }, function() {});
        },
        
        selectFile : function() {
          iw.log("[select-file] this.selectedFileName: " + this.selectedFileName + ";this.fileName: " + this.fileName, 3);
          iw.log("[select-file] this.baseDir: " + this.baseDir + "; this.dir: " + this.dir);
          //Substract baseDir from dir
          let subDir = this.dir;
          if(this.baseDir) {
            subDir = this.dir.substring(this.baseDir.length + 1);
            this.fileName = this.selectedFileName;
            //Only prepend subDir plus a slash if it has a value
            if(subDir.length > 0) {
              this.fileName = subDir + "/" + this.selectedFileName;
            }
          }
                  
          iw.log("Selecting file. fileName: " + this.fileName, 3);
          
          this.showModal = false;
          this.$emit('file-selected', this.fileName );
        },
        
        selectDirectory : function() {
          
           let subDir = this.dir.substring(this.baseDir.length )
           //Remove the slash if subDir is defined
           if(this.baseDir.length > 0) subDir = subDir.substring(1);
           iw.log("Select direcory called. this.fileName: " + this.fileName + "; this.dir: "+ this.dir + "; subDir: " + subDir , 3);
           this.fileName = subDir;
           this.showModal = false;
           this.$emit('file-selected', subDir  )
        },
        
        showSelectFileModal : function() {
            this.showModal = true; 
            //Rescan the directory everytime the modal is activated
            this.getDirContents(this.initialBaseDir);
        },
        
        hideSelectFileModal : function() {
          this.showModal = false;
          this.selectedFileName = "";
        },
        
        showEditFileModal : function() {
          this.showModal = false;
          this.$emit('edit-file')
        }
      }
    
    }
    
  };
     
  iw.app.components.selectUser = {name: 'select-user', 
    impl: {  
      template: `
         <div style="display: inline">
           <a href="#/" v-on:click="showSelectUserDialog()" >              
                <span class="glyphicon glyphicon-search " aria-hidden="true"></span>                  
           </a>
           
           <div class="modal" v-show="showsearchuserdiv" id="selectuserdiv">
             <div class="modal-box confirmation-modal" v-on:keyup.esc="hideSelectUserDialog()">  
               <table class="table">
                 <thead>
                   <tr><th colspan="3" class="header">Select user</th>
                   </tr>
                 </thead>             

                 <tbody class="high">
                  <tr>
                    <td>User
                    </td>
                    <td><select v-model="user">
                        <option v-for="u in users">{{u.name}}</option>
                      </select>
                    </td>
                  </tr>
                 </tbody>
                 
                 <tfoot class="high">
                   <tr >
                     <th colspan="3" class="header">
                       <button class="btn" type="submit" v-on:click="selectUser()">
                         <span class="glyphicon glyphicon-ok"></span> Select</button>                    
                       <button class="btn" type="submit" v-on:click="hideSelectUserDialog()">
                         <span class="glyphicon glyphicon-remove"></span> Cancel</button>
                     </th>
                   </tr>
                 </tfoot>                   
               </table>
             </div>
           </div>      
         </div>
        `,
      props: [],
      data : function () {      
        
        return {
          showsearchuserdiv: false,
          users: [],
          user: null
        }
      },
      methods: {
        listUsers : function() {
          let self = this;
          iw.invoke("wm.server.access:userList", {}, function(data) {
            
            self.users = data.users;
            
          });  
        },
        hideSelectUserDialog : function() {
          this.showsearchuserdiv = false;
        },
        
        showSelectUserDialog : function() {
          this.listUsers();
          this.showsearchuserdiv = true;
        },
        
        selectUser : function() {
          iw.log("Selected user: " + this.user, 3);
          this.$emit("user-selected", this.user);
          this.hideSelectUserDialog();
        }
        
      }
    }
  };     
  
  iw.app.components.selectSession = {name: 'select-session', 
    impl: {  
      template: `
         <div style="display: inline">
           <a href="#/" v-on:click="showSelectSessionDialog()" >              
                <span class="glyphicon glyphicon-search " aria-hidden="true"></span>                  
           </a>
           
           <div class="modal" v-show="showselectsessiondiv" id="selectsessiondiv">
             <div class="modal-box confirmation-modal" v-on:keyup.esc="hideSelectSessionDialog()">  
               <table class="table">
                 <thead>
                   <tr>
                     <th colspan="3" class="header">Select session</th>
                   </tr>
                 </thead>             

                 <tbody class="high">
                  <tr>
                    <td>Session ID</td>
                    <td>
                      <select v-model="sessionID">
                        <option v-for="s in sessions" v-bind:value="s.ssnid">{{s.ssnid}} ({{s.user}}:{{s.name}})</option>
                      </select>
                    </td>
                  </tr>
                 </tbody>
                 
                 <tfoot class="high">
                   <tr >
                     <th colspan="3" class="header">
                       <button class="btn" type="submit" v-on:click="selectSession()">
                         <span class="glyphicon glyphicon-ok"></span> Select</button>                    
                       <button class="btn" type="submit" v-on:click="hideSelectSessionDialog()">
                         <span class="glyphicon glyphicon-remove"></span> Cancel</button>
                      </th>
                   </tr>
                 </tfoot>                   
               </table>
             </div>
           </div>      
         </div>
        `,
      props: [],
      data : function () {      
        
        return {
          showselectsessiondiv: false,
          sessions: [],
          sessionID: null
        }
      },
      methods: {
        listSessions : function() {
          let self = this;
          iw.invoke("wm.server.query:getSessionList", {}, function(data) {
            
            self.sessions = data.sessions;
            
          });  
        },
        
        hideSelectSessionDialog : function() {
          this.showselectsessiondiv = false;
        },
        
        showSelectSessionDialog : function() {
          this.listSessions();
          this.showselectsessiondiv = true;
        },
        
        selectSession : function() {
          iw.log("Selected session: " + this.sessionID, 3);
          this.$emit("session-selected", this.sessionID);
          this.hideSelectSessionDialog();
        }
        
      }
    }
  };     
 
  iw.app.components.selectPackage = {name: 'select-package', 
    impl: {  
      template: `
         <div style="display: inline">
           <a href="#/" v-on:click="showSelectPackageDialog()" >              
                <span class="glyphicon glyphicon-search " aria-hidden="true"></span>                  
           </a>
           
           <div class="modal" v-if="showselectpackagediv" id="selectpackagediv" v-focus>
             <div class="modal-box confirmation-modal" v-on:keyup.esc="hideSelectPackageDialog()">  
               <table class="table">
                 <thead>
                   <tr>
                     <th colspan="3" class="header">Select package</th>
                   </tr>
                 </thead>             

                 <tbody class="high">
                  <tr>
                    <td>Package</td>
                    <td>
                      <select v-model="packageName">
                        <option v-for="p in packages">{{p}}</option>
                      </select>
                    </td>
                  </tr>
                 </tbody>
                 
                 <tfoot class="high">
                   <tr >
                     <th colspan="3" class="header">
                       <button class="btn" type="submit" v-on:click="selectPackage()">
                         <span class="glyphicon glyphicon-ok"></span> Select</button>                    
                       <button class="btn" type="submit" v-on:click="hideSelectPackageDialog()">
                         <span class="glyphicon glyphicon-remove"></span> Cancel</button>
                      </th>
                   </tr>
                 </tfoot>                   
               </table>
             </div>
           </div>      
         </div>
        `,
      props: ['excludedPackagesList', 'system', 'enabled'],
      
      emits: ['package-selected'],
      
      data : function () {      
        iw.log("Initializing 'select-package'-component; system: " + this.system + "; enabled: "+ this.enabled + "; excluded packages: " + this.excludedPackagesList, 3);
        return {
          showselectpackagediv: false,
          packages: [],
          packageName: null
        }
      },
      methods: {
        listPackages : function() {
          let self = this;
          iw.invoke("iw.test.ui.ns:listPackages", {}, function(data) {
            iw.log("START Filtering packages; criteria: system: " + self.system + "; enabled: " + self.enabled + "; excluded packages list: " + self.excludedPackagesList , 3);  
            //iw.log("Excluded packages list type: " + typeof(self.excludedPackagesList ) +  "; first item: "+ self.excludedPackagesList[0]);
            //Filter out packages
            self.packages =  data.packages.filter(function(a){                     
                 let result = a["system-package"] === String(self.system) && a.enabled === String(self.enabled) && !(self.excludedPackagesList.includes(a.name));                 
                 //iw.log("Package Name: " + a.name + "; system package: " + a["system-package"] + "; enabled: " + a.enabled + "; result: "+ result, 3);                 
                 return result;
            }).map(p => p.name).sort(function(a,b){ if(a.name >= b.name) return 1; else return -1});
            iw.log("END Filtering packages", 3);  
          });  
        },
        
        hideSelectPackageDialog : function() {
          this.showselectpackagediv = false;
        },
        
        showSelectPackageDialog : function() {
          this.listPackages();
          this.showselectpackagediv = true;
        },
        
        selectPackage : function() {
          iw.log("Selected package: " + this.packageName, 3);
          this.$emit("package-selected", this.packageName);
          this.hideSelectPackageDialog();
        }
        
      }
    }
  };   
  
  iw.app.components.selectTestSuiteService = {name: 'select-test-suite-service', 
    impl: {  
      template: `
         <div style="display: inline">
           <a href="#/" v-on:click="showSelectTestSuiteServiceDialog()" >              
                <span class="glyphicon glyphicon-search " aria-hidden="true"></span>                  
           </a>
           
           <div class="modal" v-if="showselecttestsuiteservicediv" id="selecttestsuiteservicediv" v-focus>
             <div class="modal-box results-modal" v-on:keyup.esc="hideSelectTestSuiteServiceDialog()">  
               <table class="table">
                 <thead>
                   <tr>
                     <th colspan="3" class="header">Select Test Suite Service</th>
                   </tr>
                 </thead>             

                 <tbody class="high">
                  <tr>
                    <td style="width: 200px">Package</td>
                    <td>
                      <select v-model="packageName">
                        <option v-for="p in testPackages">{{p.package}}</option>
                      </select>
                    </td>
                  </tr>
                 </tbody>
                 
                 <tbody class="high">
                  <tr>
                    <td>Test Suite Service</td>
                    <td>
                      <select v-model="testSuiteServiceName">
                        <option v-for="ts in testSuiteServices">{{ts.name}}</option>
                      </select>
                    </td>
                  </tr>
                 </tbody>
               </table>
               
               <table class="table">
                 <tfoot class="high">
                   <tr>
                     <th colspan="3" class="header">
                       <button class="btn" type="submit" v-on:click="selectTestSuiteService()">
                         <span class="glyphicon glyphicon-ok"></span> Select</button>                    
                       <button class="btn" type="submit" v-on:click="hideSelectTestSuiteServiceDialog()">
                         <span class="glyphicon glyphicon-remove"></span> Cancel</button>
                      </th>
                   </tr>
                 </tfoot>                   
               </table>
             </div>
           </div>      
         </div>
        `,
      props: [],
      
      emits: ['test-suite-service-selected'],
      
      data : function () {      
        iw.log("Initializing 'select-test-suite-service'-component", 3);
        return {
          showselecttestsuiteservicediv : false,
          testPackages                  : [],
          packageName                   : null,
          testSuiteServiceName          : null,
          testSuiteName                 : null
        }
      },
      computed : {
        
        testSuiteServices : function() {
          let selectedPackage = this.packageName;
          iw.log("Computing list of test suite services; this.packageName: " + selectedPackage, 3);             
          if(selectedPackage === null){
            return []; 
          } else {
            return this.testPackages.filter(function(tp){return tp['package'] === selectedPackage})[0]["test-suite-service"];
          }            
        } 
      },
      
      methods: {
        listTestSuiteServices : function() {
          let self = this;
          iw.invoke("iw.test.ui.testsuite:list", {}, function(data) {
            self.testPackages = data["test-packages"]
            iw.log("Retrieved list with test suite services", 3);  
            //If the list contains one or more entries, then initialize packageName to the name of the first entry
            self.packageName = self.testPackages.length > 0 ? self.testPackages[0]["package"] : "";
          });  
        },
        
        hideSelectTestSuiteServiceDialog : function() {
          this.showselecttestsuiteservicediv = false;
        },
        
        showSelectTestSuiteServiceDialog : function() {
          this.listTestSuiteServices();
          this.showselecttestsuiteservicediv = true;
        },
        
        selectTestSuiteService : function() {
          iw.log("Selected test suite service: " + this.testSuiteServiceName, 3);
          let selectedTestSuiteService = this.testSuiteServiceName;
          let testSuiteName = this.testSuiteServices.filter(function(svc){return svc.name === selectedTestSuiteService })[0]['test-suite-name'];
          this.$emit("test-suite-service-selected", {"package": this.packageName, "service": this.testSuiteServiceName, "testSuiteName" : testSuiteName});
          this.hideSelectTestSuiteServiceDialog();
        }
        
      }
    }
  };
  
})(this, undefined);
