
(function(window, undefined) {
         
  if(window.iw === undefined) window.iw = {};
 
  iw.coverageApp = Vue.createApp({
      created() {
        //This piece of logic serves to decode the url:
        //split the query string into parameters and values
        let uri = window.location.href.split('?');
        if (uri.length == 2) {
          let vars = uri[1].split('&');
          let getVars = {};
          let tmp = '';
          vars.forEach(function(v){
            tmp = v.split('=');
            if(tmp.length == 2)
            getVars[tmp[0]] = decodeURIComponent((tmp[1] + '').replace(/\+/g, '%20'));
          });
          this.queryParams = getVars;
        }
      },

      el: '#coverage-app',

      data : function() {
        return {
          showCoverage              : false,
          coverageSupported         : false,
          defaultRefreshInterval    : 2000,  //in milliseconds
          message                   : "",
          success                   : true,
          config                    : {},
          info                      : {
            product                 : {},
            license                 : {
              expired               : false,
              valid                 : true
            },
          },
          offline                   : false,
          packageServiceCoverage    : {},
          coverageInfo              : {
            executionItem           : []
          },
          coverageSummary           : {},
          servicesExpansionList     : [],
          source                    : "latest-session"
        }
      },

    methods : {      
      //Use this function for showing the result of actions, not for data retrieval
      response :function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(data, 4);
         iw.coverage.showMessage(data["$message"], data["$success"] === "true" , 2500);
         iw.coverage.success = data["$success"] === "true" ? true : false;
      },
 
      error : function(msg) { 
        iw.coverage.showMessage(msg, false , 2500);       
      },      
      
      showMessage : function(msg, success, timeout) {  
         iw.coverage.message = msg;
         iw.coverage.success = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.coverage.message=""}, timeout);

         }
      },
      
      hideMessage : function() {
         iw.coverage.message = "";
      },
      
      getConfig : function() {
         if(!iw.coverage.offline) { 
           iw.invoke("iw.test.config:get", {}, function(data) {
              iw.coverage.config = data;    
           }, iw.coverage.error);
         }
         if(iw.coverage.showCoverage === false) iw.coverage.showCoverage = true;
      },
      
      getInfo : function() {
         if(!iw.coverage.offline) { 
           iw.invoke("iw.test.admin:info", {}, function(data) {
              iw.coverage.info    = data;
           }, iw.coverage.error);
         }
      },
      	
    getCoverageInfo : function() {

      iw.log("Get coverage info called. Source: " + this.source, 3);
      if(window.coverageData) {
      } else {
        let params = {"which"  : this.source};
          iw.invoke("iw.test.ui.coverage:getReport", params, function(data) {
          iw.coverage.coverageInfo    = Object.freeze(data["coverage-info"]);
          iw.coverage.coverageSummary = Object.freeze(data["coverage-summary"]);
          if(iw.coverage.coverageInfo !== null) {
            iw.coverage.coverageSupported = true;
            iw.log("Coverage info retrieved from server", 3); 
          } 
        }, iw.coverage.error);
      }
    },

    calculatePercentage : function(counter, nominator) {
        if(counter < 0) counter = 0;
        let result =  Math.round(1000 * (counter / nominator)) / 10;
        //iw.log("Calculate percentage: counter = " + counter + "; nominator = " + nominator + "; result: " + result, 3);
        return result;
    },

    foo : function() {
      iw.log("foo is called", 3);
    },

    toggleServiceVisibility : function(name) {
        iw.log("Toggle visibility package ["+name+"]", 3);
        iw.coverage.servicesExpansionList[name] = !iw.coverage.servicesExpansionList[name];
    },

    drawServiceStats : function() {
       
    }

  }		

  });
  
  iw.coverageApp.component("iwtree-instruction", {
     template: "#iwtree-instruction-template",
     props: {
        instruction: Object,
        index      : Number
     },
     data: function() {
       return {
         isOpen: true
       }
     },
     computed: {
       hasChildren : function() {
         return this.instruction.executionItem !== undefined;
       },
       missedPaths : function () {
         return this.instruction.numberOfChildren - this.instruction.numberOfExecutedChildren;
       },
       percentage    : function () {
         return Math.round(this.instruction.numberOfExecutedChildren * 1000 / this.instruction.numberOfChildren) / 10 ;
       }
     },
     methods: {
      toggle: function () {
        this.isOpen = !this.isOpen
      }
     }
   
   });
     
  //register the global directives
  iw.coverageApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.coverageApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.coverageApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.coverageApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  iw.coverageApp.component(iw.app.components.selectService.name,      iw.app.components.selectService.impl);
  iw.coverageApp.component(iw.app.components.selectServiceModal.name, iw.app.components.selectServiceModal.impl);
  iw.coverageApp.component(iw.app.components.selectFile.name,         iw.app.components.selectFile.impl);
  
  iw.coverage = iw.coverageApp.mount("#coverage-app");
   if(window.coverageData) {
     let staticCoverageData      = window.coverageData;
     iw.coverage.coverageInfo    = Object.freeze(staticCoverageData["coverage-info"]);
     iw.coverage.coverageSummary = Object.freeze(staticCoverageData["coverage-summary"]);
     iw.coverage.offline         = true;
     iw.coverage.showCoverage    = true;
   } else { 
     iw.coverage.getInfo();    
     iw.coverage.getConfig(); 
     iw.coverage.getCoverageInfo();
   }
   
})(this, undefined);
      
