"use strict";
(function(window, undefined) {
        
  iw.environmentApp = Vue.createApp({
    
    data : function() {
      return {
        message                     : "",
        success                     : true,
        aliases                     : [],
        agents                      : [],
        environments                : [],
        serverAliases               : [],
        //availableAliases: [],
        alias: "",
    
        info                        : {        },
        config                      : {},
                                    
        environmentToggle           : true,
        environment                 : "",
                                    
        showEnvironment             : false,
                                    
        showenvironmentaliasdiv     : false,
        currentEnvironmentName      : "",
        availableEnvironmentAliases : [],
        environmentAlias            : ""
      }
    },
    
    computed: {
      availableAliases : function() {
          var difference = [];
          var found = false
          
          for (let i = 0 ; i < this.serverAliases.length ; i++) {
             found = false;
             
             for (let j = 0 ; j < this.aliases.length ; j++ ) {
          
                 if(this.aliases[j] === this.serverAliases[i] ) {                   
                     found = true;            
                     break;
                 }
             }
             if(!found && this.serverAliases[i].indexOf("local") < 0 ) {
                 difference.push(iw.environment.serverAliases[i]);
             }
          }        
        return difference;
      }      
    },
      
    methods : {
     
      response :function(data) {
        //console.log("Logging response from IS");
        //console.log(data);
        let timeout = data["$success"] === "true" ? 3000 : 5000;
        iw.environment.showMessage(data["$message"], data["$success"], timeout);
        iw.environment.success = data["$success"] === "true" ? true : false;
      },
      
      showMessage : function(msg, success, timeout) {  
        if(msg) iw.environment.message = msg;
        iw.environment.success = success;
        if(typeof(timeout) === "number") {
           setTimeout(function(){iw.environment.message=""}, timeout);
        }
      },
     
      hideMessage : function() {
         iw.environment.message = "";
      },        

      getConfiguration  : function(show) {
        this.getSettings(show);
        this.getAgents();
        this.getEnvironments();     
        this.getInfo();
      }, 

      getInfo : function() {
       iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.environment.info = data
        }, iw.environment.error);
      },

      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.environment.config = data;          
        });        
      },    
      
      getSettings : function(show) {
        iw.invoke("iw.test.config:get", {}, function(data) {
          
           iw.environment.config = data;
           iw.environment.dirty = false;
           iw.environment.distributedDirty = false;
           
           iw.environment.listServerAliases();   
           if(show) {
             iw.environment.showEnvironment = true;
           }
           iw.log("Configuration loaded", 3)
                      
        });
      },

      getAgents : function() {
        iw.invoke("iw.test.ui.config:get", {}, function(data){
          iw.environment.agents = data.agents.sort(function(a,b){ if(a.$alias >= b.$alias) return 1; else return -1});;
          iw.log("Agent Configuration loaded", 3)
        
        });
      },

      getEnvironments : function() {
        iw.invoke("iw.test.environment:list", {}, function(data){
          iw.environment.environments = data.environments.sort(function(a,b){ if(a.name >= b.name) return 1; else return -1})
          //Sort the aliases in each environment
          iw.environment.environments.map(function(a){
            a.aliases.sort(function(a,b){ if(a >= b) return 1; else return -1   })
            //return a
          });            
          
          iw.log("Environments Configuration loaded", 3)
        
        });
      },

      saveConfiguration : function() {
          iw.invoke("iw.test.config:set", iw.environment.config, function(data){            
            iw.environment.response(data);
            iw.environment.getSettings();
          });
          iw.environment.dirty = false;
          iw.environment.distributedDirty = false;
      },
    
      listAliases: function() {
          iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.environment.aliases = data.aliases.map(function(a){return a.split(":")[0]}).sort(function(a,b){ if(a >= b) return 1; else return -1   });   
          });
      },
    
      addAlias: function(alias) {
          if(alias !== "" ) {
            iw.invoke("iw.test.alias:add", {"alias": alias}, function(data){               
              iw.environment.response(data);
              iw.environment.getAgents();
              iw.environment.listAliases();
        
            });
          }
          iw.environment.alias = "";
      },
    
      removeAlias: function(al) {
          iw.invoke("iw.test.alias:remove", {"alias": al},  function(data){ 
            iw.environment.response(data);
            iw.environment.getAgents();
            iw.environment.getEnvironments();
            iw.environment.listAliases();
          });        
      },		
      
      showEnvironmentAgentDialog(envName) {

        this.currentEnvironmentName = envName;
        //lookup the environment object based on the name
        let env = this.environments.filter(function(e){
           return e.name === envName          
        })[0]

        if(env) {
          let currentAgents = env.aliases
          
          this.availableEnvironmentAliases = this.aliases.filter(function(alias){
            return !currentAgents.includes(alias)
          });
          this.showenvironmentaliasdiv = true;
        
        } else {
          //show error message
        }
      },
      
      hideEnvironmentAgentDialog() {
        this.showenvironmentaliasdiv = false;
      },        
      
      addEnvironment: function(env) {
          if(env !== "") {
            iw.invoke("iw.test.environment:add", {"environment": env}, function(data){              
              iw.environment.response(data)
              iw.environment.getEnvironments();
            });
            iw.environment.environment = "";
          }
      },
      
      removeEnvironment: function(env) {
          if(env !== "") {
            iw.invoke("iw.test.environment:remove", {"environment": env}, function(data){              
              iw.environment.response(data)
              iw.environment.getEnvironments();
            });
            iw.environment.environment = "";
          }
      
      },
      
      addEnvironmentAlias(env, alias) {
        iw.invoke("iw.test.environment:addAlias", {"environment": env, "alias": alias}, function(data){              
          iw.environment.response(data)
          iw.environment.getEnvironments();
        });
        this.hideEnvironmentAgentDialog();
      },
      
      removeEnvironmentAlias(env, alias) {
        iw.invoke("iw.test.environment:removeAlias", {"environment": env, "alias": alias}, function(data){              
            iw.environment.response(data)
            iw.environment.getEnvironments();
        });
      },
      
      listServerAliases: function() {
        iw.invoke("wm.server.remote:getServerAliases", {}, function(data) {
          iw.environment.serverAliases = data.servers;              
          iw.environment.listAliases();
        }); 
      }, 
      
      updateCentralAlias: function (centralAlias, remoteAlias) {
        var param = {"alias" : remoteAlias + ":" + centralAlias};
        iw.invoke("iw.test.alias:add", param, function(data){  
          //iw.environment.response(data)
          iw.environment.getAgents();
        });
      },
      
      installAgent: function (remoteAlias) {
        var param = {"$alias" : remoteAlias};
        iw.invoke("iw.test.admin:installAgent", param, function(data){              
          iw.environment.response(data)
          iw.environment.getAgents();
        });
        
      }
    }
      
  });
  
  //register the global directives
  iw.environmentApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.environmentApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.environmentApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.environmentApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
    
  iw.environment = iw.environmentApp.mount('#config-app');
  
  iw.environment.getConfiguration(true);

})(this, undefined);
