"use strict";

(function(window, undefined) {

  if(window.iw === undefined) window.iw = {};
   
  iw.indexApp = Vue.createApp({
    el: '#index',
    data : function() {
      return {
        showIndex : false,
        info : {},
        
        config : {}
      }
    },
    methods : {
      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.index.info = data;          
        });
      },
    
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.index.config    = data;
          iw.index.showIndex = true;
        });        
      },      
    }
   });
   
  //register the global directives
  iw.indexApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.indexApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);

  iw.index = iw.indexApp.mount("#index");
   
  iw.index.getInfo();   
  iw.index.getConfig();
   
})(this, undefined);