"use strict";
(function(window, undefined) {
         
  if(window.iw === undefined) window.iw = {};  
  
  iw.eventSources = {},
  
  //Close all event source before navigating away:
  window.onbeforeunload = function() {
    for(let alias in iw.eventSources) {
      iw.eventSources[alias].close();
      iw.log("Closed event source for alias " + alias, 3);
    }
  }
  
  iw.recordApp = Vue.createApp({
      created() {       
      },
     
      computed: {
        messageLink: function() {
          if(this.lastCreatedTestSuite == null) {
            return null;
          } else {
            return 'testsuites.html?testSuiteServiceName=' + this.lastCreatedTestSuite;
          }
        },
        recordedServiceData : function() {
         /* This structure contains a subset of the state of a server (via alias) and service
         recordedServiceData    : {
                                   alias: "(local)",
                                   name: "",
                                   exists: false,
                                   package: "",
                                   active: false,
                                   stubs: [],
                                   runs: []
                                },
         */
          //Filter on alias and service name. Should yield a match
          let filteredData = iw.record.servers[iw.record.alias]?.services.filter(function(service){return service.name === iw.record.serviceName})[0];
          //Add the alias, for completeness
          if(filteredData !== null) filteredData.alias = iw.record.alias;
          return filteredData;
        }
      },

    data : function() {
      return {
        showRecord                    : false,
        confirm                   : {
          question                : null,
          showconfirmationdialog  : false,
          confirmAction           : function(){}
        },
        defaultRefreshInterval        : 2000,  //in milliseconds
        message                       : "",        
        lastCreatedTestSuite          : null,
        config                        : {},
        info                          : {
          license                     : {
             product                  : "IwTest",
             version                  : "1.*",
             licensee                 : "",
             type                     : "",
             "valid-until"            : "",
             "valid-until-ts"         : -1,
             valid                    : true,
             expired                  : false,
             "version-ok"             : true,
             "days-left"              : -1
          },                          
          product :  {                
            name                      : "",
            version                   : "",
            "latest-version"          : "",
            "latest-check-date"       : "",
            "installation-date"       : "",
            "installation-ts"         : 0
          },                          
        },                            
        showrecorddialog              : false,
        showgeneratedialog            : false,
        showrecordedservices          : false,
        showrundata                   : false,
        showservicerundiv             : false,
        showexecutediv                : false,
        showinputoutputtable          : false,
        showresultseditor             : false,
        isdirtypipeline               : false,
        serviceToExecute              : null,
        inputSchema                   : null,
        outputSchema                  : null,
        generateMinimal               : true,
        generateOnlyStructure         : true,
        generateNumberOfArrayElements : 1,
        executeResult                 : null,
        executeInputValidation        : true,
        executeOutputValidation       : false,
        executeAlias                  : null,
        success                       : true,
        alias                         : "",
        availableAliases              : [],
        packageName                   : "",
        localPackages                 : [],
        enabledLocalPackages          : [],
        packages                      : [],
        serviceName                   : "",
        services                      : [],
        filteredServices              : [],
        servicesText                  : "",
        selected                      : false,
        referencedServices            : [],
        filteredReferencedServices    : [],
        stubbedServices               : [],
        recordedRunData               : {},
        servers                       : {}, // 
        /*
          {"alias1" : {"test-runs-current" : 0,
                       "test-runs-max"     : 0,
                       "max-reached"       : false,
                       "services"          :                       
                         [
                           { "name"  : "service1",
                             "exists"  : true,
                             "package" : "SAMPLE",
                             "active"  : true,                             
                             "stubs"   : ["stub1", "stub2"],
                             "runs"    : [{
                               "id"    : "wioufqwjopeifujh",
                               "date-recorded" : ""
                             }]
                            }                         
                         ]
                       }
          }
        */
        generateParams         : {
            alias                     : "",
            serviceName               : "",
            remoteThisAlias           : "",
            testSuiteServiceName      : "",
            targetPackage             : "",
            testSuiteName             : "",
            mode                      : "",
        },
        generateDefaultPackage        : "",
        generateDefaultService        : "",
        generateServiceMessage        : "",
        targetTestSuiteServiceExists  : false,
        targetPackageExists           : false,
        selectedRecordedInputOutput   : null
      }
    },
     
    methods : {      
      addRemoveStubbedService : function(item) {
        iw.log("Add/Remove Stubbed Service called", 3);
        iw.log(item, 4);
        iw.log(event, 4)
        if(event.srcElement.checked) {
          iw.log("Added " + item.service + " to stubbed services", 3);
          iw.record.stubbedServices.push(item.service);
        } else {
          iw.log("Removed" + item.service + " form stubbed services", 3);
          iw.record.stubbedServices = iw.record.stubbedServices.filter(s => {return s !== item.service})
        }
      },
      //Use this function for showing the result of actions, not for data retrieval
      response :function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(data, 4);
         iw.record.showMessage(data["$message"], data["$success"] === "true" , 2500);
      },
 
      error : function(msg) { 
        iw.log(msg, 0);
        iw.record.showMessage(msg, false , 2500);       
      },      
            
      showMessage : function(msg, success, timeout) {  
         iw.record.message     = msg;
         iw.record.success     = success;
         if(typeof(timeout) === "number") {
            setTimeout(function(){iw.record.message=""}, timeout);
         }
      },
      
      hideMessage : function() {
         iw.record.message     = "";
      },
      
      getInfo : function() {
         iw.invoke("iw.test.admin:info", {}, function(data) {
            iw.record.info = data;            
         }, iw.record.error);
      },
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.record.config = data;    
          iw.record.listAliases();
          iw.record.listPackages();
          
          //Open the record dialog if a service is supplied in the query parameters of the url
          if(iw.queryParams.service) {
           iw.record.showRecordInput(iw.queryParams.service, '', [], iw.localAlias);
          }
          
          //Open the execute service dialog if a service to execute is supplied in the query paramaters of the url
          if(iw.queryParams.execute) {
            iw.record.showExecuteDialog(iw.queryParams.execute, iw.queryParams.alias);
          }
          
          iw.record.showRecord = true;
        }, iw.record.error);
      },
      
      getSession : function() {
         iw.invoke("pub.flow:getSession", {}, function(data) {
            iw.record.lastCreatedTestSuite  = data.$session["last-created-test-suite-service-name"];            
         }, iw.record.error);
      },        
      
        
      listAliases: function() {
        if(iw.record.config["ui.distributed.enabled"] === "false") {

            iw.record.availableAliases = [iw.localAlias];         
            iw.record.servers[iw.localAlias] = {};
            iw.record.servers[iw.localAlias].expanded = true;
            iw.record.getRecordingState(iw.localAlias); 
        } else {
          iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.record.availableAliases = data.aliases.map(function(a){return a.split(":")[0]});
            iw.record.availableAliases.unshift(iw.localAlias );
            //iw.record.getConfig();
            for(let i = 0; i < iw.record.availableAliases.length ; i++ ) {              
              iw.record.servers[iw.record.availableAliases[i]] = {};
              if(iw.record.availableAliases[i] === iw.localAlias) {
                iw.record.servers[iw.localAlias].expanded = true;
              }  
              iw.record.getRecordingState(iw.record.availableAliases[i]);                            
            }
            
         }, iw.record.error);         
        }

    },
    
    listPackages : function(alias, showRecordPanel) {
       let params = {"$alias": alias};
       iw.invoke("iw.test.ui.ns:listPackages", params, function(data) {
          iw.log("Retrieved packages for " + alias, 3);

            iw.record.packages = data.packages.filter(function(a){                 
                 return a.enabled === "true" && a["system-package"] !== "true";
            }).sort(function(a,b){ if(a.name >= b.name) return 1; else return -1});
            
            if(alias === undefined || alias === '' || alias === 'local' || alias === '(local)') {
                iw.record.localPackages = data.packages.sort(function(a,b){if(a.name >= b.name) return 1; else return -1});              
                iw.record.enabledLocalPackages = data.packages.filter(a => a.enabled === "true" && a["system-package"] !== "true").
                   sort(function(a,b){if(a.name >= b.name) return 1; else return -1});              
              }    
           
            if(showRecordPanel) iw.record.showrecorddialog = true
         }, iw.record.error);
    },
    
    clearServices : function() {
       iw.record.selected = false;
       iw.record.referencedServices = [];
       iw.record.filteredReferencedServices = [];
    },
    
    listReferencedServices: function(serviceName) {
        iw.record.serviceName = serviceName;
        iw.log("Retrieving referenced services for: "+ serviceName, 3);
        let params = {"service-name" : serviceName, "$alias" : iw.record.alias};
        iw.log(params, 3);
        iw.invoke("iw.test.ui.ns:getReferencedServices", params, function(data) {
            iw.log(data, 4);
            iw.record.referencedServices = data.references;
            iw.record.filteredReferencedServices = data["filtered-references"];
        }, iw.record.error);        
    },
    
    hideRecordInput : function() {
        iw.record.showrecorddialog = false;
        iw.record.packageName = "";
        iw.record.filteredServices = [];
    },
  
    showRecordInput : function(serviceName, packageName, stubs, alias) {
       iw.log("Showing record input; serviceName: " + serviceName + "; packageName: " + packageName + "; alias: " + alias, 3);
       iw.record.packageName = packageName;
       iw.record.serviceName = serviceName;
       iw.record.stubbedServices = stubs;
       iw.record.alias = alias;
       iw.record.listPackages(alias, true);            //iw.record.showrecorddialog = true;      
       iw.record.listReferencedServices(serviceName);   
    },    
    
    hideExecuteDialog : function() {
      iw.record.showexecutediv = false;
      iw.record.serviceToExecute = null;
      iw.peditor = null;
      iw.reditor = null;
    },
    
    showExecuteDialog : function(serviceToExecute, alias) {
      iw.log("[show-execute-dialog] service: "+ serviceToExecute + "; alias: [" + alias + "]; type: " + typeof(alias), 3);
      iw.record.serviceToExecute = serviceToExecute;
      
      if(iw.record.config["ui.distributed.enabled"] === "true" && typeof(alias) === "string") {        
        iw.record.executeAlias     = alias;
      }
      
      iw.record.listPackages(iw.record.executeAlias, false);
      iw.record.showexecutediv = true;

      if(serviceToExecute !== undefined && serviceToExecute !== null) {
        //This is necessary for Vue to create the #pipelineeditor
        this.$nextTick(() => {
          this.serviceToExecuteChanged(serviceToExecute, true)
         })         
      }
    },

    serviceToExecuteChanged : function(serviceToExecute, generateData) {
       this.serviceToExecute = serviceToExecute; 
      if(iw.peditor === undefined || iw.peditor === null) {
          iw.peditor = this.createJSONEditor("pipelineeditor", function(){iw.record.isdirtypipeline = true}, true)
          iw.log("Created input JSON editor", 3);
      }
      if(iw.reditor === undefined || iw.reditor === null) {
          iw.reditor = this.createJSONEditor("resultseditor", function(){}, false)
          iw.log("Created output JSON editor", 3);
      }
      
      this.executeResult = null;
      
      if(typeof(serviceToExecute) === "undefined" || serviceToExecute === null || serviceToExecute === "") {
         this.showinputoutputtable = false      
      } else { 
        iw.record.setJSONSchema(generateData);
        this.showinputoutputtable = true      
      }
    },
    
    createJSONEditor: function(elementName, onChangeFunction, editable) {
       let container = document.getElementById(elementName);
       let options = { modes:["tree","code","text"],
                            enableTransform: false,
                            onChange: onChangeFunction,
                            onEditable: function(){return editable},
                            onClassName: function(c) {
                              //iw.log("on-class-name: " + c.path + " " + c.field + " " + c.value, 3)
                            }
                          }
       let jeditor = new JSONEditor(container, options);
       jeditor.setName("pipeline");
       jeditor.set({});
       return jeditor
    },
    
    createXMLEditor: function() {
       //if(iw.xmleditor === undefined) {
             iw.xmleditor = JSONEditor.ace.edit("xmleditor");
             iw.xmleditor.getSession().setMode("ace/mode/xml"); 
             iw.xmleditor.setReadOnly(true);
       //   }
    },
    
    setJSONSchema: function(generateData) {
      iw.log("Set schema called for : " + iw.record.serviceToExecute + "; generateData: " + generateData, 3);

      let pipeline = {
        "nodeName"                      : iw.record.serviceToExecute,
        "generate-minimal"              : iw.record.generateMinimal,
        "generate-only-structure"       : iw.record.generateOnlyStructure,
        "generate-nr-of-array-elements" : iw.record.generateNumberOfArrayElements,
        $alias                          : iw.record.executeAlias
      };

      iw.invoke("iw.test.ui.schema:get", pipeline,
        function(data) {
          if(data.$success === "true") {
            delete(data.$alias)
            iw.record.inputSchema  = data["input-schema"]
            iw.record.outputSchema = data["output-schema"]
            if(generateData === true) {
               iw.peditor.set(data['sample-input-data']);
               iw.reditor.set({});
            }
            if(iw.record.executeInputValidation) {
               iw.peditor.setSchema(iw.record.inputSchema);
            }
            if(iw.record.executeOutputValidation) {
               iw.peditor.setSchema(iw.record.OutputSchema);
            }
            iw.log("Set schema for: " + iw.record.serviceToExecute, 3)
          } else {
            iw.record.error(data.$message);
          }
       },
       iw.record.error)
    },

    toggleInputValidation: function() {
       if(iw.record.executeInputValidation) {
          iw.peditor.setSchema(iw.record.inputSchema)
       } else {
          iw.peditor.setSchema(null)
       }
       iw.log("Toggle Input Validation: " + iw.record.executeInputValidation, 3);
    },

    toggleOutputValidation: function() {
       if(iw.record.executeOutputValidation) {
          iw.reditor.setSchema(iw.record.outputSchema)
       } else {
          iw.reditor.setSchema(null)
       }
       iw.log("Toggle Output Validation: " + iw.record.executeOutputValidation, 3);
    },
    
    executeService: function() {
        let pipeline         = iw.peditor.get();
        let isLocalExecution = true;
        let se               = iw.record.serviceToExecute;
        let params           = pipeline;
        if(pipeline === null) pipeline = {}; 

        if(iw.record.config["ui.distributed.enabled"] === "true" && iw.record.executeAlias !== null && iw.record.executeAlias !== "" && !iw.record.executeAlias.includes('(local)')) {
            pipeline.$alias  = iw.record.executeAlias;   
            isLocalExecution = false;
            se               = "iw.test.execution.util:invoke"
   
            params = {
               pipeline: pipeline,
               service: iw.record.serviceToExecute
            }
        }
        iw.log("Executing " + iw.record.serviceToExecute + "; is local execution: " + isLocalExecution, 3); 
        iw.invoke(se, params, function(data){
            iw.record.executeResult = data;

            if(!isLocalExecution && data.pipeline){ 
              delete(data.pipeline.$alias)
              iw.reditor.set(data.pipeline);
            } else {
              iw.reditor.set(data)
            }
        },
        function(msg, contentType, data ){
            delete(data.$errorInfo?.$pipeline?.pipeline?.$alias)
            iw.record.executeResult = data.$errorInfo;
            iw.reditor.set(data.$errorInfo);
        })
        
    
    },
    
    startServiceRecording : function(alias) {
         iw.log("Starting service recording for " + iw.record.serviceName, 3);
          let params = {"$alias": alias, "service": iw.record.serviceName, "stubs": iw.record.stubbedServices};
        iw.invoke("iw.test.ui.record:on", params, function(data){
          iw.record.response(data);
        
          if(iw.record.servers[alias].status.enabled !== "true") {
            iw.record.startRecordingAgent(alias);
          } else {
            iw.record.getRecordingState(alias); 
          }
          
          //Reset the state 
          iw.record.serviceName                = "";
          iw.record.stubbedServices            = [];
          iw.record.filteredServices           = [];
          iw.record.servicesText               = "";
          iw.record.selected                   = false;
          iw.record.referencedServices         = [];
          iw.record.filteredReferencedServices = [];
          iw.record.showrecorddialog           = false;
        }, iw.record.error);

    },
    
    stopServiceRecording : function(alias, serviceName) {
      
      let isActive = iw.record.servers[alias].services.filter(function(s){return s.name === serviceName && s.active === true}).length > 0;
      
      if(isActive === true) {
        iw.log("Stopping service recording for " + serviceName + " on " + alias, 3);
        let params = {"$alias" : alias, "service": serviceName};
        iw.invoke("iw.test.ui.record:off", params, function(data){
            iw.record.response(data)
            //Refresh the table 
            iw.record.getRecordingState(alias); 

        }, iw.record.error);
      } else {
         iw.log("Not stopping service recording for " + serviceName + " on " + alias + ": already stopped", 3);
      }
        
    },
    
    deleteRecordedData : function(serviceName, active, n, alias) {
      let params = {"$alias" : alias, "service-name" : serviceName, "is-running" : active};

      iw.record.confirm.question = "Are you sure you want to delete " + n + " recorded runs?";              
      
      iw.record.confirm.confirmAction = function() {
        iw.invoke("iw.test.ui.testrun:remove", params, function(data){
            iw.record.response(data);
            iw.log("[delete recorded data] server: " + alias + "; service: " + serviceName + "; iw.record.servers[" + alias+ "].status.enabled: " + iw.record.servers[alias].status.enabled, 3)    
                  
            //Refresh the table only for the non-local aliases. The local one got updated by the 'record-event'
            if(alias !== iw.localAlias) iw.record.getRecordingState(alias); 

        }, iw.record.error);
      };
      
      iw.record.confirm.showconfirmationdialog = true;
        
    },    
    
    startGetRecordingState : function(alias) {
      //For the local instance register an SSE event listener
      if(alias === iw.localAlias) {
        iw.record.registerRecordEventListener(alias);        
      } else {     
      
         let refreshInterval = Number(iw.record.config["record.sample.interval.ms"]);
         let id = iw.record.servers[alias]["scheduled-service-id"];
         
         if(id == undefined) {
           if(iw.record.servers[alias].expanded) {
             if(refreshInterval < iw.record.defaultRefreshInterval) refreshInterval = iw.record.defaultRefreshInterval;
             iw.record.getRecordingState(alias);
             id = window.setInterval(function() {iw.record.getRecordingState(alias)}, refreshInterval);
             iw.record.servers[alias]["scheduled-service-id"] = id;
             iw.log("Scheduled 'getRecordingState()'; alias: " + alias + "; id: " + id + "; interval: " + refreshInterval, 3);
           } else {
             iw.log("Not scheduled getRecordingState() for alias " + alias + ": not expanded");
           }
        } else {
          iw.log("'getRecordingState()' for alias " + alias + " is already running. id: " + id, 3)
        }
      }
    },
    
    stopGetRecordingState: function(alias) {
       let id = iw.record.servers[alias]["scheduled-service-id"];
      
       window.clearInterval(id);
       delete(iw.record.servers[alias]["scheduled-service-id"]); 
       iw.log("Unscheduled 'getRecordingState()'; alias: " + alias + "; id: " + id, 3);
    },    
    
    startRecordingAgent : function(alias) {
       
       iw.log("Starting recording on :'" + alias + "'", 3);
       let params = {"$alias" : alias};
       iw.invoke("iw.test.ui.record:enable", params, iw.record.response, iw.record.error);
       iw.record.startGetRecordingState(alias);
    },  
    
    stopRecordingAgent : function(alias) {
       iw.log("Stopping recording on :'" + alias + "'", 3);
       let params = {"$alias" : alias};
       iw.invoke("iw.test.ui.record:disable", params, iw.record.response, iw.record.error);  
       iw.record.stopGetRecordingState(alias);
       iw.record.getRecordingState(alias);
    },
    
    registerRecordEventListener : function(alias) {
      if(typeof(alias) === "undefined" || alias === null) {
        iw.log("Cannot register listener: alias is not provided", 1);
        return;
      }
      if(typeof(iw.eventSources[alias]) !== "undefined") {
        iw.log("Event listener for "+ alias +" already defined", 3);
        return;
      }
      let recordEvent = "record-event";
      let statusEvent = "status-event"; 
      let eventTypes  = "eventTypes=" + recordEvent + "," + statusEvent;
      //Compose the url:
      let url = "/invoke/iw.test.agent.sse/subscribe";
      //Add the alias, if we're not connecting to the local IS:
      if(alias !== iw.localAlias) url += "?alias=" + alias;      
      //Add the event types, in order to prevent that we receive other events
      if(alias === iw.localAlias) { 
        url += "?" + eventTypes;
      } else {
        url += "&" + eventTypes;
      }
           
      let evtSource   = new EventSource(url) ;
      
      //Collect in eventSources, so they can be properly closed when the user navigates away.
      iw.eventSources[alias] = evtSource;
      
      //An event listener for a 'record' event
      evtSource.addEventListener(recordEvent, function(event) {      
        let data = JSON.parse(event.data)
        iw.log("[event][" + alias + "] type: " + event.type, 3);        
        
        //The properties have to set one by one, because there may be other properties presnet.
        iw.record.servers[alias]["test-runs-max"]     = data["test-runs-max"];
        iw.record.servers[alias]["test-runs-current"] = data["test-runs-current"];
        iw.record.servers[alias]["max-reached"]       = data["max-reached"];
             
        iw.record.servers[alias].status               = data.status;
        iw.record.servers[alias].services             = data.services;
      });  

      //An event listener for a 'status' event
      evtSource.addEventListener(statusEvent, function(event) {
         let data = JSON.parse(event.data)
         iw.log("[event][" + alias + "] type: " + event.type, 3);        
         iw.record.servers[alias].status               = data.status;
      });
      
    },
    
    getRecordingState : function(alias) {
      if(iw.record.info.license?.valid === false) {            
        return;
      }
      
      let params = {};
      if(alias !== undefined) {
         params = {"$alias": alias};
      }
      iw.log("Calling 'getRecordingState'; alias: " + alias, 3);
      iw.invoke("iw.test.ui.testrun:list", params, function(data) {    
           
        if(data.$success === 'false') {                                 
           iw.record.servers[data.$alias].available = false;
           iw.record.servers[data.$alias]["error-message"] = data.$message;
           //Remove this alias from the available aliases, but only if it's in the list
           if(iw.record.availableAliases.includes(alias)) {
            iw.record.availableAliases = iw.record.availableAliases.filter(a => {a !== alias});
           }
         } else {
           //Add this alias to the available aliases, but only if it's *not* in the list
           if(!iw.record.availableAliases.includes(alias)) {
            iw.record.availableAliases.push(alias);
            iw.record.availableAliases.sort();
           }
           
           iw.record.servers[data.$alias].available = true;                   
           iw.record.servers[data.$alias].services = data.services;
                                
           //'status' is a new field since v1.8.7
           if(data.status) {
             iw.record.servers[data.$alias]["test-runs-max"]     = data["test-runs-max"];
             iw.record.servers[data.$alias]["test-runs-current"] = data["test-runs-current"];
             iw.record.servers[data.$alias]["max-reached"]       = data["max-reached"];
             
             iw.record.servers[data.$alias].status               = data.status;             
             
             if(data.status.running === "true" && iw.record.servers[data.$alias]["scheduled-service-id"] === undefined) {
                  iw.record.startGetRecordingState(data.$alias);
             }
                        
             //Structure:
             //  [int]     'test-runs-current' 
             //  [int]     'test-runs-max' 
             //  [boolean] 'max-reached'
             //  [doc[]]    services
             //  [doc]      status
             //    [string] running
             //    [string] enabled
             //    [string] running
           } 
        }
      }, iw.record.error);
     
    },        

    toggleExpandRecordedServices : function(alias) {
 
      iw.record.servers[alias].expanded =  !iw.record.servers[alias].expanded;  
      if(iw.record.servers[alias].expanded) {
          iw.record.startGetRecordingState(alias);
      } else {
          iw.record.stopGetRecordingState(alias);
      }
      iw.log("Toggle expansion for " + alias + "; expanded: "  + iw.record.servers[alias].expanded, 3);
      
    },  

    showGenerateInput : function(alias, serviceName, packageName) {
      let params = { "$alias": alias, "service-name" : serviceName, "package" : packageName};
      iw.log("Show Generate input: $alias: " + alias + "; serviceName: " + packageName + "/" + serviceName, 3);
      iw.invoke("iw.test.generate.service:getDefaults", params, function(data) {
        iw.log(data, 4);
        iw.log(this, 4);
        if(data["$success"] === "false") {
           iw.record.success = false;
           iw.record.message = data["$message"];
           setTimeout(function(){iw.record.message=""}, 5000);
        } else {
          iw.record.generateDefaultPackage              = packageName;
          iw.record.generateDefaultService              = serviceName  
          iw.record.generateParams.alias                = alias === "(local)" ? "" : alias;
          iw.record.generateParams.serviceName          = serviceName;
          iw.record.generateParams.remoteThisAlias      = "";
          iw.record.generateParams.targetPackage        = data.defaults["target-package"];
          iw.record.generateParams.testSuiteName        = data.defaults["test-suite-name"];
          iw.record.generateParams.testSuiteServiceName = data.defaults["test-suite-service-name"];                
          iw.record.generateParams.mode                 = data.defaults["mode"];
        
          iw.record.validateGenerateParams(iw.record.generateParams.testSuiteServiceName);
          iw.record.showgeneratedialog             = true;
            
          iw.record.stopServiceRecording(alias, serviceName);
        }
      }, iw.record.error);
    },
    
    generateTestSuite : function(generateParams) {
    
      let params = { "$alias"                  : generateParams.alias,
                     "service-name"            : generateParams.serviceName,
                     "target-package"          : generateParams.targetPackage,
                     "test-suite-name"         : generateParams.testSuiteName,
                     "test-suite-service-name" : generateParams.testSuiteServiceName,
                     "mode"                    : generateParams.mode};
      iw.log("Calling iw.test.generate.pub:generateTestSuite with these parameters:", 4)
      iw.log(params, 4)
      
      //Show a confirmation dialog if the mode = overwrite
      //First introduce the action to perform:
      iw.record.confirm.confirmAction = function(){
        iw.invoke("iw.test.generate.pub:generateTestSuite", params,  function(data){            
            iw.record.lastCreatedTestSuite = data["test-suite-service-name"];
            iw.record.showMessage(data["$message"], data["$success"] === "true", 2500);
          }, 
          iw.record.error);
        iw.record.showgeneratedialog             = false;
         
        //Refresh the table in case automatic refresh is not active
        if(iw.record.servers[generateParams.alias] && iw.record.servers[generateParams.alias].status.enabled !== "true") {
          iw.record.getRecordingState(generateParams.alias); 
        } 
      };
      
      if(generateParams.mode === "overwrite") {
        iw.record.confirm.question = "Are you sure you want to delete and recreate test suite service " + generateParams.testSuiteServiceName + "?";        
        iw.record.confirm.showconfirmationdialog = true;        
      } else {
        //Carry out the action without asking
        iw.record.confirm.confirmAction();
        //reset the confirmation stuff
        iw.record.confirm.confirmAction = function(){};
      }
      
    },        
    
    hideGenerateInput : function() {
       iw.record.showgeneratedialog = false;
    },
    
    validateGenerateParams : function(nsname) {
         if(/(\w+)(\.\w+)*(:\w+)/.test(nsname)) {
            
            let params = {"nsname" : nsname};
            iw.invoke("iw.test.ui.ns:getLocalNode" , params , function(data){
                 iw.log(data, 4);
                 if(data.node.exists === true ) {
                    iw.record.targetTestSuiteServiceExists = true;
                    iw.record.generateParams.targetPackage = data.node.package;
                    if(data.node.node_type === "service") {
                        //that's ok, reset message
                        if(data.node["is-iw-test-suite"] === true) {
                          iw.record.generateServiceMessage = "";
                        } else {
                          iw.record.generateServiceMessage = "'" + nsname + "' exists, but is not a test suite service!";                    
                        }
                    } else {
                         iw.record.generateServiceMessage = "'" + nsname + "' exists, but is not a flow service!";                    
                    }
                 } else {
                          iw.record.targetTestSuiteServiceExists = false;
                          iw.record.generateServiceMessage = "";                          
                 }
            }, iw.record.error);
       } else {
          iw.record.generateServiceMessage = "Not a valid service name";
          iw.record.targetTestSuiteServiceExists = false;
           
       }
    },
    
    packageExists : function(pkg) {
        
        return pkg && pkg.length > 0 && iw.record.localPackages.filter(function(a){return a.name === pkg}).length === 1;
    },
    
    showRecordedServiceRuns: function(alias, serviceName) {
       iw.log("[show-recorded-service-runs] alias: [" + alias +  "]; service: [" + serviceName + "]", 3);
              
       //The list with recorded runs for this service on the server that the alias points to,
       //is a subset of the information present in 'iw.record.servers':
       
       //iw.record.recordedServiceData       = iw.record.servers[alias].services.filter(function(service){return service.name === serviceName})[0];
       
       //Instead of setting it here, it's is a computed property. That also allows the list to grow automatically when new runs are recorded.
       
       iw.record.alias                     = alias;
       iw.record.serviceName               = serviceName;
       
       iw.record.showrecordedservices      =  true;       
                     
    },
    
    hideServiceRunDetails: function() {     
        if(iw.xmleditor) iw.xmleditor.getSession().setValue("" , 1);
        iw.record.showservicerundiv = false;
    },
    
    getRunDataTree: function(alias, service, index) {
      iw.log("[getRunDataTree]: alias: " + alias + "; service: " + service + "; index: " + index + "; show: " + iw.record.showservicerundiv, 3);
      if(service.length > 0) {
        let id = iw.record.recordedServiceData.runs[index].id
        let params = { "$alias": alias, "service-name" : service, "service-run-id": id, "only-tree": "true" };
        iw.invoke("iw.test.ui.testrun:get", params, function(data) {
          if(data["$success"] === "true") {
            data["service-run"].index       = index;
            iw.record.recordedRunData       = Object.freeze(data["service-run"]);   
            //iw.record.recordedRunData.index = index;
            

            //Make sure that the output/error is selected in thee 'Show run data panel'
            if(data["service-run"].error) {
              iw.record.selectedRecordedInputOutput = id + "-err";
            } else {
              iw.record.selectedRecordedInputOutput = id + "-out";
            }
            
            //load the output/error into the XML Editor
            if(data["service-run"].error) {
              iw.record.getRunPipeline(alias, iw.record.recordedRunData.error.path);
            } else {
              iw.record.getRunPipeline(alias, iw.record.recordedRunData.output.path);
            }
            
            iw.record.showservicerundiv     = true; 
          } else {
            iw.record.showMessage("No run data found for '" + service + ":"+id, false, 2500);
          }          
        }, iw.record.error);
        
      }
    },
    
    getRunPipeline: function(alias, path) {
      let params = {"$alias": alias, "file-name": path, "as": "text", "download": "false"};
      
      iw.invoke("iw.test.ui.testrun:getPipeline", params, function(data) {
          if(data["$success"] === "true") {
            
            iw.record.createXMLEditor();
            let nrOfLines = data.text.split(/\n|\r\n/).length;
            //Use this number to set the minimum height of the div containing the xml editor            
            document.getElementById("xmleditor").style["min-height"] = (nrOfLines * 1.2) + "em";
            iw.log("Nr of lines in pipeline: " + nrOfLines, 3);
            iw.xmleditor.getSession().setValue( data.text , 1);
            iw.xmleditor.resize();
          }
      }, iw.record.error);
    },
    
    setSelectedRecordedInputOutput : function(serviceRunId, direction, stubRunId) {
       //Direction is either 'in', 'out' or 'err'
       iw.log("[setSelectedRecordedInputOutput] runid: " + serviceRunId + "; direction: " + direction + "; stub run id: " + stubRunId, 3);
       let id = serviceRunId + "-" + direction
       if(typeof(stubRunId) === "string") {
          id += "-" + stubRunId;
       }
       this.selectedRecordedInputOutput = id;
    },
    
    //This method is not in use anymore. Delete in a later version (after 1.9.2)
    loadRunData: function(alias, service, id) {
      iw.log("loadRunData: alias: " + alias + "; service: " + service + "; id: " + id + "; show: " + iw.record.showrundata, 3);
    
      if(id === iw.record.recordedRunData.id) {
         iw.record.showrundata = !iw.record.showrundata; //toggle visibility for the same run
         
      } else {               

          if(service.length > 0) {
            let params = {"$alias" : alias, "service-name": service, "service-run-id": id};
            iw.invoke("iw.test.ui.testrun:get", params, function(data){
              if(data["$success"] === "true") {
                iw.record.recordedRunData = data["service-run"];
                iw.record.showrundata = true;
              } else {
                iw.record.showMessage("No run data found for '" + service + ":"+id, false, 2500);
              }            
            }, iw.record.error);
          }                 
       }             
    },
    
    composeDownloadFileLink: function(alias, path) {
      let url = "/invoke/iw.test.ui.testrun/getPipeline?download=true&file-name=" + path;
      if(typeof(alias) === "string" && alias.length > 0) {
          url += "&$alias=" + alias;
      }
      return url;
    },
    
    closeRunDataView: function() {
       iw.record.showrecordedservices = false;
       delete(iw.record.recordedRunData, "id");
    },
    
    deleteRunData: function(alias, service, id) {
       iw.log("About to delete run '" + id + " for service " + service + " on " + alias, 3);
       let params = {"$alias" : alias, "service-name": service, "service-run-id": id};
       iw.invoke("iw.test.ui.testrun:remove", params, function(data){
          if(data["$success"] === "true") {
             //on succes, remove the run from the service run list, without retrieving the whole list again
             //only for the non-local aliases. That one is updated by the 'record-event'
             
             if(alias !== iw.localAlias) {
               let tmpRecordeServiceData =  iw.record.servers[iw.record.alias].services.filter(function(service){return service.name === iw.record.serviceName})[0];
             
               if(tmpRecordeServiceData !== null) tmpRecordeServiceData.runs.filter(function(e){if(e.id !== id) return e});
             }
          } else {
            iw.record.showMessage(data["$message"], false, 3500);
          }            
        });
    }        
  }

  });

   iw.recordApp.component("iwtree-item", {
     template: "#iwtree-item-template",
     props: {
        item: Object,
        stubs: Array
     },
     data: function() {
       return {
         isOpen: true
       }
     },
     computed: {
       hasChildren : function() {
         return this.item.references;
       }
     },
     methods: {
      toggle: function () {
        this.isOpen = !this.isOpen;
      },
      close: function () {
        this.isOpen = false;
      }
     }
   
   });

  //register the global directives
  iw.recordApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.recordApp.component(iw.app.components.menu.name,                   iw.app.components.menu.impl);
  iw.recordApp.component(iw.app.components.confirmModal.name,           iw.app.components.confirmModal.impl);
  iw.recordApp.component(iw.app.components.editTextField.name,          iw.app.components.editTextField.impl);
  iw.recordApp.component(iw.app.components.selectService.name,          iw.app.components.selectService.impl);
  iw.recordApp.component(iw.app.components.selectServiceModal.name,     iw.app.components.selectServiceModal.impl);
  iw.recordApp.component(iw.app.components.selectFile.name,             iw.app.components.selectFile.impl);
  iw.recordApp.component(iw.app.components.selectPackage.name,          iw.app.components.selectPackage.impl);
  iw.recordApp.component(iw.app.components.selectTestSuiteService.name, iw.app.components.selectTestSuiteService.impl); 

  iw.record = iw.recordApp.mount("#record-app");

  iw.record.getInfo();    
  iw.record.getConfig(); 
  iw.record.getSession();
   
})(this, undefined);
      
