
(function(window, undefined) {   
   
  iw.resultsApp = Vue.createApp({

    data : function() {
      return {
        info                    : {
          license                 : {
            product             : "IwTest",
            version             : "1.*",
            licensee            : "",
            type                : "",
            "valid-until"       : "",
            "valid-until-ts"    : -1,
            valid               : true,
            expired             : false,
            "version-ok"        : true,
            "days-left"         : -1
          },
          product :  {
            name                : "",
            version             : "",
            "latest-version"    : "",
            "latest-check-date" : "",
            "installation-date" : "",
            "installation-ts"   : 0
          }
        },
        showResults             : false,
        date                    : "",
        results                 : {},        
        pipelinePopup           : null,
        success                 : true,
        message                 : "",
                                
        config                  : {},
        
        summaryToggle           : false,
        
        testSuiteExpansionList  : []
      }
    },
      
    methods : {
      
      //Use this function for showing the result of actions, not for data retrieval
      response :function(data) {
         iw.log("Logging response from IS", 4);
         iw.log(JSON.stringify(data), 4);
         iw.results.showMessage(data["$message"], data["$success"] === "true" , 2500);        
         iw.results.getTestResults();
      },
    
      error : function(msg) { 
        iw.log(msg, 0);
        iw.results.showMessage(msg, false , 2500);       
      },
      
      showMessage : function(msg, success, timeout) {  
        iw.results.message = msg;
        iw.results.success = success;
        if(typeof(timeout) === "number") {
          setTimeout(function(){iw.results.message=""}, timeout);
        }
      },
      
      hideMessage : function() {
         iw.record.message = "";
      }, 
      
      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.results.info = data;
        });
      },  
      
      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.results.config = data;          
        });        
      },      

      getTestResults   : function() {
        iw.invoke("iw.test.results.pub:get", {}, function(data) {
          iw.log("Loading test results ...", 3);
          iw.log(data, 3);
          //Sort the test suites and the test cases within
          if(data.results.testSuites !== undefined) {
            data.results.testSuites.sort(function(a,b){
              return a.name < b.name ? -1 : 1;
            });
            for(i = 0 ; i < data.results.testSuites.length; i ++) {
              //sort test cases
              data.results.testSuites[i].testCases.sort(
                 function(a,b) {           
                     return a.name < b.name ? -1 : 1;
                 }
              );
              //sort assertions
              data.results.testSuites[i].testCases.map(function(tc){                  
                if(tc.assertions !== undefined) {
                  tc.assertions.sort(function(a,b){
                    return a.name < b.name ? -1 : 1;
                  });                  
                }
              });                                           
            }
          }
          iw.results.results = Object.freeze(data.results);
          
          if(iw.results.showResults === false) iw.results.showResults = true;
          
        }, iw.results.error);
      },
        
      clearTestResults : function() {
        iw.invoke("iw.test.results.pub:clear", {}, function() {
          iw.results.getTestResults();
        }, iw.results.error);
      },  
        
      failedTestCases : function(testSuite) {
          return testSuite.testCases.filter(
            function(tcase) {
               return !tcase.result
            }
          )
      },
      
      nonAlphaNumsToUnderscores : function(text) {
		      // \W matches all non-alphanumeric. Equivalent to [^A-Za-z0-9_]
		      return text.replace(/[\W]+/g, '_');
      },
        
      linkToDefinition : function(testSuiteName, testCaseName) {
        
        return "testsuites.html?testSuiteName=" + encodeURIComponent(testSuiteName)+ "&testCaseName="+ encodeURIComponent(testCaseName.split("::")[0]);
      },
      
      setPipelinePopup(data) {
          iw.log("Setting pipeline popup..", 3);
          this.pipelinePopup = data;
      },

      toggleSummaryVisibility : function() {
        this.summaryToggle = ! this.summaryToggle;
      },
      
      toggleTestSuiteVisibility : function(name) {
        this.testSuiteExpansionList[name] = !this.testSuiteExpansionList[name];
      },        

      setTestSuiteVisibility : function(name, visible) {
        this.testSuiteExpansionList[name] = visible;
      },                
                 
    },      
      
    computed: {
      failedTestSuites: function() {
         return this.results.testSuites.filter(
            function(suite) {
               return suite.failed > 0
            }
         )
      }		
    }
  });
    
  //register the global directives
  iw.resultsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.resultsApp.component(iw.app.components.menu.name,  iw.app.components.menu.impl);

  iw.results = iw.resultsApp.mount('#results-app');

  iw.results.getInfo();
  iw.results.getConfig();
  iw.results.getTestResults();
    
})(this, undefined);


