"use strict";
(function(window, undefined) {
        
  iw.settingsApp = Vue.createApp({
    
    data : function() {
      return {
        message        : "",
        success        : true,
        aliases        : [],
        agents         : [],

        serverAliases  : [],

        alias          : "",
        info           : {},
        config         : {},          
        
        showSettings:  false,
      }
    },
    computed: {
      availableAliases : function() {
          var difference = [];
          var found = false
          
          for (let i = 0 ; i < this.serverAliases.length ; i++) {
             found = false;
             
             for (let j = 0 ; j < this.aliases.length ; j++ ) {
          
                 if(this.aliases[j] === this.serverAliases[i] ) {                   
                     found = true;            
                     break;
                 }
             }
             if(!found && this.serverAliases[i].indexOf("local") < 0 ) {
                 difference.push(iw.settings.serverAliases[i]);
             }
          }        
        return difference;
      }      
    },
      
    methods : {
       
      response :function(data) {
        //console.log("Logging response from IS");
        //console.log(data);
        let timeout = data["$success"] === "true" ? 3000 : 5000;
        iw.settings.showMessage(data["$message"], data["$success"], timeout);
        iw.settings.success = data["$success"] === "true" ? true : false;

      },
      
      showMessage : function(msg, success, timeout) {  
        if(msg) iw.settings.message = msg;
        iw.settings.success = success;
        if(typeof(timeout) === "number") {
           setTimeout(function(){iw.settings.message=""}, timeout);
        }
      },
     
      hideMessage : function() {
         iw.settings.message = "";
      },        

      getConfiguration  : function(show) {
        this.getSettings(show);
        this.getInfo();
      }, 
      
      getInfo : function() {
       iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.settings.info   = data;
        }, iw.settings.error);
      },
      
      getSettings : function(show) {
        iw.invoke("iw.test.config:get", {}, function(data) {
          
          iw.settings.config = data;
           
          if(data["ui.distributed.enabled"] === "true") {
            console.info("Distributed is enabled, going to retrieve agent settings");
            iw.settings.getAgents();
          }
          if(show) {
            iw.settings.showSettings = true;
          }
          iw.log("Configuration loaded", 3)
                      
        });
      },

      saveSettings : function() {
          iw.invoke("iw.test.config:set", iw.settings.config, function(data){            
            iw.settings.response(data);
            iw.settings.getSettings();
          });

      },
      
      saveAgentSettings : function(agent) {
        //console.info("saveAgentSettings called for agent " + agent["$alias"]);

        iw.invoke("iw.test.ui.config:set", agent, function(data){            
          iw.settings.response(data);
          if(data["$success"] !== "true") { 
            iw.settings.getAgents();             
          }
        });

      },
      
      getAgents : function() {
        iw.invoke("iw.test.ui.config:get", {}, function(data){
          iw.settings.agents = data.agents.sort(function(a,b){ if(a.$alias >= b.$alias) return 1; else return -1});;
          iw.log("Agent Configuration loaded", 3)
        
        });
      },
    
      listAliases: function() {
          iw.invoke("iw.test.alias:list", {}, function(data) {
            iw.settings.aliases = data.aliases.sort(function(a,b){ if(a >= b) return 1; else return -1   });   
          });
      },    
    }
  });
   
  //register the global directives
  iw.settingsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.settingsApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);
  iw.settingsApp.component(iw.app.components.confirmModal.name,       iw.app.components.confirmModal.impl);
  iw.settingsApp.component(iw.app.components.editTextField.name,      iw.app.components.editTextField.impl);
  
  iw.settings = iw.settingsApp.mount('#settings-app');
  
  iw.settings.getConfiguration(true);

})(this, undefined);


