"use strict";

(function(window, undefined) {

  if(window.iw === undefined) window.iw = {};

  iw.statsApp = Vue.createApp({

    data : function() {
      return {
        showStats          : false,
        info               : {},
                           
        config             : {},
                           
        localPackages      : [],
                           
        selectedPackage    : null,
        
        pass1               : [],
        pass2               : [],
        pass3               : [],
        packageDetails      : [],
        
        statistics          : [],
        
        filteredStatistics  : [],
        
        totals              : {},
        
        posfilter           : "",
        negfilter           : "",
        
        message             : "",
        success             : true
      }
    },
 
    watch : {

      negfilter : function(currentNegFilter, previousNegFilter) {
         iw.log("Negative Filter changed. New: " + currentNegFilter + "; previous: " + previousNegFilter);
         iw.stats.filterStatsAndCalculateTotals();
      },

      posfilter : function(currentPosFilter, previousPosFilter) {
         iw.log("Positive Filter changed. New: " + currentPosFilter + "; previous: " + previousPosFilter);
         iw.stats.filterStatsAndCalculateTotals();
      }

    },

    methods : {

      getInfo : function() {
        iw.invoke("iw.test.admin:info", {}, function(data) {
          iw.stats.info = data;
        });
      },

      getConfig : function() {
        iw.invoke("iw.test.config:get", {}, function(data) {
          iw.stats.config = data;          
          if(data["generate.test.package.suffix"] !== null && data["generate.test.package.suffix"] !== '') {
            iw.stats.negfilter = ".*" + data["generate.test.package.suffix"]
          } else {
            iw.stats.negfilter = "";
          }
          iw.stats.posfilter = ".*"
          iw.stats.showStats = true;
        });        
      },

      //Retrieves the overall statistics
      getStats : function() {
        let params = {};
        iw.invoke("iw.test.ui.testsuite:getStatistics", params, function(data){

          iw.stats.statistics = Object.freeze(data.statistics);
          iw.stats.filterStatsAndCalculateTotals();
          iw.stats.message = "";

        });
        iw.stats.message = "Working on it ... ";
      },

      filterStatsAndCalculateTotals : function() {
          let nf = '^' + iw.stats.negfilter + '$';
          iw.log("Negative Filtering statistics with regex: " + nf, 3);
          let fs1 = Object.freeze(iw.stats.statistics.filter(function(item){return !item['package'].match(nf)}));

          let pf = '^' + iw.stats.posfilter + '$';
          iw.log("Postive Filtering statistics with regex: " + pf, 3);
          iw.stats.filteredStatistics = Object.freeze(fs1.filter(function(item){return item['package'].match(pf)}));

          iw.stats.totals['nr-of-services']                    = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-services']},0);
          iw.stats.totals['nr-of-regular-services']            = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-regular-services']},0);
          iw.stats.totals['nr-of-services-without-test-cases'] = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-services-without-test-cases']},0);
          iw.stats.totals['nr-of-services-with-test-cases']    = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-services-with-test-cases']},0);
          iw.stats.totals['nr-of-test-suite-services']         = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-test-suite-services']},0);
          iw.stats.totals['nr-of-test-cases']                  = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-test-cases']},0);
          iw.stats.totals['nr-of-enabled-test-cases']          = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-enabled-test-cases']},0);
          iw.stats.totals['nr-of-disabled-test-cases']         = iw.stats.filteredStatistics.reduce(function(a,b){ return a + b['nr-of-disabled-test-cases']},0);
          iw.stats.drawOverallStats();
      },

      getPackageDetails : function(packageName) {
        let params = {"packageName" : packageName };

        iw.invoke("iw.test.ui.testsuite:getPackageDetails", params, function(data){
          
          //Filter out test suites
          iw.stats.services = Object.freeze(data.services.filter(function(d){return d['is-test-suite'] === false}));

          //iw.stats.stats = Array.from(d3.group(iw.stats.services, d => d["service-name"]), ([key, value]) => ({key, value}));
          //Group the 'raw' service by their name
          let pass1   = Array.from(d3.group(iw.stats.services, d => d["service-name"]), function([key, value]){return {key,value}});
          
          //If there is only one entry for a service and if there is no test suite service name, then there are zero test cases
          //Else there are as many as there are members in the group: calculate 'count'  accordingly
          let pass2 = d3.map(pass1, function(item){ 
            item.count = item.value.length;
            if(!item.value[0]["test-suite-service-name"]){
              item.count = 0
            }
            return item
          });
          
          //Group the possibly different test suite services per service (usually there will be only one)
          //Also rename 'key' and 'value'
          let pass3   = d3.map(pass2, function(item){
             item.testSuiteServices = Array.from(d3.group(item.value, e => e["test-suite-service-name"]), function([key,value]){return {key,value}});

             d3.map(item.testSuiteServices, testSuiteService => {testSuiteService.tests = testSuiteService.value; delete(testSuiteService.value); return testSuiteService});
             item.service = item.key;
             delete(item.key);
             delete(item.value);
             return item;
          });  

          iw.stats.packageDetails  = Object.freeze(pass3);
;
          iw.stats.selectedPackage = packageName;
        });

      },

      isFirst : function(index3) {

        return index3 === 0;
      },

      linkToDefinition : function(testSuiteServiceName, testCaseName) {

        return "testsuites.html?testSuiteServiceName=" + encodeURIComponent(testSuiteServiceName) + "&testCaseName=" + encodeURIComponent(testCaseName.split("::")[0]);
      },

      drawOverallStats : function() {

        d3.selectAll('#overallgraph > path').remove();
        d3.selectAll('#overallgraph > text').remove();
        d3.selectAll('#statstable > rect').remove();
        const overallgraph = d3.select("#overallgraph")

        let arcGenerator = d3.arc()
                             .innerRadius(40)
                             .outerRadius(190)
                             .padAngle(.02)
                             .padRadius(100)
                             .cornerRadius(4);

        let swtc   = iw.stats.totals["nr-of-services-with-test-cases"];
        let sntc   = iw.stats.totals["nr-of-services-without-test-cases"];
        let notc   = iw.stats.totals["nr-of-enabled-test-cases"]
        let rsvc   = iw.stats.totals["nr-of-regular-services"];
        let ratio  = rsvc === 0 ? 0 : swtc / rsvc; 
        let ratio2 = notc === 0 ? 0 : swtc / notc;

        let arcPathData1 = arcGenerator({
          startAngle: -0.5 * Math.PI,
          endAngle  : (ratio - 0.5) * Math.PI
        });
        let labelloc1 = arcGenerator.centroid({
          startAngle: -0.5 * Math.PI,
          endAngle  : (ratio - 0.5) * Math.PI
        });
        let arcPathData2 = arcGenerator({
          startAngle: (ratio - 0.5) * Math.PI,
          endAngle  : 0.5 * Math.PI
        });
        let labelloc2 = arcGenerator.centroid({
          startAngle: (ratio - 0.5) * Math.PI,
          endAngle  : 0.5 * Math.PI
        });
        iw.log(arcPathData1);
        iw.log(arcPathData2);
        iw.log(labelloc1);
        iw.log(labelloc2);
        iw.log('ratio: ' + ratio);
        iw.log('ratio2: ' + ratio2);

        overallgraph.append('path' ).attr('d',arcPathData1).attr('fill', 'green').attr('fill-opacity', 1 - ratio2);
        overallgraph.append('path' ).attr('d',arcPathData2).attr('fill', '#A50000').attr('fill-opacity', '0.15');
        overallgraph.append('text' ).text(swtc).attr('x', labelloc1[0]).attr('y', labelloc1[1])
                    .append('title').text(Math.round(ratio * 100) + ' % has test cases');
        overallgraph.append('text' ).text(sntc).attr('x', labelloc2[0]).attr('y', labelloc2[1])
                    .append('title').text(Math.round((1 - ratio) * 100) + ' % has no test cases');
        overallgraph.append('text' ).text(rsvc).attr('x', 190).attr('y', -5 );
          
        Vue.nextTick(this.drawPackageStats); 

      },

      drawPackageStats : function() {
        for(let i = 0; i < iw.stats.filteredStatistics.length ; i++) {
          let swtc   = iw.stats.filteredStatistics[i]["nr-of-services-with-test-cases"];
          let sntc   = iw.stats.filteredStatistics[i]["nr-of-services-without-test-cases"];
          let notc   = iw.stats.filteredStatistics[i]["nr-of-enabled-test-cases"]
          let rsvc   = iw.stats.filteredStatistics[i]["nr-of-regular-services"];
          let ratio  = rsvc === 0 ? 0 : swtc / rsvc; 
          let ratio2 = notc === 0 ? 0 : swtc / notc;
          let pkg    = iw.stats.filteredStatistics[i].package

          d3.selectAll("#packagegraph_" + pkg + " > rect").remove();
          const packageGraph = d3.select("#packagegraph_" + pkg);

          let fwidth = 80;
          let h      = 15;
          let y      =  5

          if(ratio2 > 0) {
            packageGraph.append('rect')
                      .attr('x', 0)
                      .attr('y', y)
                      .attr('width', fwidth * ratio)
                      .attr('height', h)
                      .attr('fill', 'green')
                      .attr('fill-opacity', Math.max(1 - ratio2, 0.2))
                      .append('title').text(Math.round((1/ratio2 * 100))/100 + ' test cases/service');
          }     
          packageGraph.append('rect')
                      .attr('x', fwidth * ratio)
                      .attr('y', y)
                      .attr('width', fwidth * (1 - ratio))
                      .attr('height', h)
                      .attr('fill', "#A50000")
                      .attr('fill-opacity', .3)
                      .append('title').text(Math.round((1-ratio) * 10000)/100 + '% has no test cases');
        }
      },

      getLocalPackages : function() {
        iw.invoke("iw.test.ui.ns:listPackages",{}, function(data){
          iw.stats.localPackages = Object.freeze(data.packages.filter(function(p){
            return p.enabled === "true" && p["system-package"] === "false"
          }));

        });

      }
    }
  });

  //register the global directives
  iw.statsApp.directive(iw.app.directives.focus.name, iw.app.directives.focus.impl);
  //register the global components
  iw.statsApp.component(iw.app.components.menu.name,               iw.app.components.menu.impl);

  iw.stats = iw.statsApp.mount('#stats-app');
 
  iw.stats.getInfo();
  iw.stats.getConfig();
  iw.stats.getLocalPackages();
  iw.stats.getStats();
 })(this, undefined)
